/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.stubs;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.stubs.SnippetStub;
import jdk.graal.compiler.hotspot.word.KlassPointer;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class LookUpSecondarySupersTableStub
extends SnippetStub {
    public static final int SECONDARY_SUPERS_TABLE_SIZE = 64;
    public static final int SECONDARY_SUPERS_TABLE_MASK = 63;
    public static final HotSpotForeignCallDescriptor LOOKUP_SECONDARY_SUPERS_TABLE_SLOW_PATH = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "lookupSecondarySupersTableSlowPath", Boolean.TYPE, KlassPointer.class, Word.class, Long.TYPE, Long.TYPE);

    public LookUpSecondarySupersTableStub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super("lookupSecondarySupersTableSlowPath", options, providers, linkage);
    }

    @Snippet
    @SyncPort(from="https://github.com/openjdk/jdk/blob/03204600c596214895ef86581eba9722f76d39b3/src/hotspot/cpu/x86/macroAssembler_x86.cpp#L4888-L4996", sha1="64e666a1061a5188d6e9df14803aaa5e37be0b7b")
    private static boolean lookupSecondarySupersTableSlowPath(KlassPointer t, Word secondarySupers, long bitmap, long index) {
        int length = secondarySupers.readInt(HotSpotReplacementsUtil.metaspaceArrayLengthOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.METASPACE_ARRAY_LENGTH_LOCATION);
        if (BranchProbabilityNode.probability(0.09999999999999998, length > 62)) {
            for (int i = 0; i < length; ++i) {
                if (!BranchProbabilityNode.probability(0.4, t.equal(LookUpSecondarySupersTableStub.loadSecondarySupersElement(secondarySupers, i)))) continue;
                return true;
            }
            return false;
        }
        long i = index;
        long currentBitmap = bitmap;
        do {
            if (BranchProbabilityNode.probability(0.4, i >= (long)length)) {
                i = 0L;
            }
            if (BranchProbabilityNode.probability(0.4, t.equal(LookUpSecondarySupersTableStub.loadSecondarySupersElement(secondarySupers, i)))) {
                return true;
            }
            currentBitmap = Long.rotateRight(currentBitmap, 1);
            ++i;
        } while (BranchProbabilityNode.probability(0.4, (currentBitmap & 2L) != 0L));
        return false;
    }

    public static KlassPointer loadSecondarySupersElement(Word metaspaceArray, long index) {
        return KlassPointer.fromWord((Pointer)metaspaceArray.readWord((WordBase)WordFactory.signed((long)((long)HotSpotReplacementsUtil.metaspaceArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG) + index * (long)HotSpotReplacementsUtil.wordSize())), HotSpotReplacementsUtil.SECONDARY_SUPERS_ELEMENT_LOCATION));
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native boolean lookupSecondarySupersTableStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1, Word var2, long var3, long var5);

    public static boolean lookupSecondarySupersTableStub(KlassPointer t, Word secondarySupers, long bitmap, long index) {
        return LookUpSecondarySupersTableStub.lookupSecondarySupersTableStub(LOOKUP_SECONDARY_SUPERS_TABLE_SLOW_PATH, t, secondarySupers, bitmap, index);
    }
}

