/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.java;

import java.util.Optional;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.Phase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public abstract class GraphBuilderPhase
extends BasePhase<HighTierContext> {
    private final GraphBuilderConfiguration graphBuilderConfig;

    protected GraphBuilderPhase(GraphBuilderConfiguration config) {
        this.graphBuilderConfig = config;
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    public abstract GraphBuilderPhase copyWithConfig(GraphBuilderConfiguration var1);

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected void run(StructuredGraph graph, HighTierContext context) {
        this.createInstance(context, this.graphBuilderConfig, context.getOptimisticOptimizations(), null).run(graph);
    }

    public GraphBuilderConfiguration getGraphBuilderConfig() {
        return this.graphBuilderConfig;
    }

    protected abstract Instance createInstance(CoreProviders var1, GraphBuilderConfiguration var2, OptimisticOptimizations var3, IntrinsicContext var4);

    public static abstract class Instance
    extends Phase {
        protected final CoreProviders providers;
        protected final GraphBuilderConfiguration graphBuilderConfig;
        protected final OptimisticOptimizations optimisticOpts;
        private final IntrinsicContext initialIntrinsicContext;

        protected Instance(CoreProviders providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            this.graphBuilderConfig = graphBuilderConfig;
            this.optimisticOpts = optimisticOpts;
            this.providers = providers;
            this.initialIntrinsicContext = initialIntrinsicContext;
        }

        @Override
        public boolean checkContract() {
            return false;
        }

        @Override
        public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
            return ALWAYS_APPLICABLE;
        }

        @Override
        protected void run(StructuredGraph graph) {
            this.createBytecodeParser(graph, null, graph.method(), graph.getEntryBCI(), this.initialIntrinsicContext).buildRootMethod();
        }

        protected abstract BytecodeParser createBytecodeParser(StructuredGraph var1, BytecodeParser var2, ResolvedJavaMethod var3, int var4, IntrinsicContext var5);
    }
}

