/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir;

import java.util.ArrayList;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.PostAllocationOptimizationPhase;
import jdk.vm.ci.code.TargetDescription;

public final class ControlFlowOptimizer
extends PostAllocationOptimizationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        LIR lir = lirGenRes.getLIR();
        new Optimizer(lir, lirGenRes.emitIndirectTargetBranchMarkers()).deleteEmptyBlocks(lir.getBlocks());
    }

    private static final class Optimizer {
        private final LIR lir;
        private final boolean preserveIndirectBranchTargetMarkers;
        private static final CounterKey BLOCKS_DELETED = DebugContext.counter("BlocksDeleted");

        private Optimizer(LIR lir, boolean preserveIndirectBranchTargetMarkers) {
            this.lir = lir;
            this.preserveIndirectBranchTargetMarkers = preserveIndirectBranchTargetMarkers;
        }

        private boolean canDeleteBlock(BasicBlock<?> block) {
            if (block == null || block.getSuccessorCount() != 1 || block.getPredecessorCount() == 0 || block.getSuccessorAt(0) == block) {
                return false;
            }
            if (this.preserveIndirectBranchTargetMarkers && block.isIndirectBranchTarget()) {
                return false;
            }
            ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
            assert (instructions.size() >= 2) : "block must have label and branch";
            assert (instructions.get(0) instanceof StandardOp.LabelOp) : "first instruction must always be a label";
            assert (instructions.get(instructions.size() - 1) instanceof StandardOp.JumpOp) : "last instruction must always be a branch";
            assert (((StandardOp.JumpOp)instructions.get(instructions.size() - 1)).destination().label() == ((StandardOp.LabelOp)this.lir.getLIRforBlock((BasicBlock<?>)block.getSuccessorAt(0)).get(0)).getLabel()) : "branch target must be the successor";
            return instructions.size() == 2 && !instructions.get(instructions.size() - 1).hasState() && !block.isExceptionEntry();
        }

        private StandardOp.LabelOp getLabel(BasicBlock<?> block) {
            ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
            assert (instructions.get(0) instanceof StandardOp.LabelOp) : "first instruction must always be a label";
            return (StandardOp.LabelOp)instructions.get(0);
        }

        private void copyAlignment(BasicBlock<?> from, BasicBlock<?> block) {
            if (from.isAligned() && !block.isAligned()) {
                block.setAlign(true);
                this.getLabel(block).setAlignment(this.getLabel(from).getAlignment());
            }
        }

        private void deleteEmptyBlocks(int[] blocks) {
            assert (LIR.verifyBlocks(this.lir, blocks));
            for (int i = 0; i < blocks.length; ++i) {
                BasicBlock<?> block = this.lir.getBlockById(blocks[i]);
                if (!this.canDeleteBlock(block)) continue;
                block.delete();
                Object other = block.getSuccessorAt(0);
                this.copyAlignment(block, (BasicBlock<?>)other);
                BLOCKS_DELETED.increment(this.lir.getDebug());
                blocks[i] = Integer.MAX_VALUE;
            }
            assert (LIR.verifyBlocks(this.lir, blocks));
        }
    }
}

