/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public class AArch64BitFieldOp
extends AArch64LIRInstruction {
    private static final LIRInstructionClass<AArch64BitFieldOp> TYPE = LIRInstructionClass.create(AArch64BitFieldOp.class);
    @Opcode
    private final BitFieldOpCode opcode;
    @LIRInstruction.Def
    protected AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue input;
    private final int lsb;
    private final int width;

    public AArch64BitFieldOp(BitFieldOpCode opcode, AllocatableValue result, AllocatableValue input, int lsb, int width) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.opcode = opcode;
        this.result = result;
        this.input = input;
        this.lsb = lsb;
        this.width = width;
    }

    @Override
    protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.result);
        Register src = ValueUtil.asRegister((Value)this.input);
        int size = this.result.getPlatformKind().getSizeInBytes() * 8;
        switch (this.opcode.ordinal()) {
            case 0: {
                masm.sbfm(size, dst, src, this.lsb, this.lsb + this.width - 1);
                break;
            }
            case 1: {
                masm.sbfm(size, dst, src, size - this.lsb, this.width - 1);
                break;
            }
            case 2: {
                masm.ubfm(size, dst, src, this.lsb, this.lsb + this.width - 1);
                break;
            }
            case 3: {
                masm.ubfm(size, dst, src, size - this.lsb, this.width - 1);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.opcode);
            }
        }
    }

    public static enum BitFieldOpCode {
        SBFX,
        SBFIZ,
        UBFX,
        UBFIZ;

    }
}

