/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;

public class AArch64BitManipulationOp
extends AArch64LIRInstruction {
    private static final LIRInstructionClass<AArch64BitManipulationOp> TYPE = LIRInstructionClass.create(AArch64BitManipulationOp.class);
    @Opcode
    private final BitManipulationOpCode opcode;
    @LIRInstruction.Def
    protected AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue input;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value temp;

    public AArch64BitManipulationOp(LIRGeneratorTool tool, BitManipulationOpCode opcode, AllocatableValue result, AllocatableValue input) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.opcode = opcode;
        this.result = result;
        this.input = input;
        this.temp = BitManipulationOpCode.POPCNT == opcode ? tool.newVariable(LIRKind.value((PlatformKind)AArch64Kind.V64_BYTE)) : Value.ILLEGAL;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.result);
        Register src = ValueUtil.asRegister((Value)this.input);
        int size = this.input.getPlatformKind().getSizeInBytes() * 8;
        switch (this.opcode.ordinal()) {
            case 3: {
                masm.clz(size, dst, src);
                break;
            }
            case 1: {
                masm.clz(size, dst, src);
                masm.neg(size, dst, dst);
                masm.add(size, dst, dst, size - 1);
                break;
            }
            case 0: {
                masm.rbit(size, dst, src);
                masm.clz(size, dst, dst);
                break;
            }
            case 2: {
                masm.rev(size, dst, src);
                break;
            }
            case 4: {
                assert (!Value.ILLEGAL.equals((Object)this.temp)) : "Auxiliary register not allocated.";
                Register vreg = ValueUtil.asRegister((Value)this.temp);
                masm.popcnt(size, dst, src, vreg);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.opcode);
            }
        }
    }

    public static enum BitManipulationOpCode {
        CTZ,
        BSR,
        BSWP,
        CLZ,
        POPCNT;

    }
}

