/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public class AArch64ByteSwap {

    @Opcode(value="BSWAP")
    public static class ASIMDByteSwapOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<ASIMDByteSwapOp> TYPE = LIRInstructionClass.create(ASIMDByteSwapOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;

        public ASIMDByteSwapOp(AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (((AArch64Kind)result.getPlatformKind()).getScalar().isInteger());
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            masm.neon.revVV(size, eSize, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input));
        }
    }

    @Opcode(value="BSWAP")
    public static class ByteSwapOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<ByteSwapOp> TYPE = LIRInstructionClass.create(ByteSwapOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;

        public ByteSwapOp(AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            AArch64Kind kind = (AArch64Kind)input.getPlatformKind();
            assert (kind == AArch64Kind.DWORD || kind == AArch64Kind.QWORD) : kind;
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int size = this.input.getPlatformKind().getSizeInBytes() * 8;
            masm.rev(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input));
        }
    }
}

