/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.gen.LIRGenerator;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public abstract class AArch64MathIntrinsicBinaryOp
extends AArch64LIRInstruction {
    @LIRInstruction.Def
    protected Value output;
    @LIRInstruction.Use
    protected Value input0 = AArch64.v0.asValue((ValueKind)LIRKind.value((PlatformKind)AArch64Kind.V64_WORD));
    @LIRInstruction.Use
    protected Value input1 = AArch64.v0.asValue((ValueKind)LIRKind.value((PlatformKind)AArch64Kind.V64_WORD));
    @LIRInstruction.Temp
    protected Value[] temps;

    public AArch64MathIntrinsicBinaryOp(LIRInstructionClass<? extends AArch64LIRInstruction> type, Register ... registers) {
        super(type);
        this.output = AArch64.v0.asValue((ValueKind)LIRKind.value((PlatformKind)AArch64Kind.V64_WORD));
        this.temps = AArch64MathIntrinsicBinaryOp.registersToValues(registers);
    }

    protected static Value[] registersToValues(Register[] registers) {
        Value[] temps = new Value[registers.length];
        for (int i = 0; i < registers.length; ++i) {
            Register register = registers[i];
            if (AArch64.CPU.equals((Object)register.getRegisterCategory())) {
                temps[i] = register.asValue((ValueKind)LIRKind.value((PlatformKind)AArch64Kind.V64_WORD));
                continue;
            }
            if (AArch64.SIMD.equals((Object)register.getRegisterCategory())) {
                temps[i] = register.asValue((ValueKind)LIRKind.value((PlatformKind)AArch64Kind.V64_WORD));
                continue;
            }
            throw GraalError.shouldNotReachHere("Unsupported register type in math stubs.");
        }
        return temps;
    }

    public final Variable emitLIRWrapper(LIRGenerator gen, Value x, Value y) {
        LIRKind kind = LIRKind.combine(x, y);
        RegisterValue v0value = AArch64.v0.asValue((ValueKind)kind);
        gen.emitMove((AllocatableValue)v0value, x);
        RegisterValue v1value = AArch64.v1.asValue((ValueKind)kind);
        gen.emitMove((AllocatableValue)v1value, y);
        gen.append(this);
        Variable result = gen.newVariable(kind);
        gen.emitMove(result, (Value)v0value);
        return result;
    }
}

