/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import java.util.function.Function;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.memory.MemoryExtendKind;
import jdk.graal.compiler.core.common.spi.LIRKindTool;
import jdk.graal.compiler.core.common.type.DataPointerConstant;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.lir.aarch64.AArch64AddressValue;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;

public class AArch64Move {
    public static int moveSPAndEmitStore(AArch64MacroAssembler masm, Register input, Function<Register, Integer> storeGen) {
        if (input.equals((Object)AArch64.sp)) {
            try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
                Register newInput = scratch.getRegister();
                masm.mov(64, newInput, AArch64.sp);
                int n = storeGen.apply(newInput);
                return n;
            }
        }
        return storeGen.apply(input);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void move(AArch64Kind moveKind, CompilationResultBuilder crb, AArch64MacroAssembler masm, AllocatableValue result, Value input) {
        if (ValueUtil.isRegister((Value)input)) {
            Register src = ValueUtil.asRegister((Value)input);
            if (ValueUtil.isRegister((Value)result)) {
                AArch64Move.reg2reg(moveKind, masm, ValueUtil.asRegister((Value)result), src);
                return;
            } else {
                if (!ValueUtil.isStackSlot((Value)result)) throw GraalError.shouldNotReachHereUnexpectedValue(result);
                AArch64Move.reg2stack(moveKind, crb, masm, ValueUtil.asStackSlot((Value)result), src);
            }
            return;
        } else if (ValueUtil.isStackSlot((Value)input)) {
            StackSlot src = ValueUtil.asStackSlot((Value)input);
            if (ValueUtil.isRegister((Value)result)) {
                AArch64Move.stack2reg(moveKind, crb, masm, ValueUtil.asRegister((Value)result), src);
                return;
            } else {
                if (!ValueUtil.isStackSlot((Value)result)) throw GraalError.shouldNotReachHereUnexpectedValue(result);
                AArch64Move.stack2stack(moveKind, crb, masm, ValueUtil.asStackSlot((Value)result), src);
            }
            return;
        } else {
            if (!LIRValueUtil.isJavaConstant(input)) throw GraalError.shouldNotReachHereUnexpectedValue(input);
            if (!ValueUtil.isRegister((Value)result)) throw GraalError.shouldNotReachHereUnexpectedValue(result);
            AArch64Move.const2reg(moveKind, crb, masm, ValueUtil.asRegister((Value)result), LIRValueUtil.asJavaConstant(input));
        }
    }

    private static void stack2stack(AArch64Kind moveKind, CompilationResultBuilder crb, AArch64MacroAssembler masm, StackSlot result, StackSlot input) {
        try (AArch64MacroAssembler.ScratchRegister r1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister r2 = masm.getScratchRegister();){
            Register rscratch1 = r1.getRegister();
            Register rscratch2 = r2.getRegister();
            crb.blockComment("[stack -> stack copy]");
            int loadSize = AArch64Move.determineStackSlotLoadSize(moveKind, input, rscratch1);
            AArch64Address src = AArch64Move.createStackSlotLoadAddress(loadSize, crb, masm, input, rscratch2);
            masm.ldr(loadSize, rscratch1, src);
            int storeSize = moveKind.getSizeInBytes() * 8;
            AArch64Address dst = AArch64Move.createStackSlotStoreAddress(storeSize, crb, masm, result, rscratch2);
            masm.str(storeSize, rscratch1, dst);
        }
    }

    private static void reg2reg(AArch64Kind moveKind, AArch64MacroAssembler masm, Register result, Register input) {
        if (input.equals((Object)result)) {
            return;
        }
        int size = moveKind.getSizeInBytes() * 8;
        assert (size == 32 || size == 64 || size == 128) : size;
        if (result.getRegisterCategory().equals((Object)AArch64.CPU) && input.getRegisterCategory().equals((Object)AArch64.CPU)) {
            masm.mov(size, result, input);
        } else if (size == 128) {
            assert (result.getRegisterCategory().equals((Object)AArch64.SIMD) && input.getRegisterCategory().equals((Object)AArch64.SIMD)) : Assertions.errorMessageContext("result", result, "input", input);
            masm.neon.moveVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, result, input);
        } else {
            masm.fmov(size, result, input);
        }
    }

    static void reg2stack(AArch64Kind moveKind, CompilationResultBuilder crb, AArch64MacroAssembler masm, StackSlot result, Register input) {
        try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
            int size = moveKind.getSizeInBytes() * 8;
            AArch64Address dest = AArch64Move.createStackSlotStoreAddress(size, crb, masm, result, scratch.getRegister());
            if (input.getRegisterCategory().equals((Object)AArch64.CPU)) {
                masm.str(size, input, dest);
            } else {
                assert (input.getRegisterCategory().equals((Object)AArch64.SIMD));
                masm.fstr(size, input, dest);
            }
        }
    }

    static void stack2reg(AArch64Kind moveKind, CompilationResultBuilder crb, AArch64MacroAssembler masm, Register result, StackSlot input) {
        int size = AArch64Move.determineStackSlotLoadSize(moveKind, input, result);
        if (result.getRegisterCategory().equals((Object)AArch64.CPU)) {
            AArch64Address src = AArch64Move.createStackSlotLoadAddress(size, crb, masm, input, result);
            masm.ldr(size, result, src);
        } else {
            assert (result.getRegisterCategory().equals((Object)AArch64.SIMD));
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                AArch64Address src = AArch64Move.createStackSlotLoadAddress(size, crb, masm, input, sc.getRegister());
                masm.fldr(size, result, src);
            }
        }
    }

    static void const2reg(AArch64Kind moveKind, CompilationResultBuilder crb, AArch64MacroAssembler masm, Register result, JavaConstant input) {
        JavaKind stackKind = input.getJavaKind().getStackKind();
        assert (stackKind.isObject() || moveKind.getSizeInBytes() <= stackKind.getByteCount()) : Assertions.errorMessageContext("stackKind", stackKind, "moveKind", moveKind);
        switch (stackKind) {
            case Int: {
                masm.mov(result, input.asInt());
                break;
            }
            case Long: {
                masm.mov(result, input.asLong());
                break;
            }
            case Float: {
                if (AArch64MacroAssembler.isFloatImmediate(input.asFloat()) && result.getRegisterCategory().equals((Object)AArch64.SIMD)) {
                    masm.fmov(32, result, input.asFloat());
                    break;
                }
                if (result.getRegisterCategory().equals((Object)AArch64.CPU)) {
                    masm.mov(result, Float.floatToRawIntBits(input.asFloat()));
                    break;
                }
                try (AArch64MacroAssembler.ScratchRegister scr = masm.getScratchRegister();){
                    Register scratch = scr.getRegister();
                    masm.mov(scratch, Float.floatToRawIntBits(input.asFloat()));
                    masm.fmov(32, result, scratch);
                    break;
                }
            }
            case Double: {
                if (AArch64MacroAssembler.isDoubleImmediate(input.asDouble()) && result.getRegisterCategory().equals((Object)AArch64.SIMD)) {
                    masm.fmov(64, result, input.asDouble());
                    break;
                }
                if (result.getRegisterCategory().equals((Object)AArch64.CPU)) {
                    masm.mov(result, Double.doubleToRawLongBits(input.asDouble()));
                    break;
                }
                try (AArch64MacroAssembler.ScratchRegister scr = masm.getScratchRegister();){
                    Register scratch = scr.getRegister();
                    masm.mov(scratch, Double.doubleToRawLongBits(input.asDouble()));
                    masm.fmov(64, result, scratch);
                    break;
                }
            }
            case Object: {
                if (input.isNull()) {
                    if (crb.mustReplaceWithUncompressedNullRegister(input)) {
                        masm.mov(64, result, crb.uncompressedNullRegister);
                        break;
                    }
                    masm.mov(result, 0);
                    break;
                }
                if (crb.target.inlineObjects) {
                    crb.recordInlineDataInCode((Constant)input);
                    masm.mov(result, -2401018187971961171L, true);
                    break;
                }
                crb.recordDataReferenceInCode((Constant)input, 8);
                masm.adrpLdr(64, result, result);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("kind=" + String.valueOf(input.getJavaKind().getStackKind()));
            }
        }
    }

    static void const2stack(AArch64Kind moveKind, CompilationResultBuilder crb, AArch64MacroAssembler masm, StackSlot result, JavaConstant constant) {
        if (constant.isNull() && !crb.mustReplaceWithUncompressedNullRegister(constant)) {
            AArch64Move.reg2stack(moveKind, crb, masm, result, AArch64.zr);
        } else {
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register scratch = sc.getRegister();
                AArch64Move.const2reg(moveKind, crb, masm, scratch, constant);
                AArch64Move.reg2stack(moveKind, crb, masm, result, scratch);
            }
        }
    }

    private static int determineStackSlotLoadSize(AArch64Kind originalLoadKind, StackSlot slot, Register targetReg) {
        int slotBitSize = slot.getPlatformKind().getSizeInBytes() * 8;
        int accessBitSize = originalLoadKind.getSizeInBytes() * 8;
        assert (accessBitSize <= slotBitSize) : Assertions.errorMessageContext("accessBitSize", accessBitSize, "slotBitSize", slotBitSize);
        assert (targetReg.getRegisterCategory().equals((Object)AArch64.SIMD) || accessBitSize <= 64) : Assertions.errorMessageContext("targetReg", targetReg, "accessBitSize", accessBitSize);
        if (accessBitSize == slotBitSize || targetReg.getRegisterCategory().equals((Object)AArch64.SIMD)) {
            return slotBitSize;
        }
        assert (targetReg.getRegisterCategory().equals((Object)AArch64.CPU)) : Assertions.errorMessageContext("targetReg", targetReg);
        return Integer.min(slotBitSize, 64);
    }

    private static AArch64Address createStackSlotLoadAddress(int size, CompilationResultBuilder crb, AArch64MacroAssembler masm, StackSlot slot, Register scratchReg) {
        return AArch64Move.createStackSlotAddress(size, crb, masm, slot, scratchReg, true);
    }

    private static AArch64Address createStackSlotStoreAddress(int size, CompilationResultBuilder crb, AArch64MacroAssembler masm, StackSlot slot, Register scratchReg) {
        return AArch64Move.createStackSlotAddress(size, crb, masm, slot, scratchReg, false);
    }

    private static AArch64Address createStackSlotAddress(int size, CompilationResultBuilder crb, AArch64MacroAssembler masm, StackSlot slot, Register scratchReg, boolean isLoad) {
        int displacement = crb.frameMap.offsetForStackSlot(slot);
        if (isLoad ? !$assertionsDisabled && size > slot.getPlatformKind().getSizeInBytes() * 8 : !$assertionsDisabled && size != slot.getPlatformKind().getSizeInBytes() * 8) {
            throw new AssertionError((Object)Assertions.errorMessageContext("size", size, "slot", slot));
        }
        return masm.makeAddress(size, AArch64.sp, displacement, scratchReg);
    }

    public static class ConvertZeroToNullOp
    extends ZeroNullConversionOp {
        public static final LIRInstructionClass<ConvertZeroToNullOp> TYPE = LIRInstructionClass.create(ConvertZeroToNullOp.class);

        public ConvertZeroToNullOp(AllocatableValue result, AllocatableValue input) {
            super(TYPE, result, input);
        }

        @Override
        protected final void emitConversion(Register resultRegister, Register inputRegister, Register nullRegister, AArch64MacroAssembler masm) {
            masm.cmp(64, inputRegister, AArch64.zr);
            masm.csel(64, resultRegister, nullRegister, inputRegister, AArch64Assembler.ConditionFlag.EQ);
        }
    }

    public static class ConvertNullToZeroOp
    extends ZeroNullConversionOp {
        public static final LIRInstructionClass<ConvertNullToZeroOp> TYPE = LIRInstructionClass.create(ConvertNullToZeroOp.class);

        public ConvertNullToZeroOp(AllocatableValue result, AllocatableValue input) {
            super(TYPE, result, input);
        }

        @Override
        protected final void emitConversion(Register resultRegister, Register inputRegister, Register nullRegister, AArch64MacroAssembler masm) {
            masm.cmp(64, inputRegister, nullRegister);
            masm.csel(64, resultRegister, AArch64.zr, inputRegister, AArch64Assembler.ConditionFlag.EQ);
        }
    }

    private static abstract class ZeroNullConversionOp
    extends AArch64LIRInstruction {
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;

        protected ZeroNullConversionOp(LIRInstructionClass<? extends ZeroNullConversionOp> type, AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)type);
            this.result = result;
            this.input = input;
            int inputSize = input.getPlatformKind().getSizeInBytes() * 8;
            int resultSize = result.getPlatformKind().getSizeInBytes() * 8;
            assert (inputSize == resultSize && resultSize == 64) : Assertions.errorMessageContext("inputSize", inputSize, "resultSize", resultSize, "result", result, "input", input);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register nullRegister = crb.uncompressedNullRegister;
            Register resultReg = ValueUtil.asRegister((Value)this.result);
            Register inputReg = ValueUtil.asRegister((Value)this.input);
            if (!nullRegister.equals((Object)Register.None)) {
                this.emitConversion(ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input), nullRegister, masm);
            } else {
                masm.mov(64, resultReg, inputReg);
            }
        }

        protected abstract void emitConversion(Register var1, Register var2, Register var3, AArch64MacroAssembler var4);
    }

    public static class UncompressPointerOp
    extends PointerCompressionOp {
        public static final LIRInstructionClass<UncompressPointerOp> TYPE = LIRInstructionClass.create(UncompressPointerOp.class);
        private final boolean uncompress32To64Bits;

        public UncompressPointerOp(AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            super(TYPE, result, input, baseRegister, encoding, nonNull, lirKindTool);
            boolean bl = this.uncompress32To64Bits = input.getPlatformKind().getSizeInBytes() != result.getPlatformKind().getSizeInBytes();
            if (this.uncompress32To64Bits ? !$assertionsDisabled && !input.getPlatformKind().equals((Object)AArch64Kind.DWORD) : !$assertionsDisabled && !input.getPlatformKind().equals((Object)AArch64Kind.QWORD)) {
                throw new AssertionError();
            }
            assert (result.getPlatformKind().equals((Object)AArch64Kind.QWORD));
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register inputRegister = ValueUtil.asRegister((Value)this.getInput());
            Register resultRegister = this.getResultRegister();
            Register base = this.encoding.hasBase() ? this.getBaseRegister() : null;
            UncompressPointerOp.emitUncompressCode(masm, inputRegister, resultRegister, this.encoding, this.nonNull, base, this.uncompress32To64Bits);
        }

        public static void emitUncompressCode(AArch64MacroAssembler masm, Register inputRegister, Register resultRegister, CompressEncoding encoding, boolean nonNull, Register base, boolean uncompress32To64Bits) {
            if (nonNull || !encoding.hasBase()) {
                Register src;
                if (uncompress32To64Bits) {
                    masm.mov(32, resultRegister, inputRegister);
                    src = resultRegister;
                } else {
                    src = inputRegister;
                }
                masm.add(64, resultRegister, encoding.hasBase() ? base : AArch64.zr, src, AArch64Assembler.ShiftType.LSL, encoding.getShift());
            } else {
                Label done = new Label();
                masm.mov(uncompress32To64Bits ? 32 : 64, resultRegister, inputRegister);
                masm.cbz(64, resultRegister, done);
                masm.add(64, resultRegister, base, resultRegister, AArch64Assembler.ShiftType.LSL, encoding.getShift());
                masm.bind(done);
            }
        }
    }

    public static class CompressPointerOp
    extends PointerCompressionOp {
        public static final LIRInstructionClass<CompressPointerOp> TYPE = LIRInstructionClass.create(CompressPointerOp.class);

        public CompressPointerOp(AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            super(TYPE, result, input, baseRegister, encoding, nonNull, lirKindTool);
            assert (input.getPlatformKind().equals((Object)AArch64Kind.QWORD));
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register resultRegister = this.getResultRegister();
            Register ptr = ValueUtil.asRegister((Value)this.getInput());
            Register base = this.getBaseRegister();
            if (!this.encoding.hasBase()) {
                if (this.encoding.hasShift()) {
                    masm.lsr(64, resultRegister, ptr, this.encoding.getShift());
                } else {
                    masm.mov(64, resultRegister, ptr);
                }
            } else if (this.nonNull) {
                masm.sub(64, resultRegister, ptr, base);
                if (this.encoding.hasShift()) {
                    masm.lsr(64, resultRegister, resultRegister, this.encoding.getShift());
                }
            } else {
                masm.compare(64, ptr, 0);
                masm.csel(64, resultRegister, ptr, base, AArch64Assembler.ConditionFlag.NE);
                masm.sub(64, resultRegister, resultRegister, base);
                if (this.encoding.hasShift()) {
                    masm.lsr(64, resultRegister, resultRegister, this.encoding.getShift());
                }
            }
        }
    }

    public static abstract class PointerCompressionOp
    extends AArch64LIRInstruction {
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        private AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        private Value input;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL, LIRInstruction.OperandFlag.UNINITIALIZED})
        private AllocatableValue baseRegister;
        protected final CompressEncoding encoding;
        protected final boolean nonNull;
        protected final LIRKindTool lirKindTool;

        protected PointerCompressionOp(LIRInstructionClass<? extends PointerCompressionOp> type, AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)type);
            this.result = result;
            this.input = input;
            this.baseRegister = baseRegister;
            this.encoding = encoding;
            this.nonNull = nonNull;
            this.lirKindTool = lirKindTool;
        }

        public static boolean hasBase(CompressEncoding encoding) {
            return encoding.hasBase();
        }

        public final Value getInput() {
            return this.input;
        }

        public final AllocatableValue getResult() {
            return this.result;
        }

        protected final Register getResultRegister() {
            return ValueUtil.asRegister((Value)this.result);
        }

        protected final Register getBaseRegister() {
            return PointerCompressionOp.hasBase(this.encoding) ? ValueUtil.asRegister((Value)this.baseRegister) : Register.None;
        }

        protected final int getShift() {
            return this.encoding.getShift();
        }
    }

    public static final class NullCheckOp
    extends AArch64LIRInstruction
    implements StandardOp.NullCheck {
        public static final LIRInstructionClass<NullCheckOp> TYPE = LIRInstructionClass.create(NullCheckOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AArch64AddressValue address;
        @LIRInstruction.State
        protected LIRFrameState state;

        public NullCheckOp(AArch64AddressValue address, LIRFrameState state) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.address = address;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int loadPosition = masm.position();
            masm.deadLoad(64, this.address.toAddress(), crb.getLastImplicitExceptionOffset() == loadPosition - 4);
            if (loadPosition == masm.position()) {
                GraalError.guarantee(masm.isImmLoadStoreMerged() && crb.getLastImplicitExceptionOffset() == loadPosition - 4, "Missing state for implicit exception.");
                return;
            }
            crb.recordImplicitException(loadPosition, this.state);
        }

        @Override
        public Value getCheckedValue() {
            return this.address.base;
        }

        @Override
        public LIRFrameState getState() {
            return this.state;
        }
    }

    public static final class StoreReleaseOp
    extends MemOp {
        public static final LIRInstructionClass<StoreReleaseOp> TYPE = LIRInstructionClass.create(StoreReleaseOp.class);
        @LIRInstruction.Use
        protected AllocatableValue input;

        public StoreReleaseOp(AArch64Kind accessKind, AArch64AddressValue address, AllocatableValue input, LIRFrameState state) {
            super(TYPE, accessKind, address, state);
            this.input = input;
        }

        @Override
        protected int emitMemAccess(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int destSize = this.accessKind.getSizeInBytes() * 8;
            return AArch64Move.moveSPAndEmitStore(masm, ValueUtil.asRegister((Value)this.input), src -> {
                try (AArch64MacroAssembler.ScratchRegister scratch1 = masm.getScratchRegister();){
                    int memPosition;
                    Register addrReg;
                    AArch64Address address = this.addressValue.toAddress();
                    if (address.isBaseRegisterOnly()) {
                        addrReg = address.getBase();
                    } else {
                        addrReg = scratch1.getRegister();
                        masm.loadAddress(addrReg, address);
                    }
                    if (this.accessKind.isInteger()) {
                        memPosition = masm.position();
                        masm.stlr(destSize, (Register)src, addrReg);
                    } else {
                        try (AArch64MacroAssembler.ScratchRegister scratch2 = masm.getScratchRegister();){
                            Register temp = scratch2.getRegister();
                            masm.fmov(destSize, temp, (Register)src);
                            memPosition = masm.position();
                            masm.stlr(destSize, temp, addrReg);
                        }
                    }
                    Integer n = memPosition;
                    return n;
                }
            });
        }

        public AArch64Kind getAccessKind() {
            return this.accessKind;
        }
    }

    public static final class StoreOp
    extends MemOp {
        public static final LIRInstructionClass<StoreOp> TYPE = LIRInstructionClass.create(StoreOp.class);
        @LIRInstruction.Use
        protected AllocatableValue input;

        public StoreOp(AArch64Kind accessKind, AArch64AddressValue address, AllocatableValue input, LIRFrameState state) {
            super(TYPE, accessKind, address, state);
            this.input = input;
        }

        @Override
        protected int emitMemAccess(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int destSize = this.accessKind.getSizeInBytes() * 8;
            AArch64Address address = this.addressValue.toAddress();
            return AArch64Move.moveSPAndEmitStore(masm, ValueUtil.asRegister((Value)this.input), src -> {
                int memPosition = masm.position();
                boolean tryMerge = this.mergingAllowed(crb, memPosition);
                if (this.accessKind.isInteger()) {
                    masm.str(destSize, (Register)src, address, tryMerge);
                } else {
                    masm.fstr(destSize, (Register)src, address, tryMerge);
                }
                return memPosition;
            });
        }
    }

    public static final class StoreZeroOp
    extends MemOp {
        public static final LIRInstructionClass<StoreZeroOp> TYPE = LIRInstructionClass.create(StoreZeroOp.class);

        public StoreZeroOp(AArch64Kind accessKind, AArch64AddressValue address, LIRFrameState state) {
            super(TYPE, accessKind, address, state);
            assert (accessKind.getSizeInBytes() <= 8) : accessKind;
        }

        @Override
        public int emitMemAccess(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int destSize = this.accessKind.getSizeInBytes() * 8;
            AArch64Address address = this.addressValue.toAddress();
            int memPosition = masm.position();
            masm.str(destSize, AArch64.zr, address, this.mergingAllowed(crb, memPosition));
            return memPosition;
        }
    }

    public static final class LoadAcquireOp
    extends ExtendableLoadOp {
        public static final LIRInstructionClass<LoadAcquireOp> TYPE = LIRInstructionClass.create(LoadAcquireOp.class);

        public LoadAcquireOp(AArch64Kind accessKind, MemoryExtendKind extendKind, AllocatableValue result, AArch64AddressValue address, LIRFrameState state) {
            super(TYPE, accessKind, extendKind, result, address, state);
        }

        @Override
        protected int emitMemAccess(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int srcBitSize = this.accessKind.getSizeInBytes() * 8;
            if (this.extend.isExtended()) {
                assert (this.accessKind.isInteger());
                assert (this.extend.isZeroExtend());
                assert (this.extend.getExtendedBitSize() >= srcBitSize) : Assertions.errorMessageContext("extend", (Object)this.extend, "srcBitSize", srcBitSize);
            }
            Register dst = ValueUtil.asRegister((Value)this.result);
            try (AArch64MacroAssembler.ScratchRegister scratch1 = masm.getScratchRegister();){
                Register addrReg;
                AArch64Address address = this.addressValue.toAddress();
                if (address.isBaseRegisterOnly()) {
                    addrReg = address.getBase();
                } else {
                    addrReg = scratch1.getRegister();
                    masm.loadAddress(addrReg, address);
                }
                int memPosition = masm.position();
                if (this.accessKind.isInteger()) {
                    masm.ldar(srcBitSize, dst, addrReg);
                } else {
                    assert (srcBitSize == this.result.getPlatformKind().getSizeInBytes() * 8) : Assertions.errorMessage(srcBitSize, this.result);
                    try (AArch64MacroAssembler.ScratchRegister scratch2 = masm.getScratchRegister();){
                        Register temp = scratch2.getRegister();
                        masm.ldar(srcBitSize, temp, addrReg);
                        masm.fmov(srcBitSize, dst, temp);
                    }
                }
                int n = memPosition;
                return n;
            }
        }

        public AArch64Kind getAccessKind() {
            return this.accessKind;
        }
    }

    public static final class LoadOp
    extends ExtendableLoadOp {
        public static final LIRInstructionClass<LoadOp> TYPE = LIRInstructionClass.create(LoadOp.class);

        public LoadOp(AArch64Kind accessKind, MemoryExtendKind extendKind, AllocatableValue result, AArch64AddressValue address, LIRFrameState state) {
            super(TYPE, accessKind, extendKind, result, address, state);
        }

        @Override
        protected int emitMemAccess(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int memPosition;
            block11: {
                boolean tryMerge;
                int srcBitSize;
                Register dst;
                AArch64Address address;
                block10: {
                    int dstBitSize;
                    address = this.addressValue.toAddress();
                    dst = ValueUtil.asRegister((Value)this.result);
                    srcBitSize = this.accessKind.getSizeInBytes() * 8;
                    if (this.extend.isNotExtended()) {
                        dstBitSize = srcBitSize;
                    } else {
                        assert (this.accessKind.isInteger());
                        dstBitSize = this.extend.getExtendedBitSize();
                        assert (dstBitSize >= srcBitSize) : Assertions.errorMessageContext("dstBitSize", dstBitSize, "srcBitSize", srcBitSize);
                    }
                    memPosition = masm.position();
                    tryMerge = this.mergingAllowed(crb, memPosition);
                    if (!this.accessKind.isInteger()) break block10;
                    switch (this.extend) {
                        case DEFAULT: {
                            masm.ldr(srcBitSize, dst, address, tryMerge);
                            break block11;
                        }
                        case ZERO_16: 
                        case ZERO_32: 
                        case ZERO_64: {
                            masm.ldr(srcBitSize, dst, address, tryMerge);
                            break block11;
                        }
                        case SIGN_16: 
                        case SIGN_32: 
                        case SIGN_64: {
                            masm.ldrs(Integer.max(dstBitSize, 32), srcBitSize, dst, address);
                            break block11;
                        }
                        default: {
                            throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.extend);
                        }
                    }
                }
                assert (srcBitSize == this.result.getPlatformKind().getSizeInBytes() * 8) : Assertions.errorMessageContext("srcBitSize", srcBitSize, "result", this.result);
                masm.fldr(srcBitSize, dst, address, tryMerge);
            }
            return memPosition;
        }
    }

    static abstract class ExtendableLoadOp
    extends MemOp {
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        protected final MemoryExtendKind extend;

        ExtendableLoadOp(LIRInstructionClass<? extends ExtendableLoadOp> c, AArch64Kind kind, MemoryExtendKind extend, AllocatableValue result, AArch64AddressValue address, LIRFrameState state) {
            super(c, kind, address, state);
            this.extend = extend;
            this.result = result;
        }
    }

    public static enum ExtendKind {
        NONE,
        ZERO_EXTEND,
        SIGN_EXTEND;

    }

    static abstract class MemOp
    extends AArch64LIRInstruction
    implements StandardOp.ImplicitNullCheck {
        protected final AArch64Kind accessKind;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AArch64AddressValue addressValue;
        @LIRInstruction.State
        protected LIRFrameState state;

        MemOp(LIRInstructionClass<? extends MemOp> c, AArch64Kind accessKind, AArch64AddressValue address, LIRFrameState state) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)c);
            int size = address.getBitMemoryTransferSize();
            assert (size == -1 || size == accessKind.getSizeInBytes() * 8) : size + " " + String.valueOf(accessKind);
            this.accessKind = accessKind;
            this.addressValue = address;
            this.state = state;
        }

        protected abstract int emitMemAccess(CompilationResultBuilder var1, AArch64MacroAssembler var2);

        protected boolean mergingAllowed(CompilationResultBuilder crb, int memPosition) {
            return this.state == null || crb.getLastImplicitExceptionOffset() == memPosition - 4;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int memPosition = this.emitMemAccess(crb, masm);
            if (this.state != null) {
                if (memPosition == masm.position()) {
                    GraalError.guarantee(masm.isImmLoadStoreMerged() && crb.getLastImplicitExceptionOffset() == memPosition - 4, "Missing state for implicit exception.");
                    return;
                }
                crb.recordImplicitException(memPosition, this.state);
            }
        }

        @Override
        public boolean makeNullCheckFor(Value value, LIRFrameState nullCheckState, int implicitNullCheckLimit) {
            int displacement = this.addressValue.getDisplacement();
            if (this.state == null && value.equals((Object)this.addressValue.getBase()) && this.addressValue.getOffset().equals((Object)Value.ILLEGAL) && displacement >= 0 && displacement < implicitNullCheckLimit) {
                this.state = nullCheckState;
                return true;
            }
            return false;
        }
    }

    public static class MembarOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<MembarOp> TYPE = LIRInstructionClass.create(MembarOp.class);
        private final int barriers;

        public MembarOp(int barriers) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.barriers = barriers;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (this.barriers >= 1 && this.barriers <= 15) : Assertions.errorMessageContext("barriers", this.barriers);
            switch (this.barriers) {
                case 8: {
                    masm.dmb(AArch64Assembler.BarrierKind.STORE_STORE);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    masm.dmb(AArch64Assembler.BarrierKind.LOAD_ANY);
                    break;
                }
                default: {
                    masm.dmb(AArch64Assembler.BarrierKind.ANY_ANY);
                }
            }
        }
    }

    public static class StackLoadAddressOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<StackLoadAddressOp> TYPE = LIRInstructionClass.create(StackLoadAddressOp.class);
        @LIRInstruction.Def
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.UNINITIALIZED})
        protected AllocatableValue slot;

        public StackLoadAddressOp(AllocatableValue result, AllocatableValue slot) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (slot instanceof VirtualStackSlot || slot instanceof StackSlot) : slot;
            this.result = result;
            this.slot = slot;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int displacement = crb.frameMap.offsetForStackSlot((StackSlot)this.slot);
            masm.add(64, ValueUtil.asRegister((Value)this.result), AArch64.sp, displacement);
        }
    }

    public static class LoadDataOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<LoadDataOp> TYPE = LIRInstructionClass.create(LoadDataOp.class);
        @LIRInstruction.Def
        protected AllocatableValue result;
        private final DataPointerConstant data;

        public LoadDataOp(AllocatableValue result, DataPointerConstant data) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.result = result;
            this.data = data;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register dst = ValueUtil.asRegister((Value)this.result);
            crb.recordDataReferenceInCode(this.data);
            masm.adrpAdd(dst);
        }
    }

    public static class LoadAddressOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<LoadAddressOp> TYPE = LIRInstructionClass.create(LoadAddressOp.class);
        @LIRInstruction.Def
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AArch64AddressValue address;

        public LoadAddressOp(AllocatableValue result, AArch64AddressValue address) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.result = result;
            this.address = address;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register dst = ValueUtil.asRegister((Value)this.result);
            masm.loadAddress(dst, this.address.toAddress());
        }
    }

    @Opcode(value="MOVE")
    public static class Move
    extends AArch64LIRInstruction
    implements StandardOp.ValueMoveOp {
        public static final LIRInstructionClass<Move> TYPE = LIRInstructionClass.create(Move.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue input;
        private AArch64Kind moveKind;

        public Move(AArch64Kind moveKind, AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.moveKind = moveKind;
            int resultSize = result.getPlatformKind().getSizeInBytes();
            int inputSize = input.getPlatformKind().getSizeInBytes();
            assert (resultSize == moveKind.getSizeInBytes()) : Assertions.errorMessageContext("resultSize", resultSize, "moveKind", moveKind);
            assert (resultSize <= inputSize) : Assertions.errorMessageContext("resultSize", resultSize, "inputSize", inputSize);
            assert (!ValueUtil.isStackSlot((Value)result) || !ValueUtil.isStackSlot((Value)input));
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64Move.move(this.moveKind, crb, masm, this.getResult(), (Value)this.getInput());
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }

    public static class LoadInlineConstant
    extends AArch64LIRInstruction
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<LoadInlineConstant> TYPE = LIRInstructionClass.create(LoadInlineConstant.class);
        private JavaConstant constant;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        AllocatableValue result;

        public LoadInlineConstant(JavaConstant constant, AllocatableValue result) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.constant = constant;
            this.result = result;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64Kind moveKind = (AArch64Kind)this.result.getPlatformKind();
            if (ValueUtil.isRegister((Value)this.result)) {
                AArch64Move.const2reg(moveKind, crb, masm, ValueUtil.asRegister((Value)this.result), this.constant);
            } else if (ValueUtil.isStackSlot((Value)this.result)) {
                AArch64Move.const2stack(moveKind, crb, masm, ValueUtil.asStackSlot((Value)this.result), this.constant);
            }
        }

        @Override
        public Constant getConstant() {
            return this.constant;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }
}

