/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="AARCH64_ROUND_FLOAT_TO_INTEGER")
@SyncPort(from="https://github.com/openjdk/jdk/blob/7bb59dc8da0c61c5da5c3aab5d56a6e4880001ce/src/hotspot/cpu/aarch64/macroAssembler_aarch64.cpp#L6295-L6343", sha1="76d47473bf8d1408bf6e7bf6b8a3d93c19dab9c6")
public class AArch64RoundFloatToIntegerOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64RoundFloatToIntegerOp> TYPE = LIRInstructionClass.create(AArch64RoundFloatToIntegerOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
    protected AllocatableValue result;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue input;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue tmp;

    public AArch64RoundFloatToIntegerOp(LIRGeneratorTool tool, AllocatableValue result, AllocatableValue input) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.result = result;
        this.input = input;
        this.tmp = tool.newVariable(input.getValueKind());
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.result);
        Register src = ValueUtil.asRegister((Value)this.input);
        Register ftmp = ValueUtil.asRegister((Value)this.tmp);
        Label labelDONE = new Label();
        try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
            Register rscratch1 = sc1.getRegister();
            Register rscratch2 = sc2.getRegister();
            if (this.input.getPlatformKind() == AArch64Kind.SINGLE) {
                masm.fmov(32, rscratch1, src);
                masm.fcvtas(32, 32, dst, src);
                masm.eor(32, rscratch1, rscratch1, Integer.MIN_VALUE);
                masm.mov(rscratch2, Float.floatToIntBits(8388608.0f));
                masm.cmp(32, rscratch1, rscratch2);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.HS, labelDONE);
                masm.fmov(32, ftmp, 0.5);
                masm.fadd(32, ftmp, src, ftmp);
                masm.fcvtms(32, 32, dst, ftmp);
            } else {
                masm.fmov(64, rscratch1, src);
                masm.fcvtas(64, 64, dst, src);
                masm.eor(64, rscratch1, rscratch1, Long.MIN_VALUE);
                masm.mov(rscratch2, Double.doubleToLongBits(4.503599627370496E15));
                masm.cmp(64, rscratch1, rscratch2);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.HS, labelDONE);
                masm.fmov(64, ftmp, 0.5);
                masm.fadd(64, ftmp, src, ftmp);
                masm.fcvtms(64, 64, dst, ftmp);
            }
        }
        masm.bind(labelDONE);
    }
}

