/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.ArrayDataPointerConstant;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/12a61bce8db5e6b152eb101de1662847bebb7997/src/hotspot/cpu/aarch64/stubGenerator_aarch64.cpp#L3986-L4208", sha1="c17848fadbacb526e5da3c4e7c2a300c8160e092")
public final class AArch64SHA3Op
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64SHA3Op> TYPE = LIRInstructionClass.create(AArch64SHA3Op.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value bufValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value stateValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value blockSizeValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value limitValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value blockSizeTempValue;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value resultValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value bufTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] temps;
    private final boolean multiBlock;
    static ArrayDataPointerConstant roundConsts = new ArrayDataPointerConstant(new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L}, 16);

    public AArch64SHA3Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue, AllocatableValue blockSizeValue) {
        this(tool, bufValue, stateValue, blockSizeValue, Value.ILLEGAL, Value.ILLEGAL, Value.ILLEGAL, false);
    }

    public AArch64SHA3Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue, AllocatableValue blockSizeValue, AllocatableValue ofsValue, AllocatableValue limitValue, AllocatableValue resultValue, boolean multiBlock) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.bufValue = bufValue;
        this.stateValue = stateValue;
        this.blockSizeValue = blockSizeValue;
        this.ofsValue = ofsValue;
        this.limitValue = limitValue;
        this.resultValue = resultValue;
        this.bufTempValue = tool.newVariable(bufValue.getValueKind());
        this.blockSizeTempValue = tool.newVariable(blockSizeValue.getValueKind());
        this.multiBlock = multiBlock;
        this.ofsTempValue = multiBlock ? tool.newVariable(ofsValue.getValueKind()) : Value.ILLEGAL;
        this.temps = new Value[]{AArch64.v0.asValue(), AArch64.v1.asValue(), AArch64.v2.asValue(), AArch64.v3.asValue(), AArch64.v4.asValue(), AArch64.v5.asValue(), AArch64.v6.asValue(), AArch64.v7.asValue(), AArch64.v8.asValue(), AArch64.v9.asValue(), AArch64.v10.asValue(), AArch64.v11.asValue(), AArch64.v12.asValue(), AArch64.v13.asValue(), AArch64.v14.asValue(), AArch64.v15.asValue(), AArch64.v16.asValue(), AArch64.v17.asValue(), AArch64.v18.asValue(), AArch64.v19.asValue(), AArch64.v20.asValue(), AArch64.v21.asValue(), AArch64.v22.asValue(), AArch64.v23.asValue(), AArch64.v24.asValue(), AArch64.v25.asValue(), AArch64.v26.asValue(), AArch64.v27.asValue(), AArch64.v28.asValue(), AArch64.v29.asValue(), AArch64.v30.asValue(), AArch64.v31.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register limit;
        Register ofs;
        GraalError.guarantee(this.bufValue.getPlatformKind().equals((Object)AArch64Kind.QWORD), "Invalid bufValue kind: %s", (Object)this.bufValue);
        GraalError.guarantee(this.stateValue.getPlatformKind().equals((Object)AArch64Kind.QWORD), "Invalid stateValue kind: %s", (Object)this.stateValue);
        GraalError.guarantee(this.blockSizeValue.getPlatformKind().equals((Object)AArch64Kind.DWORD), "Invalid blockSizeValue kind: %s", (Object)this.blockSizeValue);
        Register buf = ValueUtil.asRegister((Value)this.bufTempValue);
        Register state = ValueUtil.asRegister((Value)this.stateValue);
        Register blockSize = ValueUtil.asRegister((Value)this.blockSizeValue);
        Register blockSizeTail = ValueUtil.asRegister((Value)this.blockSizeTempValue);
        masm.mov(64, buf, ValueUtil.asRegister((Value)this.bufValue));
        if (this.multiBlock) {
            GraalError.guarantee(this.ofsValue.getPlatformKind().equals((Object)AArch64Kind.DWORD), "Invalid ofsValue kind: %s", (Object)this.ofsValue);
            GraalError.guarantee(this.limitValue.getPlatformKind().equals((Object)AArch64Kind.DWORD), "Invalid limitValue kind: %s", (Object)this.limitValue);
            ofs = ValueUtil.asRegister((Value)this.ofsTempValue);
            limit = ValueUtil.asRegister((Value)this.limitValue);
            masm.mov(64, ofs, ValueUtil.asRegister((Value)this.ofsValue));
        } else {
            ofs = Register.None;
            limit = Register.None;
        }
        Label labelSHA3Loop = new Label();
        Label labelRounds24Loop = new Label();
        Label labelSHA3512OrSha3384 = new Label();
        Label labelSHAke128 = new Label();
        try (AArch64MacroAssembler.ScratchRegister scratchReg1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister scratchReg2 = masm.getScratchRegister();){
            Register rscratch1 = scratchReg1.getRegister();
            Register rscratch2 = scratchReg2.getRegister();
            masm.add(64, rscratch1, state, 32);
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64Address.createStructureNoOffsetAddress(state));
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v4, AArch64.v5, AArch64.v6, AArch64.v7, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, rscratch1, 32));
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v8, AArch64.v9, AArch64.v10, AArch64.v11, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, rscratch1, 32));
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v12, AArch64.v13, AArch64.v14, AArch64.v15, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, rscratch1, 32));
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v16, AArch64.v17, AArch64.v18, AArch64.v19, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, rscratch1, 32));
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v20, AArch64.v21, AArch64.v22, AArch64.v23, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, rscratch1, 32));
            masm.neon.ld1MultipleV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v24, AArch64Address.createStructureNoOffsetAddress(rscratch1));
            masm.bind(labelSHA3Loop);
            masm.mov(rscratch2, 24);
            crb.recordDataReferenceInCode(roundConsts);
            masm.adrpAdd(rscratch1);
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v25, AArch64.v26, AArch64.v27, AArch64.v28, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, buf, 32));
            masm.neon.ld1MultipleVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v29, AArch64.v30, AArch64.v31, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_3R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, buf, 24));
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v0, AArch64.v0, AArch64.v25);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v1, AArch64.v1, AArch64.v26);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v2, AArch64.v2, AArch64.v27);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v3, AArch64.v3, AArch64.v28);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v4, AArch64.v4, AArch64.v29);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v5, AArch64.v5, AArch64.v30);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v6, AArch64.v6, AArch64.v31);
            masm.tbz(blockSize, 7, labelSHA3512OrSha3384);
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v25, AArch64.v26, AArch64.v27, AArch64.v28, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, buf, 32));
            masm.neon.ld1MultipleVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v29, AArch64.v30, AArch64.v31, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_3R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, buf, 24));
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v7, AArch64.v7, AArch64.v25);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v8, AArch64.v8, AArch64.v26);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v9, AArch64.v9, AArch64.v27);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v10, AArch64.v10, AArch64.v28);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v11, AArch64.v11, AArch64.v29);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v12, AArch64.v12, AArch64.v30);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v13, AArch64.v13, AArch64.v31);
            masm.neon.ld1MultipleVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v25, AArch64.v26, AArch64.v27, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_3R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, buf, 24));
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v14, AArch64.v14, AArch64.v25);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v15, AArch64.v15, AArch64.v26);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v16, AArch64.v16, AArch64.v27);
            masm.and(32, blockSizeTail, blockSize, 48L);
            masm.cbz(32, blockSizeTail, labelRounds24Loop);
            masm.tbnz(blockSize, 5, labelSHAke128);
            masm.fldr(64, AArch64.v28, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, buf, 8));
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v17, AArch64.v17, AArch64.v28);
            masm.jmp(labelRounds24Loop);
            masm.bind(labelSHAke128);
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v28, AArch64.v29, AArch64.v30, AArch64.v31, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, buf, 32));
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v17, AArch64.v17, AArch64.v28);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v18, AArch64.v18, AArch64.v29);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v19, AArch64.v19, AArch64.v30);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v20, AArch64.v20, AArch64.v31);
            masm.jmp(labelRounds24Loop);
            masm.bind(labelSHA3512OrSha3384);
            masm.neon.ld1MultipleVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v25, AArch64.v26, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, buf, 16));
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v7, AArch64.v7, AArch64.v25);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v8, AArch64.v8, AArch64.v26);
            masm.tbz(blockSize, 5, labelRounds24Loop);
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v27, AArch64.v28, AArch64.v29, AArch64.v30, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, buf, 32));
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v9, AArch64.v9, AArch64.v27);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v10, AArch64.v10, AArch64.v28);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v11, AArch64.v11, AArch64.v29);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64.v12, AArch64.v12, AArch64.v30);
            masm.bind(labelRounds24Loop);
            masm.sub(32, rscratch2, rscratch2, 1);
            masm.neon.eor3VVVV(AArch64.v29, AArch64.v4, AArch64.v9, AArch64.v14);
            masm.neon.eor3VVVV(AArch64.v26, AArch64.v1, AArch64.v6, AArch64.v11);
            masm.neon.eor3VVVV(AArch64.v28, AArch64.v3, AArch64.v8, AArch64.v13);
            masm.neon.eor3VVVV(AArch64.v25, AArch64.v0, AArch64.v5, AArch64.v10);
            masm.neon.eor3VVVV(AArch64.v27, AArch64.v2, AArch64.v7, AArch64.v12);
            masm.neon.eor3VVVV(AArch64.v29, AArch64.v29, AArch64.v19, AArch64.v24);
            masm.neon.eor3VVVV(AArch64.v26, AArch64.v26, AArch64.v16, AArch64.v21);
            masm.neon.eor3VVVV(AArch64.v28, AArch64.v28, AArch64.v18, AArch64.v23);
            masm.neon.eor3VVVV(AArch64.v25, AArch64.v25, AArch64.v15, AArch64.v20);
            masm.neon.eor3VVVV(AArch64.v27, AArch64.v27, AArch64.v17, AArch64.v22);
            masm.neon.rax1VVV(AArch64.v30, AArch64.v29, AArch64.v26);
            masm.neon.rax1VVV(AArch64.v26, AArch64.v26, AArch64.v28);
            masm.neon.rax1VVV(AArch64.v28, AArch64.v28, AArch64.v25);
            masm.neon.rax1VVV(AArch64.v25, AArch64.v25, AArch64.v27);
            masm.neon.rax1VVV(AArch64.v27, AArch64.v27, AArch64.v29);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v0, AArch64.v0, AArch64.v30);
            masm.neon.xarVVVI(AArch64.v29, AArch64.v1, AArch64.v25, 63);
            masm.neon.xarVVVI(AArch64.v1, AArch64.v6, AArch64.v25, 20);
            masm.neon.xarVVVI(AArch64.v6, AArch64.v9, AArch64.v28, 44);
            masm.neon.xarVVVI(AArch64.v9, AArch64.v22, AArch64.v26, 3);
            masm.neon.xarVVVI(AArch64.v22, AArch64.v14, AArch64.v28, 25);
            masm.neon.xarVVVI(AArch64.v14, AArch64.v20, AArch64.v30, 46);
            masm.neon.xarVVVI(AArch64.v31, AArch64.v2, AArch64.v26, 2);
            masm.neon.xarVVVI(AArch64.v2, AArch64.v12, AArch64.v26, 21);
            masm.neon.xarVVVI(AArch64.v12, AArch64.v13, AArch64.v27, 39);
            masm.neon.xarVVVI(AArch64.v13, AArch64.v19, AArch64.v28, 56);
            masm.neon.xarVVVI(AArch64.v19, AArch64.v23, AArch64.v27, 8);
            masm.neon.xarVVVI(AArch64.v23, AArch64.v15, AArch64.v30, 23);
            masm.neon.xarVVVI(AArch64.v15, AArch64.v4, AArch64.v28, 37);
            masm.neon.xarVVVI(AArch64.v28, AArch64.v24, AArch64.v28, 50);
            masm.neon.xarVVVI(AArch64.v24, AArch64.v21, AArch64.v25, 62);
            masm.neon.xarVVVI(AArch64.v8, AArch64.v8, AArch64.v27, 9);
            masm.neon.xarVVVI(AArch64.v4, AArch64.v16, AArch64.v25, 19);
            masm.neon.xarVVVI(AArch64.v16, AArch64.v5, AArch64.v30, 28);
            masm.neon.xarVVVI(AArch64.v5, AArch64.v3, AArch64.v27, 36);
            masm.neon.xarVVVI(AArch64.v27, AArch64.v18, AArch64.v27, 43);
            masm.neon.xarVVVI(AArch64.v3, AArch64.v17, AArch64.v26, 49);
            masm.neon.xarVVVI(AArch64.v25, AArch64.v11, AArch64.v25, 54);
            masm.neon.xarVVVI(AArch64.v26, AArch64.v7, AArch64.v26, 58);
            masm.neon.xarVVVI(AArch64.v30, AArch64.v10, AArch64.v30, 61);
            masm.neon.bcaxVVVV(AArch64.v20, AArch64.v31, AArch64.v22, AArch64.v8);
            masm.neon.bcaxVVVV(AArch64.v21, AArch64.v8, AArch64.v23, AArch64.v22);
            masm.neon.bcaxVVVV(AArch64.v22, AArch64.v22, AArch64.v24, AArch64.v23);
            masm.neon.bcaxVVVV(AArch64.v23, AArch64.v23, AArch64.v31, AArch64.v24);
            masm.neon.bcaxVVVV(AArch64.v24, AArch64.v24, AArch64.v8, AArch64.v31);
            masm.neon.ld1rV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v31, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, rscratch1, 8));
            masm.neon.bcaxVVVV(AArch64.v17, AArch64.v25, AArch64.v19, AArch64.v3);
            masm.neon.bcaxVVVV(AArch64.v18, AArch64.v3, AArch64.v15, AArch64.v19);
            masm.neon.bcaxVVVV(AArch64.v19, AArch64.v19, AArch64.v16, AArch64.v15);
            masm.neon.bcaxVVVV(AArch64.v15, AArch64.v15, AArch64.v25, AArch64.v16);
            masm.neon.bcaxVVVV(AArch64.v16, AArch64.v16, AArch64.v3, AArch64.v25);
            masm.neon.bcaxVVVV(AArch64.v10, AArch64.v29, AArch64.v12, AArch64.v26);
            masm.neon.bcaxVVVV(AArch64.v11, AArch64.v26, AArch64.v13, AArch64.v12);
            masm.neon.bcaxVVVV(AArch64.v12, AArch64.v12, AArch64.v14, AArch64.v13);
            masm.neon.bcaxVVVV(AArch64.v13, AArch64.v13, AArch64.v29, AArch64.v14);
            masm.neon.bcaxVVVV(AArch64.v14, AArch64.v14, AArch64.v26, AArch64.v29);
            masm.neon.bcaxVVVV(AArch64.v7, AArch64.v30, AArch64.v9, AArch64.v4);
            masm.neon.bcaxVVVV(AArch64.v8, AArch64.v4, AArch64.v5, AArch64.v9);
            masm.neon.bcaxVVVV(AArch64.v9, AArch64.v9, AArch64.v6, AArch64.v5);
            masm.neon.bcaxVVVV(AArch64.v5, AArch64.v5, AArch64.v30, AArch64.v6);
            masm.neon.bcaxVVVV(AArch64.v6, AArch64.v6, AArch64.v4, AArch64.v30);
            masm.neon.bcaxVVVV(AArch64.v3, AArch64.v27, AArch64.v0, AArch64.v28);
            masm.neon.bcaxVVVV(AArch64.v4, AArch64.v28, AArch64.v1, AArch64.v0);
            masm.neon.bcaxVVVV(AArch64.v0, AArch64.v0, AArch64.v2, AArch64.v1);
            masm.neon.bcaxVVVV(AArch64.v1, AArch64.v1, AArch64.v27, AArch64.v2);
            masm.neon.bcaxVVVV(AArch64.v2, AArch64.v2, AArch64.v28, AArch64.v27);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v0, AArch64.v0, AArch64.v31);
            masm.cbnz(32, rscratch2, labelRounds24Loop);
            if (this.multiBlock) {
                masm.add(32, ofs, ofs, blockSize);
                masm.cmp(32, ofs, limit);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.LE, labelSHA3Loop);
                GraalError.guarantee(this.resultValue.getPlatformKind().equals((Object)AArch64Kind.DWORD), "Invalid resultValue kind: %s", (Object)this.resultValue);
                masm.mov(32, ValueUtil.asRegister((Value)this.resultValue), ofs);
            }
            masm.neon.st1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.ST1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, state, 32));
            masm.neon.st1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v4, AArch64.v5, AArch64.v6, AArch64.v7, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.ST1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, state, 32));
            masm.neon.st1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v8, AArch64.v9, AArch64.v10, AArch64.v11, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.ST1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, state, 32));
            masm.neon.st1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v12, AArch64.v13, AArch64.v14, AArch64.v15, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.ST1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, state, 32));
            masm.neon.st1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v16, AArch64.v17, AArch64.v18, AArch64.v19, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.ST1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, state, 32));
            masm.neon.st1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v20, AArch64.v21, AArch64.v22, AArch64.v23, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.ST1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, state, 32));
            masm.neon.st1MultipleV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v24, AArch64Address.createStructureNoOffsetAddress(state));
        }
    }
}

