/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.ArrayDataPointerConstant;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/12a61bce8db5e6b152eb101de1662847bebb7997/src/hotspot/cpu/aarch64/stubGenerator_aarch64.cpp#L3811-L3984", sha1="9a27893e95da304e616ebd2105529e39d9634483")
public final class AArch64SHA512Op
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64SHA512Op> TYPE = LIRInstructionClass.create(AArch64SHA512Op.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value bufValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value stateValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value limitValue;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value resultValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value bufTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] temps;
    private final boolean multiBlock;
    static ArrayDataPointerConstant roundConsts = new ArrayDataPointerConstant(new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L}, 16);

    public AArch64SHA512Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue) {
        this(tool, bufValue, stateValue, Value.ILLEGAL, Value.ILLEGAL, Value.ILLEGAL, false);
    }

    public AArch64SHA512Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue, AllocatableValue ofsValue, AllocatableValue limitValue, AllocatableValue resultValue, boolean multiBlock) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.bufValue = bufValue;
        this.stateValue = stateValue;
        this.ofsValue = ofsValue;
        this.limitValue = limitValue;
        this.resultValue = resultValue;
        this.multiBlock = multiBlock;
        if (multiBlock) {
            this.bufTempValue = tool.newVariable(bufValue.getValueKind());
            this.ofsTempValue = tool.newVariable(ofsValue.getValueKind());
        } else {
            this.bufTempValue = Value.ILLEGAL;
            this.ofsTempValue = Value.ILLEGAL;
        }
        this.temps = new Value[]{AArch64.v0.asValue(), AArch64.v1.asValue(), AArch64.v2.asValue(), AArch64.v3.asValue(), AArch64.v4.asValue(), AArch64.v5.asValue(), AArch64.v6.asValue(), AArch64.v7.asValue(), AArch64.v8.asValue(), AArch64.v9.asValue(), AArch64.v10.asValue(), AArch64.v11.asValue(), AArch64.v12.asValue(), AArch64.v13.asValue(), AArch64.v14.asValue(), AArch64.v15.asValue(), AArch64.v16.asValue(), AArch64.v17.asValue(), AArch64.v18.asValue(), AArch64.v19.asValue(), AArch64.v20.asValue(), AArch64.v21.asValue(), AArch64.v22.asValue(), AArch64.v23.asValue(), AArch64.v24.asValue(), AArch64.v25.asValue(), AArch64.v26.asValue(), AArch64.v27.asValue(), AArch64.v28.asValue(), AArch64.v29.asValue(), AArch64.v30.asValue(), AArch64.v31.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register limit;
        Register ofs;
        Register buf;
        GraalError.guarantee(this.bufValue.getPlatformKind().equals((Object)AArch64Kind.QWORD), "Invalid bufValue kind: %s", (Object)this.bufValue);
        GraalError.guarantee(this.stateValue.getPlatformKind().equals((Object)AArch64Kind.QWORD), "Invalid stateValue kind: %s", (Object)this.stateValue);
        Register state = ValueUtil.asRegister((Value)this.stateValue);
        if (this.multiBlock) {
            GraalError.guarantee(this.ofsValue.getPlatformKind().equals((Object)AArch64Kind.QWORD), "Invalid ofsValue kind: %s", (Object)this.ofsValue);
            GraalError.guarantee(this.limitValue.getPlatformKind().equals((Object)AArch64Kind.QWORD), "Invalid limitValue kind: %s", (Object)this.limitValue);
            buf = ValueUtil.asRegister((Value)this.bufTempValue);
            ofs = ValueUtil.asRegister((Value)this.ofsTempValue);
            limit = ValueUtil.asRegister((Value)this.limitValue);
            masm.mov(64, buf, ValueUtil.asRegister((Value)this.bufValue));
            masm.mov(32, ofs, ValueUtil.asRegister((Value)this.ofsValue));
        } else {
            buf = ValueUtil.asRegister((Value)this.bufValue);
            ofs = Register.None;
            limit = Register.None;
        }
        Label labelSHA512Loop = new Label();
        try (AArch64MacroAssembler.ScratchRegister scratchReg1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister scratchReg2 = masm.getScratchRegister();){
            Register rscratch1 = scratchReg1.getRegister();
            Register rscratch2 = scratchReg2.getRegister();
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v8, AArch64.v9, AArch64.v10, AArch64.v11, AArch64Address.createStructureNoOffsetAddress(state));
            crb.recordDataReferenceInCode(roundConsts);
            masm.adrpAdd(rscratch1);
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v20, AArch64.v21, AArch64.v22, AArch64.v23, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, rscratch1, 64));
            masm.bind(labelSHA512Loop);
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v12, AArch64.v13, AArch64.v14, AArch64.v15, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, buf, 64));
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v16, AArch64.v17, AArch64.v18, AArch64.v19, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, buf, 64));
            masm.neon.rev64VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v12, AArch64.v12);
            masm.neon.rev64VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v13, AArch64.v13);
            masm.neon.rev64VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v14, AArch64.v14);
            masm.neon.rev64VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v15, AArch64.v15);
            masm.neon.rev64VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v16, AArch64.v16);
            masm.neon.rev64VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v17, AArch64.v17);
            masm.neon.rev64VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v18, AArch64.v18);
            masm.neon.rev64VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v19, AArch64.v19);
            masm.mov(64, rscratch2, rscratch1);
            masm.neon.moveVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v0, AArch64.v8);
            masm.neon.moveVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v1, AArch64.v9);
            masm.neon.moveVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v2, AArch64.v10);
            masm.neon.moveVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v3, AArch64.v11);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 0, AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v20, AArch64.v24, AArch64.v12, AArch64.v13, AArch64.v19, AArch64.v16, AArch64.v17);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 1, AArch64.v3, AArch64.v0, AArch64.v4, AArch64.v2, AArch64.v1, AArch64.v21, AArch64.v25, AArch64.v13, AArch64.v14, AArch64.v12, AArch64.v17, AArch64.v18);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 2, AArch64.v2, AArch64.v3, AArch64.v1, AArch64.v4, AArch64.v0, AArch64.v22, AArch64.v26, AArch64.v14, AArch64.v15, AArch64.v13, AArch64.v18, AArch64.v19);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 3, AArch64.v4, AArch64.v2, AArch64.v0, AArch64.v1, AArch64.v3, AArch64.v23, AArch64.v27, AArch64.v15, AArch64.v16, AArch64.v14, AArch64.v19, AArch64.v12);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 4, AArch64.v1, AArch64.v4, AArch64.v3, AArch64.v0, AArch64.v2, AArch64.v24, AArch64.v28, AArch64.v16, AArch64.v17, AArch64.v15, AArch64.v12, AArch64.v13);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 5, AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v25, AArch64.v29, AArch64.v17, AArch64.v18, AArch64.v16, AArch64.v13, AArch64.v14);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 6, AArch64.v3, AArch64.v0, AArch64.v4, AArch64.v2, AArch64.v1, AArch64.v26, AArch64.v30, AArch64.v18, AArch64.v19, AArch64.v17, AArch64.v14, AArch64.v15);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 7, AArch64.v2, AArch64.v3, AArch64.v1, AArch64.v4, AArch64.v0, AArch64.v27, AArch64.v31, AArch64.v19, AArch64.v12, AArch64.v18, AArch64.v15, AArch64.v16);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 8, AArch64.v4, AArch64.v2, AArch64.v0, AArch64.v1, AArch64.v3, AArch64.v28, AArch64.v24, AArch64.v12, AArch64.v13, AArch64.v19, AArch64.v16, AArch64.v17);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 9, AArch64.v1, AArch64.v4, AArch64.v3, AArch64.v0, AArch64.v2, AArch64.v29, AArch64.v25, AArch64.v13, AArch64.v14, AArch64.v12, AArch64.v17, AArch64.v18);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 10, AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v30, AArch64.v26, AArch64.v14, AArch64.v15, AArch64.v13, AArch64.v18, AArch64.v19);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 11, AArch64.v3, AArch64.v0, AArch64.v4, AArch64.v2, AArch64.v1, AArch64.v31, AArch64.v27, AArch64.v15, AArch64.v16, AArch64.v14, AArch64.v19, AArch64.v12);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 12, AArch64.v2, AArch64.v3, AArch64.v1, AArch64.v4, AArch64.v0, AArch64.v24, AArch64.v28, AArch64.v16, AArch64.v17, AArch64.v15, AArch64.v12, AArch64.v13);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 13, AArch64.v4, AArch64.v2, AArch64.v0, AArch64.v1, AArch64.v3, AArch64.v25, AArch64.v29, AArch64.v17, AArch64.v18, AArch64.v16, AArch64.v13, AArch64.v14);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 14, AArch64.v1, AArch64.v4, AArch64.v3, AArch64.v0, AArch64.v2, AArch64.v26, AArch64.v30, AArch64.v18, AArch64.v19, AArch64.v17, AArch64.v14, AArch64.v15);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 15, AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v27, AArch64.v31, AArch64.v19, AArch64.v12, AArch64.v18, AArch64.v15, AArch64.v16);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 16, AArch64.v3, AArch64.v0, AArch64.v4, AArch64.v2, AArch64.v1, AArch64.v28, AArch64.v24, AArch64.v12, AArch64.v13, AArch64.v19, AArch64.v16, AArch64.v17);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 17, AArch64.v2, AArch64.v3, AArch64.v1, AArch64.v4, AArch64.v0, AArch64.v29, AArch64.v25, AArch64.v13, AArch64.v14, AArch64.v12, AArch64.v17, AArch64.v18);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 18, AArch64.v4, AArch64.v2, AArch64.v0, AArch64.v1, AArch64.v3, AArch64.v30, AArch64.v26, AArch64.v14, AArch64.v15, AArch64.v13, AArch64.v18, AArch64.v19);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 19, AArch64.v1, AArch64.v4, AArch64.v3, AArch64.v0, AArch64.v2, AArch64.v31, AArch64.v27, AArch64.v15, AArch64.v16, AArch64.v14, AArch64.v19, AArch64.v12);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 20, AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v24, AArch64.v28, AArch64.v16, AArch64.v17, AArch64.v15, AArch64.v12, AArch64.v13);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 21, AArch64.v3, AArch64.v0, AArch64.v4, AArch64.v2, AArch64.v1, AArch64.v25, AArch64.v29, AArch64.v17, AArch64.v18, AArch64.v16, AArch64.v13, AArch64.v14);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 22, AArch64.v2, AArch64.v3, AArch64.v1, AArch64.v4, AArch64.v0, AArch64.v26, AArch64.v30, AArch64.v18, AArch64.v19, AArch64.v17, AArch64.v14, AArch64.v15);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 23, AArch64.v4, AArch64.v2, AArch64.v0, AArch64.v1, AArch64.v3, AArch64.v27, AArch64.v31, AArch64.v19, AArch64.v12, AArch64.v18, AArch64.v15, AArch64.v16);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 24, AArch64.v1, AArch64.v4, AArch64.v3, AArch64.v0, AArch64.v2, AArch64.v28, AArch64.v24, AArch64.v12, AArch64.v13, AArch64.v19, AArch64.v16, AArch64.v17);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 25, AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v29, AArch64.v25, AArch64.v13, AArch64.v14, AArch64.v12, AArch64.v17, AArch64.v18);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 26, AArch64.v3, AArch64.v0, AArch64.v4, AArch64.v2, AArch64.v1, AArch64.v30, AArch64.v26, AArch64.v14, AArch64.v15, AArch64.v13, AArch64.v18, AArch64.v19);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 27, AArch64.v2, AArch64.v3, AArch64.v1, AArch64.v4, AArch64.v0, AArch64.v31, AArch64.v27, AArch64.v15, AArch64.v16, AArch64.v14, AArch64.v19, AArch64.v12);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 28, AArch64.v4, AArch64.v2, AArch64.v0, AArch64.v1, AArch64.v3, AArch64.v24, AArch64.v28, AArch64.v16, AArch64.v17, AArch64.v15, AArch64.v12, AArch64.v13);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 29, AArch64.v1, AArch64.v4, AArch64.v3, AArch64.v0, AArch64.v2, AArch64.v25, AArch64.v29, AArch64.v17, AArch64.v18, AArch64.v16, AArch64.v13, AArch64.v14);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 30, AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v26, AArch64.v30, AArch64.v18, AArch64.v19, AArch64.v17, AArch64.v14, AArch64.v15);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 31, AArch64.v3, AArch64.v0, AArch64.v4, AArch64.v2, AArch64.v1, AArch64.v27, AArch64.v31, AArch64.v19, AArch64.v12, AArch64.v18, AArch64.v15, AArch64.v16);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 32, AArch64.v2, AArch64.v3, AArch64.v1, AArch64.v4, AArch64.v0, AArch64.v28, AArch64.v24, AArch64.v12, AArch64.v0, AArch64.v0, AArch64.v0, AArch64.v0);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 33, AArch64.v4, AArch64.v2, AArch64.v0, AArch64.v1, AArch64.v3, AArch64.v29, AArch64.v25, AArch64.v13, AArch64.v0, AArch64.v0, AArch64.v0, AArch64.v0);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 34, AArch64.v1, AArch64.v4, AArch64.v3, AArch64.v0, AArch64.v2, AArch64.v30, AArch64.v26, AArch64.v14, AArch64.v0, AArch64.v0, AArch64.v0, AArch64.v0);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 35, AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v31, AArch64.v27, AArch64.v15, AArch64.v0, AArch64.v0, AArch64.v0, AArch64.v0);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 36, AArch64.v3, AArch64.v0, AArch64.v4, AArch64.v2, AArch64.v1, AArch64.v24, AArch64.v0, AArch64.v16, AArch64.v0, AArch64.v0, AArch64.v0, AArch64.v0);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 37, AArch64.v2, AArch64.v3, AArch64.v1, AArch64.v4, AArch64.v0, AArch64.v25, AArch64.v0, AArch64.v17, AArch64.v0, AArch64.v0, AArch64.v0, AArch64.v0);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 38, AArch64.v4, AArch64.v2, AArch64.v0, AArch64.v1, AArch64.v3, AArch64.v26, AArch64.v0, AArch64.v18, AArch64.v0, AArch64.v0, AArch64.v0, AArch64.v0);
            AArch64SHA512Op.sha512Dround(masm, rscratch2, 39, AArch64.v1, AArch64.v4, AArch64.v3, AArch64.v0, AArch64.v2, AArch64.v27, AArch64.v0, AArch64.v19, AArch64.v0, AArch64.v0, AArch64.v0, AArch64.v0);
            masm.neon.addVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v8, AArch64.v8, AArch64.v0);
            masm.neon.addVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v9, AArch64.v9, AArch64.v1);
            masm.neon.addVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v10, AArch64.v10, AArch64.v2);
            masm.neon.addVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v11, AArch64.v11, AArch64.v3);
            if (this.multiBlock) {
                masm.add(32, ofs, ofs, 128);
                masm.cmp(32, ofs, limit);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.LE, labelSHA512Loop);
                GraalError.guarantee(this.resultValue.getPlatformKind().equals((Object)AArch64Kind.DWORD), "Invalid resultValue kind: %s", (Object)this.resultValue);
                masm.mov(32, ValueUtil.asRegister((Value)this.resultValue), ofs);
            }
            masm.neon.st1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v8, AArch64.v9, AArch64.v10, AArch64.v11, AArch64Address.createStructureNoOffsetAddress(state));
        }
    }

    private static void sha512Dround(AArch64MacroAssembler masm, Register rscratch2, int dr, Register vi0, Register vi1, Register vi2, Register vi3, Register vi4, Register vrc0, Register vrc1, Register vin0, Register vin1, Register vin2, Register vin3, Register vin4) {
        if (dr < 36) {
            masm.neon.ld1MultipleV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, vrc1, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_1R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, rscratch2, 16));
        }
        masm.neon.addVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64.v5, vrc0, vin0);
        masm.neon.extVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v6, vi2, vi3, 8);
        masm.neon.extVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v5, AArch64.v5, AArch64.v5, 8);
        masm.neon.extVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v7, vi1, vi2, 8);
        masm.neon.addVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, vi3, vi3, AArch64.v5);
        if (dr < 32) {
            masm.neon.extVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v5, vin3, vin4, 8);
            masm.neon.sha512su0(vin0, vin1);
        }
        masm.neon.sha512h(vi3, AArch64.v6, AArch64.v7);
        if (dr < 32) {
            masm.neon.sha512su1(vin0, vin2, AArch64.v5);
        }
        masm.neon.addVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, vi4, vi1, vi3);
        masm.neon.sha512h2(vi3, vi1, vi0);
    }
}

