/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.aarch64.AArch64ComplexVectorOp;
import jdk.graal.compiler.lir.aarch64.AArch64EncodeArrayOp;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="AArch64_STRING_COMPRESS")
@SyncPort(from="https://github.com/openjdk/jdk/blob/7bb59dc8da0c61c5da5c3aab5d56a6e4880001ce/src/hotspot/cpu/aarch64/macroAssembler_aarch64.cpp#L6283-L6293", sha1="857dc6f9a492da6c8e20afb2139ae393efd228ac")
public final class AArch64StringUTF16CompressOp
extends AArch64ComplexVectorOp {
    public static final LIRInstructionClass<AArch64StringUTF16CompressOp> TYPE = LIRInstructionClass.create(AArch64StringUTF16CompressOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue lenValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue srcValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue dstValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue[] temp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value[] vectorTemp;

    public AArch64StringUTF16CompressOp(LIRGeneratorTool tool, AllocatableValue src, AllocatableValue dst, AllocatableValue len, AllocatableValue result) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        GraalError.guarantee(result.getPlatformKind().equals((Object)AArch64Kind.DWORD), "int value expected");
        GraalError.guarantee(len.getPlatformKind().equals((Object)AArch64Kind.DWORD), "int value expected");
        GraalError.guarantee(src.getPlatformKind().equals((Object)AArch64Kind.QWORD), "pointer value expected");
        GraalError.guarantee(dst.getPlatformKind().equals((Object)AArch64Kind.QWORD), "pointer value expected");
        this.lenValue = len;
        this.srcValue = src;
        this.dstValue = dst;
        this.resultValue = result;
        this.temp = AArch64StringUTF16CompressOp.allocateTempRegisters(tool, 3);
        this.vectorTemp = AArch64EncodeArrayOp.allocateVectorRegisters(tool, LIRGeneratorTool.CharsetName.ISO_8859_1);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register src = ValueUtil.asRegister((Value)this.temp[0]);
        Register dst = ValueUtil.asRegister((Value)this.temp[1]);
        Register len = ValueUtil.asRegister((Value)this.temp[2]);
        Register res = ValueUtil.asRegister((Value)this.resultValue);
        masm.mov(64, src, ValueUtil.asRegister((Value)this.srcValue));
        masm.mov(64, dst, ValueUtil.asRegister((Value)this.dstValue));
        masm.mov(32, len, ValueUtil.asRegister((Value)this.lenValue));
        AArch64EncodeArrayOp.emitEncodeArrayOp(masm, res, src, dst, len, this.vectorTemp, LIRGeneratorTool.CharsetName.ISO_8859_1);
        if (JavaVersionUtil.JAVA_SPEC < 22) {
            masm.cmp(32, res, ValueUtil.asRegister((Value)this.lenValue));
            masm.csel(32, res, res, AArch64.zr, AArch64Assembler.ConditionFlag.EQ);
        }
    }
}

