/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.aarch64.AArch64Move;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaConstant;

@Opcode(value="ZAP_REGISTER")
public final class AArch64ZapRegistersOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64ZapRegistersOp> TYPE = LIRInstructionClass.create(AArch64ZapRegistersOp.class);
    protected final Register[] zappedRegisters;
    protected final JavaConstant[] zapValues;

    public AArch64ZapRegistersOp(Register[] zappedRegisters, JavaConstant[] zapValues) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.zappedRegisters = zappedRegisters;
        this.zapValues = zapValues;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        for (int i = 0; i < this.zappedRegisters.length; ++i) {
            Register reg = this.zappedRegisters[i];
            if (reg == null) continue;
            AArch64Kind moveKind = (AArch64Kind)crb.target.arch.getPlatformKind(this.zapValues[i].getJavaKind());
            AArch64Move.const2reg(moveKind, crb, masm, reg, this.zapValues[i]);
        }
    }
}

