/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64.g1;

import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.aarch64.AArch64Call;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.aarch64.g1.AArch64G1BarrierSetLIRTool;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/12a61bce8db5e6b152eb101de1662847bebb7997/src/hotspot/cpu/aarch64/gc/g1/g1BarrierSetAssembler_aarch64.cpp#L185-L259", sha1="dd42f4d351403eb99f9bd76454131e0659be1565")
public class AArch64G1PostWriteBarrierOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64G1PostWriteBarrierOp> TYPE = LIRInstructionClass.create(AArch64G1PostWriteBarrierOp.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value address;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value newValue;
    @LIRInstruction.Temp
    private Value temp;
    @LIRInstruction.Temp
    private Value temp2;
    private final ForeignCallLinkage callTarget;
    private final boolean nonNull;
    private final AArch64G1BarrierSetLIRTool tool;

    public AArch64G1PostWriteBarrierOp(Value address, Value value, Value temp, AllocatableValue temp2, ForeignCallLinkage callTarget, boolean nonNull, AArch64G1BarrierSetLIRTool tool) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.address = address;
        this.newValue = value;
        this.temp = temp;
        this.temp2 = temp2;
        this.callTarget = callTarget;
        this.nonNull = nonNull;
        this.tool = tool;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register storeAddress = ValueUtil.asRegister((Value)this.address);
        Register newval = ValueUtil.asRegister((Value)this.newValue);
        Register thread = this.tool.getThread(masm);
        Register tmp1 = ValueUtil.asRegister((Value)this.temp);
        Register tmp2 = ValueUtil.asRegister((Value)this.temp2);
        Assembler.guaranteeDifferentRegisters(storeAddress, thread, tmp1, tmp2);
        Label done = new Label();
        Label runtime = new Label();
        masm.eor(64, tmp1, storeAddress, newval);
        masm.lsr(64, tmp1, tmp1, this.tool.logOfHeapRegionGrainBytes());
        masm.cbz(64, tmp1, done);
        if (!this.nonNull) {
            masm.cbz(64, newval, done);
        }
        Register cardPointer = tmp1;
        this.tool.computeCard(cardPointer, storeAddress, tmp2, masm);
        AArch64Address cardAddress = masm.makeAddress(8, cardPointer, 0);
        masm.ldr(8, tmp2, cardAddress);
        masm.compare(32, tmp2, this.tool.youngCardValue());
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, done);
        assert (this.tool.dirtyCardValue() == 0) : "must be 0";
        masm.dmb(AArch64Assembler.BarrierKind.ANY_ANY);
        masm.ldr(8, tmp2, cardAddress);
        masm.cbz(32, tmp2, done);
        if (GraalOptions.AssemblyGCBarriersSlowPathOnly.getValue(crb.getOptions()).booleanValue()) {
            masm.jmp(runtime);
        } else {
            masm.str(8, AArch64.zr, cardAddress);
            try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();){
                Register rscratch1 = sc1.getRegister();
                AArch64Address cardQueueIndex = masm.makeAddress(64, thread, this.tool.cardQueueIndexOffset());
                AArch64Address cardQueueBuffer = masm.makeAddress(64, thread, this.tool.cardQueueBufferOffset());
                masm.ldr(64, rscratch1, cardQueueIndex);
                masm.cbz(64, rscratch1, runtime);
                masm.sub(64, rscratch1, rscratch1, 8);
                masm.str(64, rscratch1, cardQueueIndex);
                masm.ldr(64, tmp2, cardQueueBuffer);
                masm.str(64, cardPointer, AArch64Address.createRegisterOffsetAddress(64, tmp2, rscratch1, false));
            }
        }
        masm.bind(done);
        crb.getLIR().addSlowPath(this, () -> {
            try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();){
                Register scratch1 = sc1.getRegister();
                masm.bind(runtime);
                CallingConvention cc = this.callTarget.getOutgoingCallingConvention();
                AArch64Address cArg0 = (AArch64Address)crb.asAddress((Value)cc.getArgument(0));
                masm.str(64, cardPointer, cArg0);
                AArch64Call.directCall(crb, masm, this.callTarget, AArch64Call.isNearCall(this.callTarget) ? null : scratch1, null);
                masm.jmp(done);
            }
        });
    }
}

