/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64.g1;

import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.aarch64.AArch64Call;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.aarch64.g1.AArch64G1BarrierSetLIRTool;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/5860a48c71e324f77a7ecc613c063cbb81580011/src/hotspot/cpu/aarch64/gc/g1/g1BarrierSetAssembler_aarch64.cpp#L98-L183", sha1="9b21f261fba89d49673568e85193159286db3ef5")
public class AArch64G1PreWriteBarrierOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64G1PreWriteBarrierOp> TYPE = LIRInstructionClass.create(AArch64G1PreWriteBarrierOp.class);
    @LIRInstruction.Alive
    private Value address;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value expectedObject;
    @LIRInstruction.Temp
    private Value temp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value temp2;
    private final ForeignCallLinkage callTarget;
    private final boolean nonNull;
    private final AArch64G1BarrierSetLIRTool tool;

    public AArch64G1PreWriteBarrierOp(Value address, Value expectedObject, Value temp, AllocatableValue temp2, ForeignCallLinkage callTarget, boolean nonNull, AArch64G1BarrierSetLIRTool tool) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.address = address;
        assert (expectedObject.equals((Object)Value.ILLEGAL) ^ temp2.equals((Object)Value.ILLEGAL)) : "only one register is necessary";
        this.expectedObject = expectedObject;
        this.temp = temp;
        this.temp2 = temp2;
        this.callTarget = callTarget;
        this.nonNull = nonNull;
        this.tool = tool;
        GraalError.guarantee(expectedObject.equals((Object)Value.ILLEGAL) || expectedObject.getPlatformKind().getSizeInBytes() == 8, "expected uncompressed pointer");
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register storeAddress = ValueUtil.asRegister((Value)this.address);
        Register thread = this.tool.getThread(masm);
        Register tmp = ValueUtil.asRegister((Value)this.temp);
        Register previousValue = this.expectedObject.equals((Object)Value.ILLEGAL) ? ValueUtil.asRegister((Value)this.temp2) : ValueUtil.asRegister((Value)this.expectedObject);
        Assembler.guaranteeDifferentRegisters(storeAddress, thread, tmp, previousValue);
        Label done = new Label();
        Label runtime = new Label();
        AArch64Address markingActive = masm.makeAddress(8, thread, this.tool.satbQueueMarkingActiveOffset());
        masm.ldr(8, tmp, markingActive);
        masm.cbz(32, tmp, done);
        if (this.expectedObject.equals((Object)Value.ILLEGAL)) {
            this.tool.loadObject(masm, previousValue, storeAddress);
        }
        if (!this.nonNull) {
            masm.cbz(64, previousValue, done);
        }
        if (GraalOptions.VerifyAssemblyGCBarriers.getValue(crb.getOptions()).booleanValue()) {
            try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();){
                Register tmp2 = sc1.getRegister();
                this.tool.verifyOop(masm, previousValue, tmp, tmp2, false, true);
            }
        }
        if (GraalOptions.AssemblyGCBarriersSlowPathOnly.getValue(crb.getOptions()).booleanValue()) {
            masm.jmp(runtime);
        } else {
            AArch64Address satbQueueIndex = masm.makeAddress(64, thread, this.tool.satbQueueIndexOffset());
            masm.ldr(64, tmp, satbQueueIndex);
            masm.cbz(64, tmp, runtime);
            masm.sub(64, tmp, tmp, 8);
            masm.str(64, tmp, satbQueueIndex);
            try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();){
                Register scratch1 = sc1.getRegister();
                AArch64Address satbQueueBuffer = masm.makeAddress(64, thread, this.tool.satbQueueBufferOffset());
                masm.ldr(64, scratch1, satbQueueBuffer);
                masm.add(64, tmp, tmp, scratch1);
            }
            masm.str(64, previousValue, masm.makeAddress(64, tmp, 0));
        }
        masm.bind(done);
        crb.getLIR().addSlowPath(this, () -> {
            try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();){
                Register scratch1 = sc1.getRegister();
                masm.bind(runtime);
                CallingConvention cc = this.callTarget.getOutgoingCallingConvention();
                AArch64Address cArg0 = (AArch64Address)crb.asAddress((Value)cc.getArgument(0));
                masm.str(64, previousValue, cArg0);
                AArch64Call.directCall(crb, masm, this.callTarget, AArch64Call.isNearCall(this.callTarget) ? null : scratch1, null);
                masm.jmp(done);
            }
        });
    }
}

