/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.alloc.lsra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.alloc.RegisterAllocationConfig;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.lir.alloc.lsra.Interval;
import jdk.graal.compiler.lir.alloc.lsra.LinearScanAssignLocationsPhase;
import jdk.graal.compiler.lir.alloc.lsra.LinearScanEliminateSpillMovePhase;
import jdk.graal.compiler.lir.alloc.lsra.LinearScanIntervalDumper;
import jdk.graal.compiler.lir.alloc.lsra.LinearScanLifetimeAnalysisPhase;
import jdk.graal.compiler.lir.alloc.lsra.LinearScanOptimizeSpillPositionPhase;
import jdk.graal.compiler.lir.alloc.lsra.LinearScanRegisterAllocationPhase;
import jdk.graal.compiler.lir.alloc.lsra.LinearScanResolveDataFlowPhase;
import jdk.graal.compiler.lir.alloc.lsra.MoveResolver;
import jdk.graal.compiler.lir.alloc.lsra.Range;
import jdk.graal.compiler.lir.alloc.lsra.RegisterVerifier;
import jdk.graal.compiler.lir.framemap.FrameMapBuilder;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.gen.MoveFactory;
import jdk.graal.compiler.lir.phases.AllocationPhase;
import jdk.graal.compiler.lir.phases.LIRPhase;
import jdk.graal.compiler.options.NestedBooleanOptionKey;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.Pair;

public class LinearScan {
    public static final int DOMINATOR_SPILL_MOVE_ID = -2;
    private static final int SPLIT_INTERVALS_CAPACITY_RIGHT_SHIFT = 1;
    private static final int ALMOST_SORTED_THRESHOLD = 64;
    private final LIR ir;
    private final FrameMapBuilder frameMapBuilder;
    private final RegisterAttributes[] registerAttributes;
    private final RegisterArray registers;
    private final RegisterAllocationConfig regAllocConfig;
    private final MoveFactory moveFactory;
    private final BlockMap<BlockData> blockData;
    protected final DebugContext debug;
    private final int[] sortedBlocks;
    private Interval[] intervals;
    private int intervalsSize;
    private int firstDerivedIntervalIndex = -1;
    private Interval[] sortedIntervals;
    private LIRInstruction[] opIdToInstructionMap;
    private BasicBlock<?>[] opIdToBlockMap;
    private final int firstVariableNumber;
    private int numVariables;
    private final boolean neverSpillConstants;
    protected final Interval intervalEndMarker;
    public final Range rangeEndMarker;
    public final boolean detailedAsserts;
    private final LIRGenerationResult res;
    static final IntervalPredicate IS_PRECOLORED_INTERVAL = new IntervalPredicate(){

        @Override
        public boolean apply(Interval i) {
            return ValueUtil.isRegister((Value)i.operand);
        }
    };
    static final IntervalPredicate IS_VARIABLE_INTERVAL = new IntervalPredicate(){

        @Override
        public boolean apply(Interval i) {
            return LIRValueUtil.isVariable((Value)i.operand);
        }
    };

    protected LinearScan(TargetDescription target, LIRGenerationResult res, MoveFactory spillMoveFactory, RegisterAllocationConfig regAllocConfig, int[] sortedBlocks, boolean neverSpillConstants) {
        this.ir = res.getLIR();
        this.res = res;
        this.debug = this.ir.getDebug();
        this.moveFactory = spillMoveFactory;
        this.frameMapBuilder = res.getFrameMapBuilder();
        this.sortedBlocks = sortedBlocks;
        this.registerAttributes = regAllocConfig.getRegisterConfig().getAttributesMap();
        this.regAllocConfig = regAllocConfig;
        this.registers = target.arch.getRegisters();
        this.firstVariableNumber = this.getRegisters().size();
        this.numVariables = this.ir.numVariables();
        this.blockData = new BlockMap(this.ir.getControlFlowGraph());
        this.neverSpillConstants = neverSpillConstants;
        this.rangeEndMarker = new Range(Integer.MAX_VALUE, Integer.MAX_VALUE, null, this.ir);
        this.intervalEndMarker.next = this.intervalEndMarker = new Interval(this.ir, Value.ILLEGAL, Integer.MIN_VALUE, null, this.rangeEndMarker);
        this.detailedAsserts = Assertions.detailedAssertionsEnabled(this.ir.getOptions());
    }

    public int getVariableNumber(int operand) {
        if (operand >= this.firstVariableNumber) {
            return operand - this.firstVariableNumber;
        }
        return -1;
    }

    public LIRGenerationResult getLIRGenerationResult() {
        return this.res;
    }

    public OptionValues getOptions() {
        return this.ir.getOptions();
    }

    public DebugContext getDebug() {
        return this.debug;
    }

    public int getFirstLirInstructionId(BasicBlock<?> block) {
        int result = this.ir.getLIRforBlock(block).get(0).id();
        assert (NumUtil.assertNonNegativeInt(result));
        return result;
    }

    public int getLastLirInstructionId(BasicBlock<?> block) {
        ArrayList<LIRInstruction> instructions = this.ir.getLIRforBlock(block);
        int result = instructions.get(instructions.size() - 1).id();
        assert (NumUtil.assertNonNegativeInt(result));
        return result;
    }

    public MoveFactory getSpillMoveFactory() {
        return this.moveFactory;
    }

    protected MoveResolver createMoveResolver() {
        MoveResolver moveResolver = new MoveResolver(this);
        assert (moveResolver.checkEmpty());
        return moveResolver;
    }

    public static boolean isVariableOrRegister(Value value) {
        return LIRValueUtil.isVariable(value) || ValueUtil.isRegister((Value)value);
    }

    int operandNumber(Value op) {
        Value operand = LIRValueUtil.stripCast(op);
        if (ValueUtil.isRegister((Value)operand)) {
            int number = ValueUtil.asRegister((Value)operand).number;
            assert (number < this.firstVariableNumber) : number + " " + this.firstVariableNumber;
            return number;
        }
        assert (LIRValueUtil.isVariable(operand)) : operand;
        return this.firstVariableNumber + LIRValueUtil.asVariable((Value)operand).index;
    }

    int operandSize() {
        return this.firstVariableNumber + this.numVariables;
    }

    int maxRegisterNumber() {
        return this.firstVariableNumber - 1;
    }

    public BlockData getBlockData(BasicBlock<?> block) {
        return this.blockData.get(block);
    }

    void initBlockData(BasicBlock<?> block) {
        this.blockData.put(block, new BlockData());
    }

    public RegisterAttributes attributes(Register reg) {
        return this.registerAttributes[reg.number];
    }

    void assignSpillSlot(Interval interval) {
        if (interval.canMaterialize()) {
            interval.assignLocation(Value.ILLEGAL);
        } else if (interval.spillSlot() != null) {
            interval.assignLocation(interval.spillSlot());
        } else {
            VirtualStackSlot slot = this.frameMapBuilder.allocateSpillSlot(interval.kind());
            interval.setSpillSlot(slot);
            interval.assignLocation(slot);
        }
    }

    public Interval[] intervals() {
        return this.intervals;
    }

    void initIntervals() {
        this.intervalsSize = this.operandSize();
        this.intervals = new Interval[this.intervalsSize + (this.intervalsSize >> 1)];
    }

    Interval createInterval(AllocatableValue operand) {
        assert (ValueUtil.isLegal((Value)operand));
        int operandNumber = this.operandNumber((Value)operand);
        Interval interval = new Interval(this.ir, operand, operandNumber, this.intervalEndMarker, this.rangeEndMarker);
        assert (operandNumber < this.intervalsSize) : operandNumber + " " + this.intervalsSize;
        assert (this.intervals[operandNumber] == null);
        this.intervals[operandNumber] = interval;
        return interval;
    }

    Interval createDerivedInterval(Interval source) {
        if (this.firstDerivedIntervalIndex == -1) {
            this.firstDerivedIntervalIndex = this.intervalsSize;
        }
        if (this.intervalsSize == this.intervals.length) {
            this.intervals = Arrays.copyOf(this.intervals, this.intervals.length + (this.intervals.length >> 1) + 1);
        }
        ++this.intervalsSize;
        assert (this.intervalsSize <= this.intervals.length) : this.intervalsSize + " " + this.intervals.length;
        Variable variable = new Variable(source.kind(), this.numVariables++);
        Interval interval = this.createInterval(variable);
        assert (this.intervals[this.intervalsSize - 1] == interval) : String.valueOf(this.intervals[this.intervalsSize - 1]) + " " + String.valueOf(interval);
        return interval;
    }

    public int blockCount() {
        return this.sortedBlocks.length;
    }

    public BasicBlock<?> blockAt(int index) {
        return this.ir.getBlockById(this.sortedBlocks[index]);
    }

    public int liveSetSize() {
        return this.firstDerivedIntervalIndex == -1 ? this.operandSize() : this.firstDerivedIntervalIndex;
    }

    int numLoops() {
        return this.ir.getControlFlowGraph().getLoops().size();
    }

    Interval intervalFor(int operandNumber) {
        return this.intervals[operandNumber];
    }

    public Interval intervalFor(Value operand) {
        int operandNumber = this.operandNumber(operand);
        assert (operandNumber < this.intervalsSize) : operandNumber + " " + this.intervalsSize;
        return this.intervals[operandNumber];
    }

    public Interval getOrCreateInterval(AllocatableValue operand) {
        Interval ret = this.intervalFor((Value)operand);
        if (ret == null) {
            return this.createInterval(operand);
        }
        return ret;
    }

    void initOpIdMaps(int numInstructions) {
        this.opIdToInstructionMap = new LIRInstruction[numInstructions];
        this.opIdToBlockMap = new BasicBlock[numInstructions];
    }

    void putOpIdMaps(int index, LIRInstruction op, BasicBlock<?> block) {
        this.opIdToInstructionMap[index] = op;
        this.opIdToBlockMap[index] = block;
    }

    int maxOpId() {
        assert (this.opIdToInstructionMap.length > 0) : "no operations";
        return this.opIdToInstructionMap.length - 1 << 1;
    }

    private static int opIdToIndex(int opId) {
        return opId >> 1;
    }

    public LIRInstruction instructionForId(int opId) {
        assert (CodeUtil.isEven((int)opId)) : "opId not even";
        LIRInstruction instr = this.opIdToInstructionMap[LinearScan.opIdToIndex(opId)];
        assert (instr.id() == opId) : Assertions.errorMessage(instr, opId);
        return instr;
    }

    public BasicBlock<?> blockForId(int opId) {
        assert (this.opIdToBlockMap.length > 0 && opId >= 0 && opId <= this.maxOpId() + 1) : "opId out of range";
        return this.opIdToBlockMap[LinearScan.opIdToIndex(opId)];
    }

    boolean isBlockBegin(int opId) {
        return opId == 0 || this.blockForId(opId) != this.blockForId(opId - 1);
    }

    boolean hasCall(int opId) {
        assert (CodeUtil.isEven((int)opId)) : "opId not even";
        return this.instructionForId(opId).destroysCallerSavedRegisters();
    }

    public boolean isProcessed(Value operand) {
        return !ValueUtil.isRegister((Value)operand) || this.attributes(ValueUtil.asRegister((Value)operand)).isAllocatable();
    }

    private static boolean isSorted(Interval[] intervals) {
        int from = -1;
        for (Interval interval : intervals) {
            assert (interval != null);
            assert (from <= interval.from()) : from + " " + interval.from();
            from = interval.from();
        }
        return true;
    }

    static Interval addToList(Interval first, Interval prev, Interval interval) {
        Interval newFirst = first;
        if (prev != null) {
            prev.next = interval;
        } else {
            newFirst = interval;
        }
        return newFirst;
    }

    Pair<Interval, Interval> createUnhandledLists(IntervalPredicate isList1, IntervalPredicate isList2) {
        assert (LinearScan.isSorted(this.sortedIntervals)) : "interval list is not sorted";
        Interval list1 = this.intervalEndMarker;
        Interval list2 = this.intervalEndMarker;
        Interval list1Prev = null;
        Interval list2Prev = null;
        for (Interval v : this.sortedIntervals) {
            if (v == null) continue;
            if (isList1.apply(v)) {
                list1 = LinearScan.addToList(list1, list1Prev, v);
                list1Prev = v;
                continue;
            }
            if (isList2 != null && !isList2.apply(v)) continue;
            list2 = LinearScan.addToList(list2, list2Prev, v);
            list2Prev = v;
        }
        if (list1Prev != null) {
            list1Prev.next = this.intervalEndMarker;
        }
        if (list2Prev != null) {
            list2Prev.next = this.intervalEndMarker;
        }
        assert (list1Prev == null || list1Prev.next.isEndMarker()) : "linear list ends not with sentinel";
        assert (list2Prev == null || list2Prev.next.isEndMarker()) : "linear list ends not with sentinel";
        return Pair.create((Object)list1, (Object)list2);
    }

    private static void sortIntervals(Interval[] intervals) {
        Arrays.sort(intervals, (a, b) -> a.from() - b.from());
    }

    protected void sortIntervalsBeforeAllocation() {
        int sortedLen = 0;
        int notSorted = 0;
        int sortedFromMax = -1;
        for (Interval interval : this.intervals) {
            if (interval == null) continue;
            ++sortedLen;
            int from = interval.from();
            if (sortedFromMax <= from) {
                sortedFromMax = interval.from();
                continue;
            }
            ++notSorted;
        }
        Interval[] sortedList = new Interval[sortedLen];
        if (notSorted > 0 && notSorted <= 64) {
            LinearScan.sortIntervalsAlmostSorted(this.intervals, sortedList);
        } else {
            int sortedIdx = 0;
            for (Interval interval : this.intervals) {
                if (interval == null) continue;
                sortedList[sortedIdx++] = interval;
            }
            if (notSorted > 0) {
                LinearScan.sortIntervals(sortedList);
            }
        }
        this.sortedIntervals = sortedList;
    }

    private static void sortIntervalsAlmostSorted(Interval[] intervals, Interval[] sortedList) {
        int sortedIdx = 0;
        int sortedFromMax = -1;
        for (Interval interval : intervals) {
            if (interval == null) continue;
            int from = interval.from();
            if (sortedFromMax <= from) {
                sortedList[sortedIdx++] = interval;
                sortedFromMax = interval.from();
                continue;
            }
            for (int j = sortedIdx - 1; j >= 0 && from < sortedList[j].from(); --j) {
                sortedList[j + 1] = sortedList[j];
            }
            sortedList[j + 1] = interval;
            ++sortedIdx;
        }
    }

    void sortIntervalsAfterAllocation() {
        if (this.firstDerivedIntervalIndex == -1) {
            return;
        }
        Interval[] oldList = this.sortedIntervals;
        Interval[] newList = Arrays.copyOfRange(this.intervals, this.firstDerivedIntervalIndex, this.intervalsSize);
        int oldLen = oldList.length;
        int newLen = newList.length;
        LinearScan.sortIntervals(newList);
        Interval[] combinedList = new Interval[oldLen + newLen];
        int oldIdx = 0;
        int newIdx = 0;
        while (oldIdx + newIdx < combinedList.length) {
            if (newIdx >= newLen || oldIdx < oldLen && oldList[oldIdx].from() <= newList[newIdx].from()) {
                combinedList[oldIdx + newIdx] = oldList[oldIdx];
                ++oldIdx;
                continue;
            }
            combinedList[oldIdx + newIdx] = newList[newIdx];
            ++newIdx;
        }
        this.sortedIntervals = combinedList;
    }

    public Interval splitChildAtOpId(Interval interval, int opId, LIRInstruction.OperandMode mode) {
        Interval result = interval.getSplitChildAtOpId(opId, mode, this);
        if (result != null) {
            if (this.debug.isLogEnabled()) {
                this.debug.log("Split child at pos %d of interval %s is %s", (Object)opId, (Object)interval, (Object)result);
            }
            return result;
        }
        throw new GraalError("LinearScan: interval is null");
    }

    static AllocatableValue canonicalSpillOpr(Interval interval) {
        assert (interval.spillSlot() != null) : "canonical spill slot not set";
        return interval.spillSlot();
    }

    boolean isMaterialized(AllocatableValue operand, int opId, LIRInstruction.OperandMode mode) {
        Interval interval = this.intervalFor((Value)operand);
        assert (interval != null) : "interval must exist";
        if (opId != -1) {
            interval = this.splitChildAtOpId(interval, opId, mode);
        }
        return ValueUtil.isIllegal((Value)interval.location()) && interval.canMaterialize();
    }

    boolean isCallerSave(Value operand) {
        return this.attributes(ValueUtil.asRegister((Value)operand)).isCallerSave();
    }

    protected void allocate(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        try (Indent indent = this.debug.logAndIndent("LinearScan allocate");){
            this.createLifetimeAnalysisPhase().apply(target, lirGenRes, context);
            try (DebugContext.Scope s = this.debug.scope((Object)"AfterLifetimeAnalysis", (Object)this.intervals);){
                this.sortIntervalsBeforeAllocation();
                this.createRegisterAllocationPhase().apply(target, lirGenRes, context);
                if (Options.LIROptLSRAOptimizeSpillPosition.getValue(this.getOptions()).booleanValue()) {
                    this.createOptimizeSpillPositionPhase().apply(target, lirGenRes, context);
                }
                this.createResolveDataFlowPhase().apply(target, lirGenRes, context);
                this.sortIntervalsAfterAllocation();
                if (this.detailedAsserts) {
                    this.verify();
                }
                this.beforeSpillMoveElimination();
                this.createSpillMoveEliminationPhase().apply(target, lirGenRes, context);
                this.createAssignLocationsPhase().apply(target, lirGenRes, context);
                if (this.detailedAsserts) {
                    this.verifyIntervals();
                }
            }
            catch (Throwable e) {
                throw this.debug.handle(e);
            }
        }
    }

    protected void beforeSpillMoveElimination() {
    }

    protected LinearScanLifetimeAnalysisPhase createLifetimeAnalysisPhase() {
        return new LinearScanLifetimeAnalysisPhase(this);
    }

    protected LinearScanRegisterAllocationPhase createRegisterAllocationPhase() {
        return new LinearScanRegisterAllocationPhase(this);
    }

    protected LinearScanOptimizeSpillPositionPhase createOptimizeSpillPositionPhase() {
        return new LinearScanOptimizeSpillPositionPhase(this);
    }

    protected LinearScanResolveDataFlowPhase createResolveDataFlowPhase() {
        return new LinearScanResolveDataFlowPhase(this);
    }

    protected LinearScanEliminateSpillMovePhase createSpillMoveEliminationPhase() {
        return new LinearScanEliminateSpillMovePhase(this);
    }

    protected LinearScanAssignLocationsPhase createAssignLocationsPhase() {
        return new LinearScanAssignLocationsPhase(this);
    }

    public void printIntervals(String label) {
        if (this.debug.isLogEnabled()) {
            try (Indent indent = this.debug.logAndIndent("intervals %s", (Object)label);){
                for (Interval interval : this.intervals) {
                    if (interval == null) continue;
                    this.debug.log("%s", (Object)interval.logString(this));
                }
                try (Indent indent2 = this.debug.logAndIndent("Basic Blocks");){
                    for (int i = 0; i < this.blockCount(); ++i) {
                        BasicBlock<?> block = this.blockAt(i);
                        this.debug.log("B%d [%d, %d, %s] ", block.getId(), (Object)this.getFirstLirInstructionId(block), (Object)this.getLastLirInstructionId(block), block.getLoop());
                    }
                }
            }
        }
        this.debug.dump(2, new LinearScanIntervalDumper(Arrays.copyOf(this.intervals, this.intervalsSize)), label);
    }

    boolean verify() {
        this.verifyIntervals();
        this.verifyRegisters();
        this.debug.log("no errors found");
        return true;
    }

    private void verifyRegisters() {
        try (Indent indent = this.debug.logAndIndent("verifying register allocation");){
            RegisterVerifier verifier = new RegisterVerifier(this);
            verifier.verify(this.blockAt(0));
        }
    }

    protected void verifyIntervals() {
        try (Indent indent = this.debug.logAndIndent("verifying intervals");){
            int len = this.intervalsSize;
            for (int i = 0; i < len; ++i) {
                Interval i1 = this.intervals[i];
                if (i1 == null) continue;
                i1.checkSplitChildren();
                if (i1.operandNumber != i) {
                    this.debug.log("Interval %d is on position %d in list", i1.operandNumber, i);
                    this.debug.log(i1.logString(this));
                    throw new GraalError("");
                }
                if (LIRValueUtil.isVariable((Value)i1.operand) && i1.kind().equals((Object)LIRKind.Illegal)) {
                    this.debug.log("Interval %d has no type assigned", i1.operandNumber);
                    this.debug.log(i1.logString(this));
                    throw new GraalError("");
                }
                if (i1.location() == null) {
                    this.debug.log("Interval %d has no register assigned", i1.operandNumber);
                    this.debug.log(i1.logString(this));
                    throw new GraalError("");
                }
                if (i1.first().isEndMarker()) {
                    this.debug.log("Interval %d has no Range", i1.operandNumber);
                    this.debug.log(i1.logString(this));
                    throw new GraalError("");
                }
                Range r = i1.first();
                while (!r.isEndMarker()) {
                    if (r.from >= r.to) {
                        this.debug.log("Interval %d has zero length range", i1.operandNumber);
                        this.debug.log(i1.logString(this));
                        throw new GraalError("");
                    }
                    r = r.next;
                }
                for (int j = i + 1; j < len; ++j) {
                    Interval i2 = this.intervals[j];
                    if (i2 == null || i1.from() == 1 && i1.to() == 2 || i2.from() == 1 && i2.to() == 2) continue;
                    AllocatableValue l1 = i1.location();
                    AllocatableValue l2 = i2.location();
                    if (!i1.intersects(i2) || ValueUtil.isIllegal((Value)l1) || !l1.equals((Object)l2)) continue;
                    throw GraalError.shouldNotReachHere(String.format("Intervals %d and %d overlap and have the same register assigned\n%s\n%s", i1.operandNumber, i2.operandNumber, i1.logString(this), i2.logString(this)));
                }
            }
        }
    }

    public LIR getLIR() {
        return this.ir;
    }

    public FrameMapBuilder getFrameMapBuilder() {
        return this.frameMapBuilder;
    }

    public int[] sortedBlocks() {
        return this.sortedBlocks;
    }

    public RegisterArray getRegisters() {
        return this.registers;
    }

    public RegisterAllocationConfig getRegisterAllocationConfig() {
        return this.regAllocConfig;
    }

    public boolean callKillsRegisters() {
        return this.regAllocConfig.getRegisterConfig().areAllAllocatableRegistersCallerSaved();
    }

    boolean neverSpillConstants() {
        return this.neverSpillConstants;
    }

    public static class BlockData {
        public BitSet liveIn;
        public BitSet liveOut;
        public BitSet liveGen;
        public BitSet liveKill;
    }

    static abstract class IntervalPredicate {
        IntervalPredicate() {
        }

        abstract boolean apply(Interval var1);
    }

    public static class Options {
        public static final OptionKey<Boolean> LIROptLSRAOptimizeSpillPosition = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
    }
}

