/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.alloc.lsra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.core.common.alloc.RegisterAllocationConfig;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.util.Util;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.alloc.OutOfRegistersException;
import jdk.graal.compiler.lir.alloc.lsra.Interval;
import jdk.graal.compiler.lir.alloc.lsra.IntervalWalker;
import jdk.graal.compiler.lir.alloc.lsra.LinearScan;
import jdk.graal.compiler.lir.alloc.lsra.MoveResolver;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

class LinearScanWalker
extends IntervalWalker {
    private static final CounterKey intervalSplits = DebugContext.counter("LinearScanWalker[intervalSplits]");
    private static final CounterKey spillSlotsAssigned = DebugContext.counter("LinearScanWalker[spillSlotsAssigned]");
    protected Register[] availableRegs;
    protected final int[] usePos;
    protected final int[] blockPos;
    protected List<Interval>[] spillIntervals;
    private MoveResolver moveResolver;
    private int minReg;
    private int maxReg;
    private static final List<Interval> EMPTY_LIST = Collections.emptyList();

    int blockCount() {
        return this.allocator.blockCount();
    }

    BasicBlock<?> blockAt(int idx) {
        return this.allocator.blockAt(idx);
    }

    LinearScanWalker(LinearScan allocator, Interval unhandledFixedFirst, Interval unhandledAnyFirst) {
        super(allocator, unhandledFixedFirst, unhandledAnyFirst);
        this.moveResolver = allocator.createMoveResolver();
        this.spillIntervals = (List[])Util.uncheckedCast(new List[allocator.getRegisters().size()]);
        for (int i = 0; i < allocator.getRegisters().size(); ++i) {
            this.spillIntervals[i] = EMPTY_LIST;
        }
        this.usePos = new int[allocator.getRegisters().size()];
        this.blockPos = new int[allocator.getRegisters().size()];
    }

    void initUseLists(boolean onlyProcessUsePos) {
        for (Register register : this.availableRegs) {
            int i = register.number;
            this.usePos[i] = Integer.MAX_VALUE;
            if (onlyProcessUsePos) continue;
            this.blockPos[i] = Integer.MAX_VALUE;
            this.spillIntervals[i].clear();
        }
    }

    int maxRegisterNumber() {
        return this.maxReg;
    }

    int minRegisterNumber() {
        return this.minReg;
    }

    boolean isRegisterInRange(int reg) {
        return reg >= this.minRegisterNumber() && reg <= this.maxRegisterNumber();
    }

    void excludeFromUse(Interval i) {
        AllocatableValue location = i.location();
        int i1 = ValueUtil.asRegister((Value)location).number;
        if (this.isRegisterInRange(i1)) {
            this.usePos[i1] = 0;
        }
    }

    void setUsePos(Interval interval, int usePos, boolean onlyProcessUsePos) {
        if (usePos != -1) {
            assert (usePos != 0) : "must use excludeFromUse to set usePos to 0";
            int i = ValueUtil.asRegister((Value)interval.location()).number;
            if (this.isRegisterInRange(i)) {
                if (this.usePos[i] > usePos) {
                    this.usePos[i] = usePos;
                }
                if (!onlyProcessUsePos) {
                    List<Interval> list = this.spillIntervals[i];
                    if (list == EMPTY_LIST) {
                        this.spillIntervals[i] = list = new ArrayList<Interval>(2);
                    }
                    list.add(interval);
                }
            }
        }
    }

    void setBlockPos(Interval i, int blockPos) {
        int reg;
        if (blockPos != -1 && this.isRegisterInRange(reg = ValueUtil.asRegister((Value)i.location()).number)) {
            if (this.blockPos[reg] > blockPos) {
                this.blockPos[reg] = blockPos;
            }
            if (this.usePos[reg] > blockPos) {
                this.usePos[reg] = blockPos;
            }
        }
    }

    void freeExcludeActiveFixed() {
        Interval interval = this.activeLists.get(Interval.RegisterBinding.Fixed);
        while (!interval.isEndMarker()) {
            assert (ValueUtil.isRegister((Value)interval.location())) : "active interval must have a register assigned";
            this.excludeFromUse(interval);
            interval = interval.next;
        }
    }

    void freeExcludeActiveAny() {
        Interval interval = this.activeLists.get(Interval.RegisterBinding.Any);
        while (!interval.isEndMarker()) {
            assert (ValueUtil.isRegister((Value)interval.location())) : "active interval must have a register assigned";
            this.excludeFromUse(interval);
            interval = interval.next;
        }
    }

    void freeCollectInactiveFixed(Interval current) {
        Interval interval = this.inactiveLists.get(Interval.RegisterBinding.Fixed);
        while (!interval.isEndMarker()) {
            if (current.to() <= interval.currentFrom()) {
                assert (interval.currentIntersectsAt(current) == -1) : "must not intersect";
                this.setUsePos(interval, interval.currentFrom(), true);
            } else {
                this.setUsePos(interval, interval.currentIntersectsAt(current), true);
            }
            interval = interval.next;
        }
    }

    void freeCollectInactiveAny(Interval current) {
        Interval interval = this.inactiveLists.get(Interval.RegisterBinding.Any);
        while (!interval.isEndMarker()) {
            this.setUsePos(interval, interval.currentIntersectsAt(current), true);
            interval = interval.next;
        }
    }

    void spillExcludeActiveFixed() {
        Interval interval = this.activeLists.get(Interval.RegisterBinding.Fixed);
        while (!interval.isEndMarker()) {
            this.excludeFromUse(interval);
            interval = interval.next;
        }
    }

    void spillBlockInactiveFixed(Interval current) {
        Interval interval = this.inactiveLists.get(Interval.RegisterBinding.Fixed);
        while (!interval.isEndMarker()) {
            if (current.to() > interval.currentFrom()) {
                this.setBlockPos(interval, interval.currentIntersectsAt(current));
            } else assert (interval.currentIntersectsAt(current) == -1) : "invalid optimization: intervals intersect";
            interval = interval.next;
        }
    }

    void spillCollectActiveAny(Interval.RegisterPriority registerPriority) {
        Interval interval = this.activeLists.get(Interval.RegisterBinding.Any);
        while (!interval.isEndMarker()) {
            this.setUsePos(interval, Math.min(interval.nextUsage(registerPriority, this.currentPosition), interval.to()), false);
            interval = interval.next;
        }
    }

    void spillCollectInactiveAny(Interval current) {
        Interval interval = this.inactiveLists.get(Interval.RegisterBinding.Any);
        while (!interval.isEndMarker()) {
            if (interval.currentIntersects(current)) {
                this.setUsePos(interval, Math.min(interval.nextUsage(Interval.RegisterPriority.LiveAtLoopEnd, this.currentPosition), interval.to()), false);
            }
            interval = interval.next;
        }
    }

    void insertMove(int operandId, Interval srcIt, Interval dstIt) {
        int opId = operandId + 1 & 0xFFFFFFFE;
        BasicBlock<?> opBlock = this.allocator.blockForId(opId);
        assert (opId > 0 && this.allocator.blockForId(opId - 2) == opBlock) : "cannot insert move at block boundary";
        ArrayList<LIRInstruction> instructions = this.allocator.getLIR().getLIRforBlock(opBlock);
        int index = opId - instructions.get(0).id() >> 1;
        assert (instructions.get(index).id() <= opId) : "error in calculation";
        while (instructions.get(index).id() != opId) {
            assert (0 <= ++index && index < instructions.size()) : "index out of bounds";
        }
        assert (this.allocator.getLIRGenerationResult().getFirstInsertPosition() <= index && index < instructions.size()) : "index out of bounds";
        assert (instructions.get(index).id() == opId) : "error in calculation";
        this.moveResolver.moveInsertPosition(instructions, index);
        this.moveResolver.addMapping(srcIt, dstIt);
    }

    int findOptimalSplitPos(BasicBlock<?> minBlock, BasicBlock<?> maxBlock, int maxSplitPos) {
        int fromBlockNr = minBlock.getLinearScanNumber();
        int toBlockNr = maxBlock.getLinearScanNumber();
        assert (0 <= fromBlockNr && fromBlockNr < this.blockCount()) : "out of range";
        assert (0 <= toBlockNr && toBlockNr < this.blockCount()) : "out of range";
        assert (fromBlockNr < toBlockNr) : "must cross block boundary";
        int optimalSplitPos = this.allocator.getLastLirInstructionId(maxBlock) + 2;
        if (optimalSplitPos > maxSplitPos) {
            optimalSplitPos = this.allocator.getFirstLirInstructionId(maxBlock);
        }
        int minLoopDepth = maxBlock.getLoopDepth();
        for (int i = toBlockNr - 1; minLoopDepth > 0 && i >= fromBlockNr; --i) {
            BasicBlock<?> cur = this.blockAt(i);
            if (cur.getLoopDepth() >= minLoopDepth) continue;
            minLoopDepth = cur.getLoopDepth();
            optimalSplitPos = this.allocator.getLastLirInstructionId(cur) + 2;
        }
        assert (optimalSplitPos > this.allocator.maxOpId() || this.allocator.isBlockBegin(optimalSplitPos)) : "algorithm must move split pos to block boundary";
        return optimalSplitPos;
    }

    int findOptimalSplitPos(Interval interval, int minSplitPos, int maxSplitPos, boolean doLoopOptimization) {
        DebugContext debug = this.allocator.getDebug();
        int optimalSplitPos = -1;
        if (minSplitPos == maxSplitPos) {
            if (debug.isLogEnabled()) {
                debug.log("min-pos and max-pos are equal, no optimization possible");
            }
            optimalSplitPos = minSplitPos;
        } else {
            assert (minSplitPos < maxSplitPos) : "must be true then";
            assert (minSplitPos > 0) : "cannot access minSplitPos - 1 otherwise";
            BasicBlock<?> minBlock = this.allocator.blockForId(minSplitPos - 1);
            BasicBlock<?> maxBlock = this.allocator.blockForId(maxSplitPos - 1);
            assert (minBlock.getLinearScanNumber() <= maxBlock.getLinearScanNumber()) : "invalid order";
            if (minBlock == maxBlock) {
                if (debug.isLogEnabled()) {
                    debug.log("cannot move split pos to block boundary because minPos and maxPos are in same block");
                }
                optimalSplitPos = maxSplitPos;
            } else if (interval.hasHoleBetween(maxSplitPos - 1, maxSplitPos) && !this.allocator.isBlockBegin(maxSplitPos)) {
                if (debug.isLogEnabled()) {
                    debug.log("interval has hole just before maxSplitPos, so splitting at maxSplitPos");
                }
                optimalSplitPos = maxSplitPos;
            } else {
                if (debug.isLogEnabled()) {
                    debug.log("moving split pos to optimal block boundary between block B%d and B%d", minBlock.getId(), maxBlock.getId());
                }
                if (doLoopOptimization) {
                    int loopEndPos = interval.nextUsageExact(Interval.RegisterPriority.LiveAtLoopEnd, this.allocator.getLastLirInstructionId(minBlock) + 2);
                    if (debug.isLogEnabled()) {
                        debug.log("loop optimization: loop end found at pos %d", loopEndPos);
                    }
                    assert (loopEndPos > minSplitPos) : "invalid order";
                    if (loopEndPos < maxSplitPos) {
                        BasicBlock<?> loopBlock = this.allocator.blockForId(loopEndPos);
                        if (debug.isLogEnabled()) {
                            debug.log("interval is used in loop that ends in block B%d, so trying to move maxBlock back from B%d to B%d", loopBlock.getId(), maxBlock.getId(), loopBlock.getId());
                        }
                        assert (loopBlock != minBlock) : "loopBlock and minBlock must be different because block boundary is needed between";
                        int maxSpillPos = this.allocator.getLastLirInstructionId(loopBlock) + 2;
                        optimalSplitPos = this.findOptimalSplitPos(minBlock, loopBlock, maxSpillPos);
                        if (optimalSplitPos == maxSpillPos) {
                            optimalSplitPos = -1;
                            if (debug.isLogEnabled()) {
                                debug.log("loop optimization not necessary");
                            }
                        } else if (debug.isLogEnabled()) {
                            debug.log("loop optimization successful");
                        }
                    }
                }
                if (optimalSplitPos == -1) {
                    optimalSplitPos = this.findOptimalSplitPos(minBlock, maxBlock, maxSplitPos);
                }
            }
        }
        if (debug.isLogEnabled()) {
            debug.log("optimal split position: %d", optimalSplitPos);
        }
        return optimalSplitPos;
    }

    void splitBeforeUsage(Interval interval, int minSplitPos, int maxSplitPos) {
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent = debug.logAndIndent("splitting interval %s between %d and %d", (Object)interval, minSplitPos, maxSplitPos);){
            boolean moveNecessary;
            assert (interval.from() < minSplitPos) : "cannot split at start of interval";
            assert (this.currentPosition < minSplitPos) : "cannot split before current position";
            assert (minSplitPos <= maxSplitPos) : "invalid order";
            assert (maxSplitPos <= interval.to()) : "cannot split after end of interval";
            int optimalSplitPos = this.findOptimalSplitPos(interval, minSplitPos, maxSplitPos, true);
            assert (minSplitPos <= optimalSplitPos && optimalSplitPos <= maxSplitPos) : "out of range";
            assert (optimalSplitPos <= interval.to()) : "cannot split after end of interval";
            assert (optimalSplitPos > interval.from()) : "cannot split at start of interval";
            if (optimalSplitPos == interval.to() && interval.nextUsage(Interval.RegisterPriority.MustHaveRegister, minSplitPos) == Integer.MAX_VALUE) {
                if (debug.isLogEnabled()) {
                    debug.log("no split necessary because optimal split position is at end of interval");
                }
                return;
            }
            boolean bl = moveNecessary = !this.allocator.isBlockBegin(optimalSplitPos) && !interval.hasHoleBetween(optimalSplitPos - 1, optimalSplitPos);
            if (!this.allocator.isBlockBegin(optimalSplitPos)) {
                optimalSplitPos = optimalSplitPos - 1 | 1;
            }
            if (debug.isLogEnabled()) {
                debug.log("splitting at position %d", optimalSplitPos);
            }
            assert (this.allocator.isBlockBegin(optimalSplitPos) || (optimalSplitPos & 1) == 1) : "split pos must be odd when not on block boundary";
            assert (!this.allocator.isBlockBegin(optimalSplitPos) || (optimalSplitPos & 1) == 0) : "split pos must be even on block boundary";
            Interval splitPart = interval.split(optimalSplitPos, this.allocator);
            intervalSplits.increment(debug);
            splitPart.setInsertMoveWhenActivated(moveNecessary);
            assert (splitPart.from() >= this.currentPosition) : "cannot append new interval before current walk position";
            this.unhandledLists.addToListSortedByStartAndUsePositions(Interval.RegisterBinding.Any, splitPart);
            if (debug.isLogEnabled()) {
                debug.log("left interval  %s: %s", (Object)(moveNecessary ? "      " : ""), (Object)interval.logString(this.allocator));
                debug.log("right interval %s: %s", (Object)(moveNecessary ? "(move)" : ""), (Object)splitPart.logString(this.allocator));
            }
        }
    }

    void splitForSpilling(Interval interval) {
        block39: {
            DebugContext debug = this.allocator.getDebug();
            int maxSplitPos = this.currentPosition;
            int previousUsage = interval.previousUsage(Interval.RegisterPriority.ShouldHaveRegister, maxSplitPos);
            if (previousUsage == this.currentPosition) {
                previousUsage = interval.previousUsage(Interval.RegisterPriority.MustHaveRegister, maxSplitPos);
            }
            int minSplitPos = Math.max(previousUsage + 1, interval.from());
            try (Indent indent = debug.logAndIndent("splitting and spilling interval %s between %d and %d", (Object)interval, minSplitPos, maxSplitPos);){
                assert (interval.state == Interval.State.Active) : "why spill interval that is not active?";
                assert (interval.from() <= minSplitPos) : "cannot split before start of interval";
                assert (minSplitPos <= maxSplitPos) : "invalid order";
                assert (maxSplitPos < interval.to()) : "cannot split at end end of interval";
                assert (this.currentPosition < interval.to()) : "interval must not end before current position";
                if (minSplitPos == interval.from()) {
                    try (Indent indent2 = debug.logAndIndent("spilling entire interval because split pos is at beginning of interval (use positions: %d)", interval.usePosList().size());){
                        assert (interval.firstUsage(Interval.RegisterPriority.MustHaveRegister) > this.currentPosition) : String.format("interval %s must not have use position before currentPosition %d", interval, this.currentPosition);
                        this.allocator.assignSpillSlot(interval);
                        this.handleSpillSlot(interval);
                        this.changeSpillState(interval, minSplitPos);
                        spillSlotsAssigned.increment(debug);
                        Interval parent = interval;
                        while (parent != null && parent.isSplitChild()) {
                            if (!ValueUtil.isRegister((Value)(parent = parent.getSplitChildBeforeOpId(parent.from())).location())) continue;
                            if (parent.firstUsage(Interval.RegisterPriority.ShouldHaveRegister) == Integer.MAX_VALUE) {
                                if (debug.isLogEnabled()) {
                                    debug.log("kicking out interval %d out of its register because it is never used", parent.operandNumber);
                                }
                                this.allocator.assignSpillSlot(parent);
                                this.handleSpillSlot(parent);
                                spillSlotsAssigned.increment(debug);
                                continue;
                            }
                            parent = null;
                        }
                        break block39;
                    }
                }
                int optimalSplitPos = this.findOptimalSplitPos(interval, minSplitPos, maxSplitPos, false);
                assert (minSplitPos <= optimalSplitPos && optimalSplitPos <= maxSplitPos) : "out of range";
                assert (optimalSplitPos < interval.to()) : "cannot split at end of interval";
                assert (optimalSplitPos >= interval.from()) : "cannot split before start of interval";
                if (!this.allocator.isBlockBegin(optimalSplitPos)) {
                    optimalSplitPos = optimalSplitPos - 1 | 1;
                }
                try (Indent indent2 = debug.logAndIndent("splitting at position %d", optimalSplitPos);){
                    assert (this.allocator.isBlockBegin(optimalSplitPos) || (optimalSplitPos & 1) == 1) : "split pos must be odd when not on block boundary";
                    assert (!this.allocator.isBlockBegin(optimalSplitPos) || (optimalSplitPos & 1) == 0) : "split pos must be even on block boundary";
                    Interval spilledPart = interval.split(optimalSplitPos, this.allocator);
                    this.allocator.assignSpillSlot(spilledPart);
                    this.handleSpillSlot(spilledPart);
                    this.changeSpillState(spilledPart, optimalSplitPos);
                    intervalSplits.increment(debug);
                    spillSlotsAssigned.increment(debug);
                    if (!this.allocator.isBlockBegin(optimalSplitPos)) {
                        if (debug.isLogEnabled()) {
                            debug.log("inserting move from interval %d to %d", interval.operandNumber, spilledPart.operandNumber);
                        }
                        this.insertMove(optimalSplitPos, interval, spilledPart);
                    }
                    assert (spilledPart.currentSplitChild() == interval) : "overwriting wrong currentSplitChild";
                    spilledPart.makeCurrentSplitChild();
                    if (debug.isLogEnabled()) {
                        debug.log("left interval: %s", (Object)interval.logString(this.allocator));
                        debug.log("spilled interval   : %s", (Object)spilledPart.logString(this.allocator));
                    }
                }
            }
        }
    }

    private void changeSpillState(Interval interval, int spillPos) {
        switch (interval.spillState()) {
            case NoSpillStore: {
                int defLoopDepth = this.allocator.blockForId(interval.spillDefinitionPos()).getLoopDepth();
                int spillLoopDepth = this.allocator.blockForId(spillPos).getLoopDepth();
                if (defLoopDepth < spillLoopDepth) {
                    if (LinearScan.Options.LIROptLSRAOptimizeSpillPosition.getValue(this.allocator.getOptions()).booleanValue()) {
                        interval.setSpillState(Interval.SpillState.SpillInDominator);
                        break;
                    }
                    interval.setSpillState(Interval.SpillState.StoreAtDefinition);
                    break;
                }
                interval.setSpillState(Interval.SpillState.OneSpillStore);
                break;
            }
            case OneSpillStore: {
                int defLoopDepth = this.allocator.blockForId(interval.spillDefinitionPos()).getLoopDepth();
                int spillLoopDepth = this.allocator.blockForId(spillPos).getLoopDepth();
                if (defLoopDepth > spillLoopDepth) break;
                if (LinearScan.Options.LIROptLSRAOptimizeSpillPosition.getValue(this.allocator.getOptions()).booleanValue()) {
                    interval.setSpillState(Interval.SpillState.SpillInDominator);
                    break;
                }
                interval.setSpillState(Interval.SpillState.StoreAtDefinition);
                break;
            }
            case SpillInDominator: 
            case StoreAtDefinition: 
            case StartInMemory: 
            case NoOptimization: 
            case NoDefinitionFound: {
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("other states not allowed at this time");
            }
        }
    }

    protected void handleSpillSlot(Interval interval) {
        assert (interval.location() != null && (interval.canMaterialize() || LIRValueUtil.isStackSlotValue((Value)interval.location()))) : "interval not assigned to a stack slot " + String.valueOf(interval);
    }

    void splitStackInterval(Interval interval) {
        int minSplitPos = this.currentPosition + 1;
        int maxSplitPos = Math.min(interval.firstUsage(Interval.RegisterPriority.ShouldHaveRegister), interval.to());
        this.splitBeforeUsage(interval, minSplitPos, maxSplitPos);
    }

    void splitWhenPartialRegisterAvailable(Interval interval, int registerAvailableUntil) {
        int minSplitPos = Math.max(interval.previousUsage(Interval.RegisterPriority.ShouldHaveRegister, registerAvailableUntil), interval.from() + 1);
        this.splitBeforeUsage(interval, minSplitPos, registerAvailableUntil);
    }

    void splitAndSpillInterval(Interval interval, Register reg, int mustHaveRegUsePos) {
        assert (interval.state == Interval.State.Active || interval.state == Interval.State.Inactive) : "other states not allowed";
        int currentPos = this.currentPosition;
        if (interval.state == Interval.State.Inactive) {
            assert (interval.hasHoleBetween(currentPos - 1, currentPos + 1)) : "interval can not be inactive otherwise";
            this.splitBeforeUsage(interval, currentPos + 1, currentPos + 1);
        } else {
            int minSplitPos = currentPos + 1;
            int maxSplitPos = Math.min(interval.nextUsage(Interval.RegisterPriority.MustHaveRegister, minSplitPos), interval.to());
            this.splitBeforeUsage(interval, minSplitPos, maxSplitPos);
            assert (interval.nextUsage(Interval.RegisterPriority.MustHaveRegister, currentPos) == Integer.MAX_VALUE) : "the remaining part is spilled to stack and therefore has no register";
            if (interval.to() >= mustHaveRegUsePos) {
                this.splitForSpilling(interval);
            } else {
                assert (reg != null);
                boolean needSplit = this.blockPos[reg.number] <= interval.to();
                int splitPos = this.blockPos[reg.number];
                assert (splitPos > 0) : "invalid splitPos";
                assert (needSplit || splitPos > interval.from()) : "splitting interval at from";
                interval.assignLocation((AllocatableValue)reg.asValue(interval.kind()));
                if (needSplit) {
                    this.splitWhenPartialRegisterAvailable(interval, splitPos);
                }
                this.splitAndSpillIntersectingIntervals(reg);
            }
        }
    }

    boolean allocFreeRegister(Interval interval) {
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent = debug.logAndIndent("trying to find free register for %s", interval);){
            this.initUseLists(true);
            this.freeExcludeActiveFixed();
            this.freeExcludeActiveAny();
            this.freeCollectInactiveFixed(interval);
            this.freeCollectInactiveAny(interval);
            assert (this.unhandledLists.get(Interval.RegisterBinding.Fixed).isEndMarker()) : "must not have unhandled fixed intervals because all fixed intervals have a use at position 0";
            if (debug.isLogEnabled()) {
                try (Indent indent2 = debug.logAndIndent("state of registers:");){
                    for (Register register : this.availableRegs) {
                        int i = register.number;
                        debug.log("reg %d: usePos: %d", register.number, this.usePos[i]);
                    }
                }
            }
            Register hint = null;
            Interval locationHint = interval.locationHint(true);
            if (locationHint != null && locationHint.location() != null && ValueUtil.isRegister((Value)locationHint.location())) {
                hint = ValueUtil.asRegister((Value)locationHint.location());
                if (debug.isLogEnabled()) {
                    debug.log("hint register %d from interval %s", hint.number, (Object)locationHint);
                }
            }
            assert (interval.location() == null) : "register already assigned to interval";
            int partialRegRequestedUntil = interval.from() + 1 + (interval.isSplitChild() ? 2 : 0);
            int intervalTo = interval.to();
            boolean needSplit = false;
            int splitPos = -1;
            Register reg = null;
            Register minFullReg = null;
            Register maxPartialReg = null;
            for (Register availableReg : this.availableRegs) {
                int number = availableReg.number;
                if (this.usePos[number] >= intervalTo) {
                    if (minFullReg != null && !availableReg.equals((Object)hint) && (this.usePos[number] >= this.usePos[minFullReg.number] || minFullReg.equals((Object)hint))) continue;
                    minFullReg = availableReg;
                    continue;
                }
                if (this.usePos[number] <= partialRegRequestedUntil || maxPartialReg != null && !availableReg.equals((Object)hint) && (this.usePos[number] <= this.usePos[maxPartialReg.number] || maxPartialReg.equals((Object)hint))) continue;
                maxPartialReg = availableReg;
            }
            if (minFullReg != null) {
                reg = minFullReg;
            } else if (maxPartialReg != null) {
                needSplit = true;
                reg = maxPartialReg;
            } else {
                boolean bl = false;
                return bl;
            }
            splitPos = this.usePos[reg.number];
            interval.assignLocation((AllocatableValue)reg.asValue(interval.kind()));
            if (debug.isLogEnabled()) {
                debug.log("selected register %d", reg.number);
            }
            assert (splitPos > 0) : "invalid splitPos";
            if (needSplit) {
                this.splitWhenPartialRegisterAvailable(interval, splitPos);
            }
            boolean bl = true;
            return bl;
        }
    }

    void splitAndSpillIntersectingIntervals(Register reg) {
        assert (reg != null) : "no register assigned";
        for (int i = 0; i < this.spillIntervals[reg.number].size(); ++i) {
            Interval interval = this.spillIntervals[reg.number].get(i);
            this.removeFromList(interval);
            this.splitAndSpillInterval(interval, null, -1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void allocLockedRegister(Interval interval) {
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent = debug.logAndIndent("alloc locked register: need to split and spill to get register for %s", interval);){
            int regUsePos;
            Register reg;
            int firstUsage = interval.firstUsage(Interval.RegisterPriority.MustHaveRegister);
            int firstShouldHaveUsage = interval.firstUsage(Interval.RegisterPriority.ShouldHaveRegister);
            int regNeededUntil = Math.min(firstUsage, interval.from() + 1);
            int intervalTo = interval.to();
            if (!$assertionsDisabled) {
                if (regNeededUntil < 0) throw new AssertionError((Object)"interval has no use");
                if (regNeededUntil >= Integer.MAX_VALUE) {
                    throw new AssertionError((Object)"interval has no use");
                }
            }
            Interval.RegisterPriority registerPriority = Interval.RegisterPriority.LiveAtLoopEnd;
            while (true) {
                this.initUseLists(false);
                this.spillExcludeActiveFixed();
                assert (this.unhandledLists.get(Interval.RegisterBinding.Fixed).isEndMarker()) : "must not have unhandled fixed intervals because all fixed intervals have a use at position 0";
                this.spillBlockInactiveFixed(interval);
                this.spillCollectActiveAny(registerPriority);
                this.spillCollectInactiveAny(interval);
                if (debug.isLogEnabled()) {
                    this.printRegisterState();
                }
                reg = null;
                Register ignore = interval.location() != null && ValueUtil.isRegister((Value)interval.location()) ? ValueUtil.asRegister((Value)interval.location()) : null;
                for (Register availableReg : this.availableRegs) {
                    int number = availableReg.number;
                    if (availableReg.equals((Object)ignore) || this.usePos[number] <= regNeededUntil || reg != null && this.usePos[number] <= this.usePos[reg.number]) continue;
                    reg = availableReg;
                }
                int n = regUsePos = reg == null ? 0 : this.usePos[reg.number];
                if (regUsePos > firstShouldHaveUsage) break;
                if (debug.isLogEnabled()) {
                    debug.log("able to spill current interval. firstUsage(register): %d, usePos: %d", firstUsage, regUsePos);
                }
                if (firstUsage > interval.from() + 1) {
                    this.splitAndSpillInterval(interval, reg, regUsePos);
                    return;
                }
                if (!registerPriority.equals((Object)Interval.RegisterPriority.LiveAtLoopEnd)) {
                    String description = LinearScanWalker.generateOutOfRegErrorMsg(interval, firstUsage, this.availableRegs);
                    this.allocator.assignSpillSlot(interval);
                    debug.dump(2, this.allocator.getLIR(), description);
                    this.allocator.printIntervals(description);
                    throw new OutOfRegistersException("LinearScan: no register found", description);
                }
                debug.log("retry with register priority must have register");
                registerPriority = Interval.RegisterPriority.MustHaveRegister;
            }
            if (debug.isLogEnabled()) {
                debug.log("not able to spill current interval. firstUsage(register): %d, usePos: %d", firstUsage, regUsePos);
            }
            assert (reg != null);
            boolean needSplit = this.blockPos[reg.number] <= intervalTo;
            int splitPos = this.blockPos[reg.number];
            if (debug.isLogEnabled()) {
                debug.log("decided to use register %d", reg.number);
            }
            assert (splitPos > 0) : "invalid splitPos";
            assert (needSplit || splitPos > interval.from()) : "splitting interval at from";
            interval.assignLocation((AllocatableValue)reg.asValue(interval.kind()));
            if (needSplit) {
                this.splitWhenPartialRegisterAvailable(interval, splitPos);
            }
            this.splitAndSpillIntersectingIntervals(reg);
            return;
        }
    }

    private static String generateOutOfRegErrorMsg(Interval interval, int firstUsage, Register[] availableRegs) {
        return "Cannot spill interval (" + String.valueOf(interval) + ") that is used in first instruction (possible reason: no register found) firstUsage=" + firstUsage + ", interval.from()=" + interval.from() + "; already used candidates: " + Arrays.toString(availableRegs);
    }

    void printRegisterState() {
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent2 = debug.logAndIndent("state of registers:");){
            for (Register reg : this.availableRegs) {
                int i = reg.number;
                try (Indent indent3 = debug.logAndIndent("reg %d: usePos: %d, blockPos: %d, intervals: ", i, this.usePos[i], this.blockPos[i]);){
                    for (int j = 0; j < this.spillIntervals[i].size(); ++j) {
                        debug.log("%s ", this.spillIntervals[i].get(j));
                    }
                }
            }
        }
    }

    boolean noAllocationPossible(Interval interval) {
        int pos;
        if (this.allocator.callKillsRegisters() && CodeUtil.isOdd((int)(pos = interval.from())) && pos < this.allocator.maxOpId() && this.allocator.hasCall(pos + 1) && interval.to() > pos + 1) {
            DebugContext debug = this.allocator.getDebug();
            if (debug.isLogEnabled()) {
                debug.log("free register cannot be available because all registers blocked by following call");
            }
            assert (!this.allocFreeRegister(interval)) : "found a register for this interval";
            return true;
        }
        return false;
    }

    void initVarsForAlloc(Interval interval) {
        RegisterAllocationConfig.AllocatableRegisters allocatableRegisters = this.allocator.getRegisterAllocationConfig().getAllocatableRegisters(interval.kind().getPlatformKind());
        if (allocatableRegisters == null) {
            throw new OutOfRegistersException("There are no allocatable registers for kind " + String.valueOf(interval.kind().getPlatformKind()) + ", consider assigning fixed registers.");
        }
        this.availableRegs = allocatableRegisters.allocatableRegisters;
        this.minReg = allocatableRegisters.minRegisterNumber;
        this.maxReg = allocatableRegisters.maxRegisterNumber;
    }

    static boolean isMove(LIRInstruction op, Interval from, Interval to) {
        StandardOp.ValueMoveOp move;
        if (StandardOp.ValueMoveOp.isValueMoveOp(op) && LIRValueUtil.isVariable((Value)(move = StandardOp.ValueMoveOp.asValueMoveOp(op)).getInput()) && LIRValueUtil.isVariable((Value)move.getResult())) {
            return move.getInput() != null && move.getInput().equals((Object)from.operand) && move.getResult() != null && move.getResult().equals((Object)to.operand);
        }
        return false;
    }

    void combineSpilledIntervals(Interval interval) {
        Interval endHint;
        if (interval.isSplitChild()) {
            return;
        }
        Interval registerHint = interval.locationHint(false);
        if (registerHint == null) {
            return;
        }
        assert (registerHint.isSplitParent()) : "register hint must be split parent";
        if (interval.spillState() != Interval.SpillState.NoOptimization || registerHint.spillState() != Interval.SpillState.NoOptimization) {
            return;
        }
        int beginPos = interval.from();
        int endPos = interval.to();
        if (endPos > this.allocator.maxOpId() || CodeUtil.isOdd((int)beginPos) || CodeUtil.isOdd((int)endPos)) {
            return;
        }
        if (!LinearScanWalker.isMove(this.allocator.instructionForId(beginPos), registerHint, interval) || !LinearScanWalker.isMove(this.allocator.instructionForId(endPos), interval, registerHint)) {
            return;
        }
        Interval beginHint = registerHint.getSplitChildAtOpId(beginPos, LIRInstruction.OperandMode.USE, this.allocator);
        if (beginHint == (endHint = registerHint.getSplitChildAtOpId(endPos, LIRInstruction.OperandMode.DEF, this.allocator)) || beginHint.to() != beginPos || endHint.from() != endPos) {
            return;
        }
        assert (beginHint.location() != null) : "must have register assigned";
        assert (endHint.location() == null) : "must not have register assigned";
        assert (interval.firstUsage(Interval.RegisterPriority.MustHaveRegister) == beginPos) : "must have use position at begin of interval because of move";
        assert (endHint.firstUsage(Interval.RegisterPriority.MustHaveRegister) == endPos) : "must have use position at begin of interval because of move";
        if (ValueUtil.isRegister((Value)beginHint.location())) {
            return;
        }
        assert (registerHint.spillSlot() != null) : "must be set when part of interval was spilled";
        interval.setSpillSlot(registerHint.spillSlot());
        interval.removeFirstUsePos();
        endHint.removeFirstUsePos();
    }

    @Override
    protected boolean activateCurrent(Interval interval) {
        boolean result = true;
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent = debug.logAndIndent("activating interval %s,  splitParent: %d", (Object)interval, interval.splitParent().operandNumber);){
            AllocatableValue operand = interval.operand;
            if (interval.location() != null && LIRValueUtil.isStackSlotValue((Value)interval.location())) {
                if (debug.isLogEnabled()) {
                    debug.log("interval has spill slot assigned (method parameter) . split it before first use");
                }
                this.splitStackInterval(interval);
                result = false;
            } else if (interval.location() == null) {
                if (debug.isLogEnabled()) {
                    debug.log("normal allocation of register");
                }
                this.combineSpilledIntervals(interval);
                this.initVarsForAlloc(interval);
                if (this.noAllocationPossible(interval) || !this.allocFreeRegister(interval)) {
                    this.allocLockedRegister(interval);
                }
                if (!ValueUtil.isRegister((Value)interval.location())) {
                    result = false;
                }
            }
            if (interval.insertMoveWhenActivated()) {
                assert (interval.isSplitChild());
                assert (interval.currentSplitChild() != null);
                assert (!interval.currentSplitChild().operand.equals((Object)operand)) : "cannot insert move between same interval";
                if (debug.isLogEnabled()) {
                    debug.log("Inserting move from interval %d to %d because insertMoveWhenActivated is set", interval.currentSplitChild().operandNumber, interval.operandNumber);
                }
                this.insertMove(interval.from(), interval.currentSplitChild(), interval);
            }
            interval.makeCurrentSplitChild();
        }
        return result;
    }

    public void finishAllocation() {
        this.moveResolver.resolveAndAppendMoves();
    }
}

