/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.alloc.lsra.ssa;

import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.alloc.lsra.Interval;
import jdk.graal.compiler.lir.alloc.lsra.LinearScan;
import jdk.graal.compiler.lir.alloc.lsra.LinearScanEliminateSpillMovePhase;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

public class SSALinearScanEliminateSpillMovePhase
extends LinearScanEliminateSpillMovePhase {
    SSALinearScanEliminateSpillMovePhase(LinearScan allocator) {
        super(allocator);
    }

    @Override
    protected int firstInstructionOfInterest() {
        return 0;
    }

    @Override
    protected boolean canEliminateSpillMove(BasicBlock<?> block, StandardOp.MoveOp move) {
        if (super.canEliminateSpillMove(block, move)) {
            Interval curInterval = this.allocator.intervalFor((Value)move.getResult());
            assert (!ValueUtil.isRegister((Value)curInterval.location()) && curInterval.alwaysInMemory()) : Assertions.errorMessage(curInterval);
            if (!this.isPhiResolutionMove(block, move, curInterval)) {
                assert (LIRValueUtil.isStackSlotValue((Value)curInterval.location())) : "Not a stack slot: " + String.valueOf(curInterval.location());
                return true;
            }
        }
        return false;
    }

    private boolean isPhiResolutionMove(BasicBlock<?> block, StandardOp.MoveOp move, Interval toInterval) {
        if (!toInterval.isSplitParent()) {
            return false;
        }
        if ((toInterval.from() & 1) == 1) {
            return false;
        }
        if (block.getSuccessorCount() != 1) {
            return false;
        }
        LIRInstruction op = this.allocator.instructionForId(toInterval.from());
        if (!(op instanceof StandardOp.LabelOp)) {
            return false;
        }
        BasicBlock<?> intStartBlock = this.allocator.blockForId(toInterval.from());
        assert (this.allocator.getLIR().getLIRforBlock(intStartBlock).get(0).equals(op));
        if (!block.getSuccessorAt(0).equals(intStartBlock)) {
            return false;
        }
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent = debug.indent();){
            debug.log("Is a move (%s) to phi interval %s", (Object)move, (Object)toInterval);
        }
        return true;
    }
}

