/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.amd64.AMD64AESEncryptOp;
import jdk.graal.compiler.lir.amd64.AMD64LIRHelper;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/ce8399fd6071766114f5f201b6e44a7abdba9f5a/src/hotspot/cpu/x86/stubGenerator_x86_64_aes.cpp#L1215-L1361", sha1="644bffae25607c21475e4b5f51476fa6117f4ca2")
public final class AMD64CipherBlockChainingAESEncryptOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64CipherBlockChainingAESEncryptOp> TYPE = LIRInstructionClass.create(AMD64CipherBlockChainingAESEncryptOp.class);
    private final int lengthOffset;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value fromValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value toValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value keyValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value rvecValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value lenValue;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value resultValue;
    @LIRInstruction.Temp
    protected Value[] temps;
    private static final int XMM_REG_NUM_KEY_FIRST = 2;

    public AMD64CipherBlockChainingAESEncryptOp(AllocatableValue fromValue, AllocatableValue toValue, AllocatableValue keyValue, AllocatableValue rvecValue, AllocatableValue lenValue, AllocatableValue resultValue, int lengthOffset) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.keyValue = keyValue;
        this.rvecValue = rvecValue;
        this.lenValue = lenValue;
        this.resultValue = resultValue;
        this.lengthOffset = lengthOffset;
        this.temps = new Value[]{AMD64.r11.asValue(), AMD64.xmm0.asValue(), AMD64.xmm1.asValue(), AMD64.xmm2.asValue(), AMD64.xmm3.asValue(), AMD64.xmm4.asValue(), AMD64.xmm5.asValue(), AMD64.xmm6.asValue(), AMD64.xmm7.asValue(), AMD64.xmm8.asValue(), AMD64.xmm9.asValue(), AMD64.xmm10.asValue(), AMD64.xmm11.asValue(), AMD64.xmm12.asValue(), AMD64.xmm13.asValue(), AMD64.xmm14.asValue(), AMD64.xmm15.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        int rnum;
        GraalError.guarantee(this.fromValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid fromValue kind: %s", (Object)this.fromValue);
        GraalError.guarantee(this.toValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid toValue kind: %s", (Object)this.toValue);
        GraalError.guarantee(this.keyValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid keyValue kind: %s", (Object)this.keyValue);
        GraalError.guarantee(this.rvecValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid rvecValue kind: %s", (Object)this.rvecValue);
        GraalError.guarantee(this.lenValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid lenValue kind: %s", (Object)this.lenValue);
        GraalError.guarantee(this.resultValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid resultValue kind: %s", (Object)this.resultValue);
        Register from = ValueUtil.asRegister((Value)this.fromValue);
        Register to = ValueUtil.asRegister((Value)this.toValue);
        Register key = ValueUtil.asRegister((Value)this.keyValue);
        Register rvec = ValueUtil.asRegister((Value)this.rvecValue);
        Register lenReg = AMD64.r11;
        masm.movq(lenReg, ValueUtil.asRegister((Value)this.lenValue));
        Register pos = ValueUtil.asRegister((Value)this.resultValue);
        Register xmmResult = AMD64.xmm0;
        Register xmmTemp = AMD64.xmm1;
        Register xmmKey0 = AMD64AESEncryptOp.asXMMRegister(2);
        Register xmmKey10 = AMD64AESEncryptOp.asXMMRegister(12);
        Register xmmKey11 = AMD64AESEncryptOp.asXMMRegister(13);
        Register xmmKey12 = AMD64AESEncryptOp.asXMMRegister(14);
        Register xmmKey13 = AMD64AESEncryptOp.asXMMRegister(15);
        Label labelExit = new Label();
        Label labelKey192or256 = new Label();
        Label labelKey256 = new Label();
        Label labelLoopTop128 = new Label();
        Label labelLoopTop192 = new Label();
        Label labelLoopTop256 = new Label();
        Register xmmKeyShufMask = xmmTemp;
        masm.movdqu(xmmKeyShufMask, AMD64LIRHelper.recordExternalAddress(crb, AMD64AESEncryptOp.keyShuffleMask));
        int offset = 0;
        for (rnum = 2; rnum <= 12; ++rnum) {
            AMD64AESEncryptOp.loadKey(masm, AMD64AESEncryptOp.asXMMRegister(rnum), key, offset, xmmKeyShufMask);
            offset += 16;
        }
        masm.movdqu(xmmResult, new AMD64Address(rvec, 0));
        masm.movl(pos, new AMD64Address(key, this.lengthOffset));
        masm.cmplAndJcc(pos, 44, AMD64Assembler.ConditionFlag.NotEqual, labelKey192or256, false);
        masm.movq(pos, 0L);
        masm.align(this.preferredLoopAlignment(crb));
        masm.bind(labelLoopTop128);
        masm.movdqu(xmmTemp, new AMD64Address(from, pos, Stride.S1, 0));
        masm.pxor(xmmResult, xmmTemp);
        masm.pxor(xmmResult, xmmKey0);
        for (rnum = 3; rnum <= 11; ++rnum) {
            masm.aesenc(xmmResult, AMD64AESEncryptOp.asXMMRegister(rnum));
        }
        masm.aesenclast(xmmResult, xmmKey10);
        masm.movdqu(new AMD64Address(to, pos, Stride.S1, 0), xmmResult);
        masm.addq(pos, 16);
        masm.subqAndJcc(lenReg, 16, AMD64Assembler.ConditionFlag.NotEqual, labelLoopTop128, false);
        masm.jmp(labelExit);
        masm.bind(labelKey192or256);
        AMD64AESEncryptOp.loadKey(masm, xmmKey11, key, 176, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmKey12, key, 192, xmmKeyShufMask);
        masm.cmplAndJcc(pos, 52, AMD64Assembler.ConditionFlag.NotEqual, labelKey256, false);
        masm.movq(pos, 0L);
        masm.align(this.preferredLoopAlignment(crb));
        masm.bind(labelLoopTop192);
        masm.movdqu(xmmTemp, new AMD64Address(from, pos, Stride.S1, 0));
        masm.pxor(xmmResult, xmmTemp);
        masm.pxor(xmmResult, xmmKey0);
        for (rnum = 3; rnum <= 13; ++rnum) {
            masm.aesenc(xmmResult, AMD64AESEncryptOp.asXMMRegister(rnum));
        }
        masm.aesenclast(xmmResult, xmmKey12);
        masm.movdqu(new AMD64Address(to, pos, Stride.S1, 0), xmmResult);
        masm.addq(pos, 16);
        masm.subqAndJcc(lenReg, 16, AMD64Assembler.ConditionFlag.NotEqual, labelLoopTop192, false);
        masm.jmp(labelExit);
        masm.bind(labelKey256);
        AMD64AESEncryptOp.loadKey(masm, xmmKey13, key, 208, xmmKeyShufMask);
        masm.movq(pos, 0L);
        masm.align(this.preferredLoopAlignment(crb));
        masm.bind(labelLoopTop256);
        masm.movdqu(xmmTemp, new AMD64Address(from, pos, Stride.S1, 0));
        masm.pxor(xmmResult, xmmTemp);
        masm.pxor(xmmResult, xmmKey0);
        for (rnum = 3; rnum <= 15; ++rnum) {
            masm.aesenc(xmmResult, AMD64AESEncryptOp.asXMMRegister(rnum));
        }
        AMD64AESEncryptOp.loadKey(masm, xmmTemp, key, 224, crb);
        masm.aesenclast(xmmResult, xmmTemp);
        masm.movdqu(new AMD64Address(to, pos, Stride.S1, 0), xmmResult);
        masm.addq(pos, 16);
        masm.subqAndJcc(lenReg, 16, AMD64Assembler.ConditionFlag.NotEqual, labelLoopTop256, false);
        masm.bind(labelExit);
        masm.movdqu(new AMD64Address(rvec, 0), xmmResult);
        masm.movl(ValueUtil.asRegister((Value)this.resultValue), ValueUtil.asRegister((Value)this.lenValue));
    }
}

