/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;

public class AMD64ConvertFloatToIntegerOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64ConvertFloatToIntegerOp> TYPE = LIRInstructionClass.create(AMD64ConvertFloatToIntegerOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value dstValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value srcValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value tmpValue;
    private final OpcodeEmitter opcode;
    private final boolean canBeNaN;
    private final boolean canOverflow;

    public AMD64ConvertFloatToIntegerOp(LIRGeneratorTool tool, OpcodeEmitter opcode, Value dstValue, Value srcValue, boolean canBeNaN, boolean canOverflow) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        AMD64Kind kind;
        this.dstValue = dstValue;
        this.srcValue = srcValue;
        this.opcode = opcode;
        this.tmpValue = canOverflow ? tool.newVariable(srcValue.getValueKind()) : Value.ILLEGAL;
        this.canBeNaN = canBeNaN;
        this.canOverflow = canOverflow;
        PlatformKind platformKind = srcValue.getPlatformKind();
        GraalError.guarantee(platformKind instanceof AMD64Kind && (kind = (AMD64Kind)platformKind).getVectorLength() == 1 && kind.isXMM(), "source must be scalar floating-point: %s", (Object)srcValue);
        platformKind = dstValue.getPlatformKind();
        GraalError.guarantee(platformKind instanceof AMD64Kind && (kind = (AMD64Kind)platformKind).getVectorLength() == 1 && kind.isInteger(), "destination must be integer: %s", (Object)dstValue);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.dstValue);
        Register src = ValueUtil.asRegister((Value)this.srcValue);
        Label fixupPath = new Label();
        Label done = new Label();
        this.opcode.emit(crb, masm, dst, src);
        if (!this.canBeNaN && !this.canOverflow) {
            return;
        }
        int integerBytes = this.dstValue.getPlatformKind().getSizeInBytes();
        GraalError.guarantee(integerBytes == 4 || integerBytes == 8, "unexpected target %s", (Object)this.dstValue);
        AMD64BaseAssembler.OperandSize floatSize = switch (this.srcValue.getPlatformKind().getSizeInBytes()) {
            case 4 -> AMD64BaseAssembler.OperandSize.PS;
            case 8 -> AMD64BaseAssembler.OperandSize.PD;
            default -> throw GraalError.shouldNotReachHere("unexpected input %s".formatted(this.srcValue));
        };
        if (integerBytes == 4) {
            masm.cmplAndJcc(dst, Integer.MIN_VALUE, AMD64Assembler.ConditionFlag.Equal, fixupPath, false);
        } else {
            masm.cmpq(dst, (AMD64Address)crb.asLongConstRef((JavaConstant)JavaConstant.forLong((long)Long.MIN_VALUE)));
            masm.jcc(AMD64Assembler.ConditionFlag.Equal, fixupPath);
        }
        crb.getLIR().addSlowPath(this, () -> {
            masm.bind(fixupPath);
            if (this.canBeNaN) {
                Label isNotNaN = new Label();
                AMD64Assembler.SSEOp.UCOMIS.emit((AMD64Assembler)masm, floatSize, src, src);
                masm.jcc(AMD64Assembler.ConditionFlag.NoParity, isNotNaN, true);
                masm.movl(dst, 0);
                masm.jmp(done);
                masm.bind(isNotNaN);
            }
            if (this.canOverflow) {
                Register zero = ValueUtil.asRegister((Value)this.tmpValue);
                masm.pxor(AVXKind.AVXSize.XMM, zero, zero);
                AMD64Assembler.SSEOp.UCOMIS.emit((AMD64Assembler)masm, floatSize, src, zero);
                masm.jcc(AMD64Assembler.ConditionFlag.BelowEqual, done);
                if (integerBytes == 4) {
                    masm.notl(dst);
                } else {
                    masm.notq(dst);
                }
            }
            masm.jmp(done);
        });
        masm.bind(done);
    }

    @FunctionalInterface
    public static interface OpcodeEmitter {
        public void emit(CompilationResultBuilder var1, AMD64MacroAssembler var2, Register var3, Register var4);
    }
}

