/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.asm.ArrayDataPointerConstant;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public final class AMD64LIRHelper {
    private AMD64LIRHelper() {
    }

    protected static Value[] registersToValues(Register[] registers) {
        Value[] temps = new Value[registers.length];
        for (int i = 0; i < registers.length; ++i) {
            Register register = registers[i];
            if (AMD64.CPU.equals((Object)register.getRegisterCategory())) {
                temps[i] = register.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.QWORD));
                continue;
            }
            if (AMD64.XMM.equals((Object)register.getRegisterCategory())) {
                temps[i] = register.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.DOUBLE));
                continue;
            }
            throw GraalError.shouldNotReachHere("Unsupported register type in math stubs.");
        }
        return temps;
    }

    protected static AMD64Address recordExternalAddress(CompilationResultBuilder crb, ArrayDataPointerConstant ptr) {
        return (AMD64Address)crb.recordDataReferenceInCode(ptr);
    }

    protected static ArrayDataPointerConstant pointerConstant(int alignment, int[] ints) {
        return new ArrayDataPointerConstant(ints, alignment);
    }

    protected static ArrayDataPointerConstant pointerConstant(int alignment, long[] longs) {
        return new ArrayDataPointerConstant(longs, alignment);
    }
}

