/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.SyncPorts;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPorts(value={@SyncPort(from="https://github.com/openjdk/jdk/blob/be2b92bd8b43841cc2b9c22ed4fde29be30d47bb/src/hotspot/cpu/x86/stubGenerator_x86_64.cpp#L1374-L1410", sha1="acf2eea69d799b0a1a38edaff048ff30f5257016"), @SyncPort(from="https://github.com/openjdk/jdk/blob/0487aa61c67de695d008af4fe75c2a3072261a6f/src/hotspot/cpu/x86/macroAssembler_x86_md5.cpp#L52-L209", sha1="5cb0a6acf3329957f7f5868a32d4d228f98595ab")})
public final class AMD64MD5Op
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64MD5Op> TYPE = LIRInstructionClass.create(AMD64MD5Op.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value bufValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value stateValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value limitValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value bufTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] temps;
    private final boolean multiBlock;

    public AMD64MD5Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue) {
        this(tool, bufValue, stateValue, Value.ILLEGAL, Value.ILLEGAL, false);
    }

    public AMD64MD5Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue, AllocatableValue ofsValue, AllocatableValue limitValue, boolean multiBlock) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.bufValue = bufValue;
        this.stateValue = stateValue;
        this.ofsValue = ofsValue;
        this.limitValue = limitValue;
        this.multiBlock = multiBlock;
        this.temps = new Value[]{AMD64.rax.asValue(), AMD64.rbx.asValue(), AMD64.rcx.asValue(), AMD64.rdi.asValue(), AMD64.rdx.asValue(), AMD64.rsi.asValue()};
        if (multiBlock) {
            this.bufTempValue = tool.newVariable(bufValue.getValueKind());
            this.ofsTempValue = tool.newVariable(ofsValue.getValueKind());
        } else {
            this.bufTempValue = Value.ILLEGAL;
            this.ofsTempValue = Value.ILLEGAL;
        }
    }

    private static void md5FF(AMD64MacroAssembler masm, Register buf, Register r1, Register r2, Register r3, Register r4, int k, int s, int t) {
        masm.addl(r1, t);
        masm.movl(AMD64.rsi, r3);
        masm.addl(r1, new AMD64Address(buf, k * 4));
        masm.xorl(AMD64.rsi, r4);
        masm.andl(AMD64.rsi, r2);
        masm.xorl(AMD64.rsi, r4);
        masm.addl(r1, AMD64.rsi);
        masm.roll(r1, s);
        masm.addl(r1, r2);
    }

    private static void md5GG(AMD64MacroAssembler masm, Register buf, Register r1, Register r2, Register r3, Register r4, int k, int s, int t) {
        masm.addl(r1, t);
        masm.movl(AMD64.rsi, r4);
        masm.movl(AMD64.rdi, r4);
        masm.addl(r1, new AMD64Address(buf, k * 4));
        masm.notl(AMD64.rsi);
        masm.andl(AMD64.rdi, r2);
        masm.andl(AMD64.rsi, r3);
        masm.orl(AMD64.rsi, AMD64.rdi);
        masm.addl(r1, AMD64.rsi);
        masm.roll(r1, s);
        masm.addl(r1, r2);
    }

    private static void md5HH(AMD64MacroAssembler masm, Register buf, Register r1, Register r2, Register r3, Register r4, int k, int s, int t) {
        masm.addl(r1, t);
        masm.movl(AMD64.rsi, r3);
        masm.addl(r1, new AMD64Address(buf, k * 4));
        masm.xorl(AMD64.rsi, r4);
        masm.xorl(AMD64.rsi, r2);
        masm.addl(r1, AMD64.rsi);
        masm.roll(r1, s);
        masm.addl(r1, r2);
    }

    private static void md5II(AMD64MacroAssembler masm, Register buf, Register r1, Register r2, Register r3, Register r4, int k, int s, int t) {
        masm.addl(r1, t);
        masm.movl(AMD64.rsi, r4);
        masm.notl(AMD64.rsi);
        masm.addl(r1, new AMD64Address(buf, k * 4));
        masm.orl(AMD64.rsi, r2);
        masm.xorl(AMD64.rsi, r3);
        masm.addl(r1, AMD64.rsi);
        masm.roll(r1, s);
        masm.addl(r1, r2);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register limit;
        Register ofs;
        Register buf;
        GraalError.guarantee(this.bufValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid bufValue kind: %s", (Object)this.bufValue);
        GraalError.guarantee(this.stateValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid stateValue kind: %s", (Object)this.stateValue);
        Register state = ValueUtil.asRegister((Value)this.stateValue);
        if (this.multiBlock) {
            GraalError.guarantee(this.ofsValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid ofsValue kind: %s", (Object)this.ofsValue);
            GraalError.guarantee(this.limitValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid limitValue kind: %s", (Object)this.limitValue);
            buf = ValueUtil.asRegister((Value)this.bufTempValue);
            ofs = ValueUtil.asRegister((Value)this.ofsTempValue);
            limit = ValueUtil.asRegister((Value)this.limitValue);
            masm.movq(buf, ValueUtil.asRegister((Value)this.bufValue));
            masm.movl(ofs, ValueUtil.asRegister((Value)this.ofsValue));
        } else {
            buf = ValueUtil.asRegister((Value)this.bufValue);
            ofs = Register.None;
            limit = Register.None;
        }
        Label loop0 = new Label();
        masm.movq(AMD64.rdi, state);
        masm.movl(AMD64.rax, new AMD64Address(AMD64.rdi, 0));
        masm.movl(AMD64.rbx, new AMD64Address(AMD64.rdi, 4));
        masm.movl(AMD64.rcx, new AMD64Address(AMD64.rdi, 8));
        masm.movl(AMD64.rdx, new AMD64Address(AMD64.rdi, 12));
        masm.bind(loop0);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 0, 7, -680876936);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 1, 12, -389564586);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 2, 17, 606105819);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 3, 22, -1044525330);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 4, 7, -176418897);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 5, 12, 1200080426);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 6, 17, -1473231341);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 7, 22, -45705983);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 8, 7, 1770035416);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 9, 12, -1958414417);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 10, 17, -42063);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 11, 22, -1990404162);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 12, 7, 1804603682);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 13, 12, -40341101);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 14, 17, -1502002290);
        AMD64MD5Op.md5FF(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 15, 22, 1236535329);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 1, 5, -165796510);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 6, 9, -1069501632);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 11, 14, 643717713);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 0, 20, -373897302);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 5, 5, -701558691);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 10, 9, 38016083);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 15, 14, -660478335);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 4, 20, -405537848);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 9, 5, 568446438);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 14, 9, -1019803690);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 3, 14, -187363961);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 8, 20, 1163531501);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 13, 5, -1444681467);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 2, 9, -51403784);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 7, 14, 1735328473);
        AMD64MD5Op.md5GG(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 12, 20, -1926607734);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 5, 4, -378558);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 8, 11, -2022574463);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 11, 16, 1839030562);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 14, 23, -35309556);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 1, 4, -1530992060);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 4, 11, 1272893353);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 7, 16, -155497632);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 10, 23, -1094730640);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 13, 4, 681279174);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 0, 11, -358537222);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 3, 16, -722521979);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 6, 23, 76029189);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 9, 4, -640364487);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 12, 11, -421815835);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 15, 16, 530742520);
        AMD64MD5Op.md5HH(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 2, 23, -995338651);
        AMD64MD5Op.md5II(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 0, 6, -198630844);
        AMD64MD5Op.md5II(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 7, 10, 1126891415);
        AMD64MD5Op.md5II(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 14, 15, -1416354905);
        AMD64MD5Op.md5II(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 5, 21, -57434055);
        AMD64MD5Op.md5II(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 12, 6, 1700485571);
        AMD64MD5Op.md5II(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 3, 10, -1894986606);
        AMD64MD5Op.md5II(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 10, 15, -1051523);
        AMD64MD5Op.md5II(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 1, 21, -2054922799);
        AMD64MD5Op.md5II(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 8, 6, 1873313359);
        AMD64MD5Op.md5II(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 15, 10, -30611744);
        AMD64MD5Op.md5II(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 6, 15, -1560198380);
        AMD64MD5Op.md5II(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 13, 21, 1309151649);
        AMD64MD5Op.md5II(masm, buf, AMD64.rax, AMD64.rbx, AMD64.rcx, AMD64.rdx, 4, 6, -145523070);
        AMD64MD5Op.md5II(masm, buf, AMD64.rdx, AMD64.rax, AMD64.rbx, AMD64.rcx, 11, 10, -1120210379);
        AMD64MD5Op.md5II(masm, buf, AMD64.rcx, AMD64.rdx, AMD64.rax, AMD64.rbx, 2, 15, 718787259);
        AMD64MD5Op.md5II(masm, buf, AMD64.rbx, AMD64.rcx, AMD64.rdx, AMD64.rax, 9, 21, -343485551);
        masm.movq(AMD64.rdi, state);
        masm.addl(AMD64.rax, new AMD64Address(AMD64.rdi, 0));
        masm.movl(new AMD64Address(AMD64.rdi, 0), AMD64.rax);
        masm.addl(AMD64.rbx, new AMD64Address(AMD64.rdi, 4));
        masm.movl(new AMD64Address(AMD64.rdi, 4), AMD64.rbx);
        masm.addl(AMD64.rcx, new AMD64Address(AMD64.rdi, 8));
        masm.movl(new AMD64Address(AMD64.rdi, 8), AMD64.rcx);
        masm.addl(AMD64.rdx, new AMD64Address(AMD64.rdi, 12));
        masm.movl(new AMD64Address(AMD64.rdi, 12), AMD64.rdx);
        if (this.multiBlock) {
            masm.addq(buf, 64);
            masm.addl(ofs, 64);
            masm.movl(AMD64.rsi, ofs);
            masm.cmpl(AMD64.rsi, limit);
            masm.jcc(AMD64Assembler.ConditionFlag.BelowEqual, loop0);
            masm.movl(AMD64.rax, AMD64.rsi);
        }
    }
}

