/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;

public final class AMD64PrefetchOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64PrefetchOp> TYPE = LIRInstructionClass.create(AMD64PrefetchOp.class);
    private final int instr;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.COMPOSITE})
    protected AMD64AddressValue address;

    public AMD64PrefetchOp(AMD64AddressValue address, int instr) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.address = address;
        this.instr = instr;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        switch (this.instr) {
            case 0: {
                masm.prefetchnta(this.address.toAddress());
                break;
            }
            case 1: {
                masm.prefetcht0(this.address.toAddress());
                break;
            }
            case 2: {
                masm.prefetcht2(this.address.toAddress());
                break;
            }
            case 3: {
                masm.prefetchw(this.address.toAddress());
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("unspported prefetch op " + this.instr);
            }
        }
    }
}

