/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.SyncPorts;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="AMD64_ROUND_FLOAT_TO_INTEGER")
@SyncPorts(value={@SyncPort(from="https://github.com/openjdk/jdk/blob/fbe4cc96e223882a18c7ff666fe6f68b3fa2cfe4/src/hotspot/cpu/x86/macroAssembler_x86.cpp#L10042-L10138", sha1="9e13c7375bbb35809ad79ebd6a9cc19e66f57aa1"), @SyncPort(from="https://github.com/openjdk/jdk/blob/ce8399fd6071766114f5f201b6e44a7abdba9f5a/src/hotspot/cpu/x86/stubGenerator_x86_64.cpp#L598-L765", sha1="312f16a0551887f78cc567638477bbbcbc3765c5")})
public class AMD64RoundFloatToIntegerOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64RoundFloatToIntegerOp> TYPE = LIRInstructionClass.create(AMD64RoundFloatToIntegerOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
    protected AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue input;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue tmp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue rcxTmp;
    private static final int FLOAT_SIGNIFICAND_WIDTH = 24;
    private static final int FLOAT_EXP_BIAS = 127;
    private static final int FLOAT_EXP_BIT_MASK = 2139095040;
    private static final int FLOAT_SIGNIF_BIT_MASK = 0x7FFFFF;
    private static final int FLOAT_SIGN_BIT_MASK = Integer.MIN_VALUE;
    private static final int DOUBLE_SIGNIFICAND_WIDTH = 53;
    private static final int DOUBLE_EXP_BIAS = 1023;
    private static final long DOUBLE_EXP_BIT_MASK = 0x7FF0000000000000L;
    private static final long DOUBLE_SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;
    private static final long DOUBLE_SIGN_BIT_MASK = Long.MIN_VALUE;

    public AMD64RoundFloatToIntegerOp(LIRGeneratorTool tool, AllocatableValue result, AllocatableValue input) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.result = result;
        this.input = input;
        this.tmp = tool.newVariable(result.getValueKind());
        this.rcxTmp = AMD64.rcx.asValue();
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Label labelSpecialCase = new Label();
        Label labelBlock1 = new Label();
        Label labelExit = new Label();
        Register rtmp = ValueUtil.asRegister((Value)this.tmp);
        Register dst = ValueUtil.asRegister((Value)this.result);
        Register src = ValueUtil.asRegister((Value)this.input);
        if (this.input.getPlatformKind() == AMD64Kind.SINGLE) {
            masm.movl(rtmp, 2139095040);
            masm.movdl(dst, src);
            masm.andl(dst, rtmp);
            masm.sarl(dst, 23);
            masm.movl(AMD64.rcx, 149);
            masm.subl(AMD64.rcx, dst);
            masm.testlAndJcc(AMD64.rcx, -32, AMD64Assembler.ConditionFlag.NotEqual, labelSpecialCase, true);
            masm.movdl(dst, src);
            masm.andl(dst, 0x7FFFFF);
            masm.orl(dst, 0x800000);
            masm.movdl(rtmp, src);
            masm.testlAndJcc(rtmp, rtmp, AMD64Assembler.ConditionFlag.GreaterEqual, labelBlock1, true);
            masm.negl(dst);
            masm.bind(labelBlock1);
            masm.sarl(dst);
            masm.addl(dst, 1);
            masm.sarl(dst, 1);
            masm.jmpb(labelExit);
            masm.bind(labelSpecialCase);
            masm.cvttss2sil(dst, src);
            masm.cmplAndJcc(dst, Integer.MIN_VALUE, AMD64Assembler.ConditionFlag.NotEqual, labelExit, true);
            masm.movdl(rtmp, src);
            masm.andl(rtmp, Integer.MAX_VALUE);
            masm.xorl(dst, dst);
            masm.cmplAndJcc(rtmp, 2139095040, AMD64Assembler.ConditionFlag.Greater, labelExit, true);
            masm.movdl(rtmp, src);
            masm.testl(rtmp, rtmp);
            masm.movl(dst, Integer.MIN_VALUE);
            masm.movl(rtmp, Integer.MAX_VALUE);
            masm.cmovl(AMD64Assembler.ConditionFlag.Positive, dst, rtmp);
        } else {
            assert (this.input.getPlatformKind() == AMD64Kind.DOUBLE) : this.input;
            masm.movq(rtmp, 0x7FF0000000000000L);
            masm.movdq(dst, src);
            masm.andq(dst, rtmp);
            masm.sarq(dst, 52);
            masm.movl(AMD64.rcx, 1074);
            masm.subq(AMD64.rcx, dst);
            masm.testAndJcc(AMD64BaseAssembler.OperandSize.QWORD, AMD64.rcx, -64, AMD64Assembler.ConditionFlag.NotEqual, labelSpecialCase, true);
            masm.movdq(dst, src);
            masm.movq(rtmp, 0xFFFFFFFFFFFFFL);
            masm.andq(dst, rtmp);
            masm.movq(rtmp, 0x10000000000000L);
            masm.orq(dst, rtmp);
            masm.movdq(rtmp, src);
            masm.testqAndJcc(rtmp, rtmp, AMD64Assembler.ConditionFlag.GreaterEqual, labelBlock1, true);
            masm.negq(dst);
            masm.bind(labelBlock1);
            masm.sarq(dst);
            masm.incrementq(dst, 1);
            masm.sarq(dst, 1);
            masm.jmp(labelExit);
            masm.bind(labelSpecialCase);
            masm.cvttsd2siq(dst, src);
            masm.movq(rtmp, Long.MIN_VALUE);
            masm.cmpqAndJcc(dst, rtmp, AMD64Assembler.ConditionFlag.NotEqual, labelExit, true);
            masm.movdq(rtmp, src);
            masm.movl(dst, rtmp);
            masm.negl(dst);
            masm.orl(dst, rtmp);
            masm.shrq(rtmp, 32);
            masm.andl(rtmp, Integer.MAX_VALUE);
            masm.shrl(dst, 31);
            masm.orl(rtmp, dst);
            masm.xorl(dst, dst);
            masm.cmplAndJcc(rtmp, 0x7FF00000, AMD64Assembler.ConditionFlag.Greater, labelExit, true);
            masm.movdq(rtmp, src);
            masm.testq(rtmp, rtmp);
            masm.movq(dst, Long.MIN_VALUE);
            masm.movq(rtmp, Long.MAX_VALUE);
            masm.cmovq(AMD64Assembler.ConditionFlag.Positive, dst, rtmp);
        }
        masm.bind(labelExit);
    }
}

