/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64.g1;

import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.AMD64Call;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.amd64.g1.AMD64G1BarrierSetLIRTool;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/c5f1dcccfce7b943c1a91aa65709576038098e91/src/hotspot/cpu/x86/gc/g1/g1BarrierSetAssembler_x86.cpp#L163-L264", sha1="34e794bbd45946013b84c5a4838b5b80d3b8a131")
public class AMD64G1PreWriteBarrierOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64G1PreWriteBarrierOp> TYPE = LIRInstructionClass.create(AMD64G1PreWriteBarrierOp.class);
    @LIRInstruction.Alive
    private Value address;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value expectedObject;
    @LIRInstruction.Temp
    private Value temp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value temp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value temp3;
    private final ForeignCallLinkage callTarget;
    private final boolean nonNull;
    private final AMD64G1BarrierSetLIRTool tool;

    public AMD64G1PreWriteBarrierOp(Value address, Value expectedObject, Value temp, AllocatableValue temp2, AllocatableValue temp3, ForeignCallLinkage callTarget, boolean nonNull, AMD64G1BarrierSetLIRTool tool) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.address = address;
        this.expectedObject = expectedObject;
        this.callTarget = callTarget;
        GraalError.guarantee(expectedObject.equals((Object)Value.ILLEGAL) || expectedObject.getPlatformKind().getSizeInBytes() == 8, "expected uncompressed pointer");
        assert (expectedObject.equals((Object)Value.ILLEGAL) ^ temp2.equals((Object)Value.ILLEGAL)) : "only one register is necessary";
        this.temp = temp;
        this.temp2 = temp2;
        this.temp3 = temp3;
        this.nonNull = nonNull;
        this.tool = tool;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        AMD64Address storeAddress = ((AMD64AddressValue)this.address).toAddress();
        Register thread = this.tool.getThread(masm);
        Register tmp = ValueUtil.asRegister((Value)this.temp);
        Register previousValue = this.expectedObject.equals((Object)Value.ILLEGAL) ? ValueUtil.asRegister((Value)this.temp2) : ValueUtil.asRegister((Value)this.expectedObject);
        Assembler.guaranteeDifferentRegisters(thread, tmp, previousValue);
        Label done = new Label();
        Label runtime = new Label();
        AMD64Address markingActive = new AMD64Address(thread, this.tool.satbQueueMarkingActiveOffset());
        masm.cmpb(markingActive, 0);
        masm.jcc(AMD64Assembler.ConditionFlag.Equal, done);
        if (this.expectedObject.equals((Object)Value.ILLEGAL)) {
            this.tool.loadObject(masm, previousValue, storeAddress);
        }
        if (!this.nonNull) {
            masm.testq(previousValue, previousValue);
            masm.jcc(AMD64Assembler.ConditionFlag.Equal, done);
        }
        if (GraalOptions.VerifyAssemblyGCBarriers.getValue(crb.getOptions()).booleanValue()) {
            this.tool.verifyOop(masm, previousValue, tmp, ValueUtil.asRegister((Value)this.temp3), false, true);
        }
        if (GraalOptions.AssemblyGCBarriersSlowPathOnly.getValue(crb.getOptions()).booleanValue()) {
            masm.jmp(runtime);
        } else {
            AMD64Address satbQueueIndex = new AMD64Address(thread, this.tool.satbQueueIndexOffset());
            masm.movq(tmp, satbQueueIndex);
            masm.cmpq(tmp, 0);
            masm.jcc(AMD64Assembler.ConditionFlag.Equal, runtime);
            masm.subq(tmp, 8);
            masm.movptr(satbQueueIndex, tmp);
            AMD64Address satbQueueBuffer = new AMD64Address(thread, this.tool.satbQueueBufferOffset());
            masm.addq(tmp, satbQueueBuffer);
            masm.movptr(new AMD64Address(tmp, 0), previousValue);
        }
        masm.bind(done);
        crb.getLIR().addSlowPath(this, () -> {
            masm.bind(runtime);
            CallingConvention cc = this.callTarget.getOutgoingCallingConvention();
            AllocatableValue arg0 = cc.getArgument(0);
            if (arg0 instanceof StackSlot) {
                AMD64Address slot0 = (AMD64Address)crb.asAddress((Value)arg0);
                masm.movq(slot0, previousValue);
            } else {
                GraalError.shouldNotReachHere("must be StackSlot: " + String.valueOf(arg0));
            }
            AMD64Call.directCall(crb, masm, this.tool.getCallTarget(this.callTarget), null, false, null);
            masm.jmp(done);
        });
    }
}

