/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64.phases;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.LIRPhase;
import jdk.graal.compiler.lir.phases.PostAllocationOptimizationPhase;
import jdk.graal.compiler.options.NestedBooleanOptionKey;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public class StackMoveOptimizationPhase
extends PostAllocationOptimizationPhase {
    private static final CounterKey eliminatedBackup = DebugContext.counter("StackMoveOptimizer[EliminatedScratchBackupRestore]");

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        LIR lir = lirGenRes.getLIR();
        DebugContext debug = lir.getDebug();
        for (BasicBlock block : lir.getControlFlowGraph().getBlocks()) {
            ArrayList<LIRInstruction> instructions = lir.getLIRforBlock(block);
            new Closure().process(debug, instructions);
        }
    }

    private static AMD64Move.AMD64StackMove asStackMove(LIRInstruction inst) {
        assert (StackMoveOptimizationPhase.isStackMove(inst));
        return (AMD64Move.AMD64StackMove)inst;
    }

    private static boolean isStackMove(LIRInstruction inst) {
        return inst instanceof AMD64Move.AMD64StackMove;
    }

    private static class Closure {
        private static final int NONE = -1;
        private int begin = -1;
        private Register reg = null;
        private List<AllocatableValue> dst;
        private List<Value> src;
        private AllocatableValue slot;
        private boolean removed = false;

        private Closure() {
        }

        public void process(DebugContext debug, List<LIRInstruction> instructions) {
            for (int i = 0; i < instructions.size(); ++i) {
                LIRInstruction inst = instructions.get(i);
                if (StackMoveOptimizationPhase.isStackMove(inst)) {
                    AMD64Move.AMD64StackMove move = StackMoveOptimizationPhase.asStackMove(inst);
                    if (this.reg != null && !this.reg.equals((Object)move.getScratchRegister()) || this.dst != null && this.dst.contains(move.getInput())) {
                        this.replaceStackMoves(debug, instructions);
                    }
                    if (this.dst == null) {
                        assert (this.src == null);
                        this.dst = new ArrayList<AllocatableValue>();
                        this.src = new ArrayList<Value>();
                    }
                    this.dst.add(move.getResult());
                    this.src.add((Value)move.getInput());
                    if (this.begin != -1) continue;
                    this.begin = i;
                    this.reg = move.getScratchRegister();
                    this.slot = move.getBackupSlot();
                    continue;
                }
                if (this.begin == -1) continue;
                this.replaceStackMoves(debug, instructions);
            }
            if (this.removed) {
                instructions.removeAll(Collections.singleton(null));
            }
        }

        private void replaceStackMoves(DebugContext debug, List<LIRInstruction> instructions) {
            int size = this.dst.size();
            if (size > 1) {
                AMD64Move.AMD64MultiStackMove multiMove = new AMD64Move.AMD64MultiStackMove(this.dst.toArray(new AllocatableValue[size]), (Value[])this.src.toArray(new AllocatableValue[size]), this.reg, this.slot);
                instructions.set(this.begin, multiMove);
                Collections.fill(instructions.subList(this.begin + 1, this.begin + size), null);
                this.removed = true;
                eliminatedBackup.add(debug, size - 1);
            }
            this.dst.clear();
            this.src.clear();
            this.begin = -1;
            this.reg = null;
            this.slot = null;
        }
    }

    public static class Options {
        public static final NestedBooleanOptionKey LIROptStackMoveOptimizer = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
    }
}

