/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.constopt;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.lir.CastValue;
import jdk.graal.compiler.lir.InstructionValueConsumer;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInsertionBuffer;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.ValueConsumer;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.constopt.ConstantTree;
import jdk.graal.compiler.lir.constopt.ConstantTreeAnalyzer;
import jdk.graal.compiler.lir.constopt.DefUseTree;
import jdk.graal.compiler.lir.constopt.UseEntry;
import jdk.graal.compiler.lir.constopt.VariableMap;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.lir.phases.LIRPhase;
import jdk.graal.compiler.lir.phases.PreAllocationOptimizationPhase;
import jdk.graal.compiler.options.NestedBooleanOptionKey;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public final class ConstantLoadOptimization
extends PreAllocationOptimizationPhase {
    private static final CounterKey constantsTotal = DebugContext.counter("ConstantLoadOptimization[total]");
    private static final CounterKey phiConstantsSkipped = DebugContext.counter("ConstantLoadOptimization[PhisSkipped]");
    private static final CounterKey singleUsageConstantsSkipped = DebugContext.counter("ConstantLoadOptimization[SingleUsageSkipped]");
    private static final CounterKey usageAtDefinitionSkipped = DebugContext.counter("ConstantLoadOptimization[UsageAtDefinitionSkipped]");
    private static final CounterKey basePointerUsagesSkipped = DebugContext.counter("ConstantLoadOptimization[BasePointerUsagesSkipped]");
    private static final CounterKey materializeAtDefinitionSkipped = DebugContext.counter("ConstantLoadOptimization[MaterializeAtDefinitionSkipped]");
    private static final CounterKey constantsOptimized = DebugContext.counter("ConstantLoadOptimization[optimized]");

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PreAllocationOptimizationPhase.PreAllocationOptimizationContext context) {
        LIRGeneratorTool lirGen = context.lirGen;
        new Optimization(lirGenRes.getLIR(), lirGen).apply();
    }

    private static final class Optimization {
        private final LIR lir;
        private final LIRGeneratorTool lirGen;
        private final VariableMap<DefUseTree> map;
        private final BitSet phiConstants;
        private final BitSet defined;
        private final BlockMap<List<UseEntry>> blockMap;
        private final BlockMap<LIRInsertionBuffer> insertionBuffers;
        private final DebugContext debug;

        private Optimization(LIR lir, LIRGeneratorTool lirGen) {
            this.lir = lir;
            this.debug = lir.getDebug();
            this.lirGen = lirGen;
            this.map = new VariableMap();
            this.phiConstants = new BitSet();
            this.defined = new BitSet();
            this.insertionBuffers = new BlockMap(lir.getControlFlowGraph());
            this.blockMap = new BlockMap(lir.getControlFlowGraph());
        }

        private void apply() {
            try (Indent indent = this.debug.logAndIndent("ConstantLoadOptimization");){
                DebugContext.Scope s;
                try {
                    s = this.debug.scope("BuildDefUseTree");
                    try {
                        for (BasicBlock b : this.lir.getControlFlowGraph().getBlocks()) {
                            this.analyzeBlock(b);
                        }
                        this.map.filter(t -> {
                            if (t.usageCount() > 1) {
                                return true;
                            }
                            singleUsageConstantsSkipped.increment(this.debug);
                            return false;
                        });
                        this.map.forEach(tree -> tree.forEach(this::addUsageToBlockMap));
                    }
                    finally {
                        if (s != null) {
                            s.close();
                        }
                    }
                }
                catch (Throwable e) {
                    throw this.debug.handle(e);
                }
                try {
                    s = this.debug.scope("BuildConstantTree");
                    try {
                        this.map.forEach(this::createConstantTree);
                        for (BasicBlock b : this.lir.getControlFlowGraph().getBlocks()) {
                            this.rewriteBlock(b);
                        }
                        assert (this.verifyStates());
                    }
                    finally {
                        if (s != null) {
                            s.close();
                        }
                    }
                }
                catch (Throwable e) {
                    throw this.debug.handle(e);
                }
            }
        }

        private boolean verifyStates() {
            this.map.forEach(this::verifyStateUsage);
            return true;
        }

        private void verifyStateUsage(DefUseTree tree) {
            final Variable var = tree.getVariable();
            ValueConsumer stateConsumer = new ValueConsumer(){

                @Override
                public void visitValue(Value operand, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
                    if (operand.getPlatformKind().getVectorLength() == 1) assert (!operand.equals((Object)var)) : "constant usage through variable in frame state " + String.valueOf((Object)var);
                }
            };
            for (BasicBlock block : this.lir.getControlFlowGraph().getBlocks()) {
                for (LIRInstruction inst : this.lir.getLIRforBlock(block)) {
                    inst.visitEachState(stateConsumer);
                }
            }
        }

        private static boolean isConstantLoad(LIRInstruction inst) {
            if (!StandardOp.LoadConstantOp.isLoadConstantOp(inst)) {
                return false;
            }
            return LIRValueUtil.isVariable((Value)StandardOp.LoadConstantOp.asLoadConstantOp(inst).getResult());
        }

        private void addUsageToBlockMap(UseEntry entry) {
            BasicBlock<?> block = entry.getBlock();
            List<UseEntry> list = this.blockMap.get(block);
            if (list == null) {
                list = new ArrayList<UseEntry>();
                this.blockMap.put(block, list);
            }
            list.add(entry);
        }

        private void analyzeBlock(BasicBlock<?> block) {
            try (Indent indent = this.debug.logAndIndent("Block: %s", block);){
                InstructionValueConsumer loadConsumer = (instruction, value, mode, flags) -> {
                    if (LIRValueUtil.isVariable(value)) {
                        Variable var = LIRValueUtil.asVariable(value);
                        AllocatableValue base = Optimization.getBasePointer((Value)var);
                        if (base != null && LIRValueUtil.isVariable((Value)base) && this.map.remove(LIRValueUtil.asVariable((Value)base)) != null) {
                            this.map.remove(var);
                            basePointerUsagesSkipped.increment(this.debug);
                            this.debug.log("skip optimizing %s because it is used as base pointer", base);
                        }
                        if (!this.phiConstants.get(var.index)) {
                            if (!this.defined.get(var.index)) {
                                this.defined.set(var.index);
                                if (Optimization.isConstantLoad(instruction)) {
                                    this.debug.log("constant load: %s", instruction);
                                    this.map.put(var, new DefUseTree(instruction, block));
                                    constantsTotal.increment(this.debug);
                                }
                            } else {
                                DefUseTree removed = this.map.remove(var);
                                if (removed != null) {
                                    phiConstantsSkipped.increment(this.debug);
                                }
                                this.phiConstants.set(var.index);
                                this.debug.log(3, "Removing phi variable: %s", (Object)var);
                            }
                        } else assert (this.defined.get(var.index)) : "phi but not defined? " + String.valueOf((Object)var);
                    }
                };
                InstructionValueConsumer useConsumer = (instruction, value, mode, flags) -> {
                    if (LIRValueUtil.isVariable(value)) {
                        DefUseTree tree;
                        Variable var = LIRValueUtil.asVariable(value);
                        if (!this.phiConstants.get(var.index) && (tree = this.map.get(var)) != null) {
                            tree.addUsage(block, instruction, value);
                            this.debug.log("usage of %s : %s", (Object)var, (Object)instruction);
                        }
                    }
                };
                InstructionValueConsumer stateVectorUseConsumer = (instruction, value, mode, flags) -> {
                    if (value.getPlatformKind().getVectorLength() > 1) {
                        useConsumer.visitValue(instruction, value, mode, flags);
                    }
                };
                int opId = 0;
                for (LIRInstruction inst : this.lir.getLIRforBlock(block)) {
                    inst.setId(opId++);
                    inst.visitEachOutput(loadConsumer);
                    inst.visitEachInput(useConsumer);
                    inst.visitEachAlive(useConsumer);
                    inst.visitEachState(stateVectorUseConsumer);
                }
            }
        }

        private static AllocatableValue getBasePointer(Value value) {
            ValueKind kind = value.getValueKind();
            if (kind instanceof LIRKind) {
                return ((LIRKind)kind).getDerivedReferenceBase();
            }
            return null;
        }

        private void createConstantTree(DefUseTree tree) {
            ConstantTree constTree;
            block25: {
                constTree = new ConstantTree(this.lir.getControlFlowGraph(), tree);
                constTree.set(ConstantTree.Flags.SUBTREE, tree.getBlock());
                tree.forEach(u -> constTree.set(ConstantTree.Flags.USAGE, u.getBlock()));
                if (constTree.get(ConstantTree.Flags.USAGE, tree.getBlock())) {
                    usageAtDefinitionSkipped.increment(this.debug);
                    return;
                }
                constTree.markBlocks();
                ConstantTree.NodeCost cost = ConstantTreeAnalyzer.analyze(this.debug, constTree, tree.getBlock());
                int usageCount = cost.getUsages().size();
                assert (usageCount == tree.usageCount()) : "Usage count differs: " + usageCount + " vs. " + tree.usageCount();
                if (this.debug.isLogEnabled()) {
                    try (Indent i = this.debug.logAndIndent("Variable: %s, Block: %s, freq.: %f", (Object)tree.getVariable(), tree.getBlock(), (Object)tree.getBlock().getRelativeFrequency());){
                        this.debug.log("Usages result: %s", cost);
                    }
                }
                if (cost.getNumMaterializations() > 1 || cost.getBestCost() < tree.getBlock().getRelativeFrequency()) {
                    try (DebugContext.Scope s = this.debug.scope((Object)"CLOmodify", constTree);
                         Indent i = this.debug.isLogEnabled() ? this.debug.logAndIndent("Replacing %s = %s", (Object)tree.getVariable(), (Object)tree.getConstant().toValueString()) : null;){
                        this.deleteInstruction(tree);
                        constantsOptimized.increment(this.debug);
                        this.createLoads(tree, constTree, tree.getBlock());
                        break block25;
                    }
                    catch (Throwable e) {
                        throw this.debug.handle(e);
                    }
                }
                materializeAtDefinitionSkipped.increment(this.debug);
            }
            this.debug.dump(4, (Object)constTree, "ConstantTree for %s", (Object)tree.getVariable());
        }

        private void createLoads(DefUseTree tree, ConstantTree constTree, BasicBlock<?> startBlock) {
            ArrayDeque<BasicBlock<Object>> worklist = new ArrayDeque<BasicBlock<Object>>();
            worklist.add(startBlock);
            while (!worklist.isEmpty()) {
                BasicBlock block = (BasicBlock)worklist.pollLast();
                if (constTree.get(ConstantTree.Flags.CANDIDATE, block)) {
                    constTree.set(ConstantTree.Flags.MATERIALIZE, block);
                    this.insertLoad(tree.getConstant(), tree.getVariable().getValueKind(), block, ((ConstantTree.NodeCost)constTree.getCost(block)).getUsages());
                    continue;
                }
                for (Object dominated = block.getFirstDominated(); dominated != null; dominated = ((BasicBlock)dominated).getDominatedSibling()) {
                    if (!constTree.isMarked((BasicBlock<?>)dominated)) continue;
                    worklist.addLast((BasicBlock<Object>)dominated);
                }
            }
        }

        private void insertLoad(Constant constant, ValueKind<?> kind, BasicBlock<?> block, List<UseEntry> usages) {
            assert (usages != null && usages.size() > 0) : String.format("No usages %s %s %s", constant, block, usages);
            Variable variable = this.lirGen.newVariable(kind);
            LIRInstruction move = this.lirGen.getSpillMoveFactory().createLoad(variable, constant);
            int insertionIndex = this.lirGen.getResult().getFirstInsertPosition();
            this.getInsertionBuffer(block).append(insertionIndex, move);
            this.debug.log("new move (%s) and inserted in block %s", (Object)move, block);
            for (UseEntry u : usages) {
                AllocatableValue newValue;
                if (u.getValue() instanceof CastValue) {
                    ValueKind castKind = variable.getValueKind().changeType(u.getValue().getPlatformKind());
                    newValue = new CastValue(castKind, variable);
                } else {
                    newValue = variable;
                }
                u.setValue((Value)newValue);
                this.debug.log("patched instruction %s", u.getInstruction());
            }
        }

        private void rewriteBlock(BasicBlock<?> block) {
            LIRInsertionBuffer buffer = this.insertionBuffers.get(block);
            if (buffer != null) {
                assert (buffer.initialized()) : "not initialized?";
                buffer.finish();
            }
            ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
            boolean hasDead = false;
            for (LIRInstruction inst : instructions) {
                if (inst == null) {
                    hasDead = true;
                    continue;
                }
                inst.setId(-1);
            }
            if (hasDead) {
                instructions.removeAll(Collections.singleton(null));
            }
        }

        private void deleteInstruction(DefUseTree tree) {
            BasicBlock<?> block = tree.getBlock();
            LIRInstruction instruction = tree.getInstruction();
            this.debug.log("deleting instruction %s from block %s", (Object)instruction, block);
            this.lir.getLIRforBlock(block).set(instruction.id(), null);
        }

        private LIRInsertionBuffer getInsertionBuffer(BasicBlock<?> block) {
            LIRInsertionBuffer insertionBuffer = this.insertionBuffers.get(block);
            if (insertionBuffer == null) {
                insertionBuffer = new LIRInsertionBuffer();
                this.insertionBuffers.put(block, insertionBuffer);
                assert (!insertionBuffer.initialized()) : "already initialized?";
                ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
                insertionBuffer.init(instructions);
            }
            return insertionBuffer;
        }
    }

    public static class Options {
        public static final NestedBooleanOptionKey LIROptConstantLoadOptimization = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
    }
}

