/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.dfa;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collection;
import jdk.graal.compiler.core.common.cfg.BasicBlock;

class UniqueWorkList
extends ArrayDeque<BasicBlock<?>> {
    private static final long serialVersionUID = 8009554570990975712L;
    BitSet valid;

    UniqueWorkList(int size) {
        this.valid = new BitSet(size);
    }

    @Override
    public BasicBlock<?> poll() {
        BasicBlock result = (BasicBlock)super.poll();
        if (result != null) {
            this.valid.set(result.getId(), false);
        }
        return result;
    }

    @Override
    public boolean add(BasicBlock<?> pred) {
        if (!this.valid.get(pred.getId())) {
            this.valid.set(pred.getId(), true);
            return super.add(pred);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends BasicBlock<?>> collection) {
        boolean changed = false;
        for (BasicBlock<?> element : collection) {
            if (this.valid.get(element.getId())) continue;
            this.valid.set(element.getId(), true);
            super.add(element);
            changed = true;
        }
        return changed;
    }
}

