/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.gen;

import java.util.EnumSet;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.gen.MoveFactory;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;

public final class VerifyingMoveFactory
extends MoveFactory {
    private final MoveFactory inner;

    public VerifyingMoveFactory(MoveFactory inner) {
        this.inner = inner;
    }

    @Override
    public boolean canInlineConstant(Constant c) {
        return this.inner.canInlineConstant(c);
    }

    @Override
    public boolean allowConstantToStackMove(Constant constant) {
        return this.inner.allowConstantToStackMove(constant);
    }

    @Override
    public LIRInstruction createMove(AllocatableValue result, Value input) {
        LIRInstruction inst = this.inner.createMove(result, input);
        assert (VerifyingMoveFactory.checkResult(inst, result, input));
        return inst;
    }

    @Override
    public LIRInstruction createStackMove(AllocatableValue result, AllocatableValue input) {
        LIRInstruction inst = this.inner.createStackMove(result, input);
        assert (VerifyingMoveFactory.checkResult(inst, result, (Value)input));
        return inst;
    }

    @Override
    public LIRInstruction createLoad(AllocatableValue result, Constant input) {
        LIRInstruction inst = this.inner.createLoad(result, input);
        assert (StandardOp.LoadConstantOp.isLoadConstantOp(inst) && VerifyingMoveFactory.checkResult(inst, result, null)) : Assertions.errorMessage(inst, result);
        return inst;
    }

    @Override
    public LIRInstruction createStackLoad(AllocatableValue result, Constant input) {
        LIRInstruction inst = this.inner.createStackLoad(result, input);
        assert (StandardOp.LoadConstantOp.isLoadConstantOp(inst) && VerifyingMoveFactory.checkResult(inst, result, null)) : Assertions.errorMessage(inst, result);
        return inst;
    }

    private static boolean checkResult(LIRInstruction inst, AllocatableValue result, Value input) {
        CheckClosure c = new CheckClosure(result, input);
        inst.visitEachInput(c::inputProc);
        inst.visitEachOutput(c::outputProc);
        inst.visitEachAlive(c::aliveProc);
        inst.visitEachTemp(c::tempProc);
        inst.visitEachState(c::stateProc);
        assert (c.outputCount >= 1) : "no output produced" + String.valueOf(inst);
        assert (c.stateCount == 0) : "SpillMoveFactory: instruction must not have a state: " + String.valueOf(inst);
        return true;
    }

    private static class CheckClosure {
        private final AllocatableValue result;
        private final Value input;
        private int tempCount = 0;
        private int aliveCount = 0;
        private int stateCount = 0;
        private int inputCount = 0;
        private int outputCount = 0;

        CheckClosure(AllocatableValue result, Value input) {
            this.result = result;
            this.input = input;
        }

        void tempProc(LIRInstruction op, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            assert (false) : String.format("SpillMoveFactory: Instruction %s is not allowed to contain operand %s of mode %s", new Object[]{op, value, mode});
            ++this.tempCount;
        }

        void stateProc(LIRInstruction op, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            assert (false) : String.format("SpillMoveFactory: Instruction %s is not allowed to contain operand %s of mode %s", new Object[]{op, value, mode});
            ++this.stateCount;
        }

        void aliveProc(LIRInstruction op, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            assert (!LIRValueUtil.isVariable(value) && flags.contains((Object)LIRInstruction.OperandFlag.UNINITIALIZED)) : String.format("SpillMoveFactory: Instruction %s is not allowed to contain operand %s of mode %s", new Object[]{op, value, mode});
            ++this.aliveCount;
        }

        void inputProc(LIRInstruction op, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            assert (value.equals((Object)this.input) || LIRValueUtil.isJavaConstant(value)) : String.format("SpillMoveFactory: Instruction %s can only have %s as input, got %s", op, this.input, value);
            ++this.inputCount;
        }

        void outputProc(LIRInstruction op, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            assert (value.equals((Object)this.result)) : String.format("SpillMoveFactory: Instruction %s can only have %s as input, got %s", op, this.input, value);
            ++this.outputCount;
        }
    }
}

