/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.profiling;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.lir.ConstantValue;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInsertionBuffer;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.gen.DiagnosticLIRGeneratorTool;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.PostAllocationOptimizationPhase;
import jdk.graal.compiler.lir.profiling.MoveProfiler;
import jdk.graal.compiler.lir.profiling.MoveType;
import jdk.graal.compiler.options.OptionKey;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;

public class MoveProfilingPhase
extends PostAllocationOptimizationPhase {
    private static final String MOVE_OPERATIONS = "MoveOperations";

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        new Analyzer(target, lirGenRes, context.diagnosticLirGenTool).run();
    }

    static class Analyzer {
        private final TargetDescription target;
        private final LIRGenerationResult lirGenRes;
        private final DiagnosticLIRGeneratorTool diagnosticLirGenTool;
        private final LIRInsertionBuffer buffer;
        private String cachedGroupName;
        private final List<String> names;
        private final List<String> groups;
        private final List<Value> increments;

        Analyzer(TargetDescription target, LIRGenerationResult lirGenRes, DiagnosticLIRGeneratorTool diagnosticLirGenTool) {
            this.target = target;
            this.lirGenRes = lirGenRes;
            this.diagnosticLirGenTool = diagnosticLirGenTool;
            this.buffer = new LIRInsertionBuffer();
            this.names = new ArrayList<String>();
            this.groups = new ArrayList<String>();
            this.increments = new ArrayList<Value>();
        }

        public void run() {
            LIR lir = this.lirGenRes.getLIR();
            BlockMap<MoveProfiler.MoveStatistics> collected = MoveProfiler.profile(lir);
            for (BasicBlock block : lir.getControlFlowGraph().getBlocks()) {
                MoveProfiler.MoveStatistics moveStatistics = collected.get(block);
                if (moveStatistics == null) continue;
                this.names.clear();
                this.groups.clear();
                this.increments.clear();
                this.doBlock(block, moveStatistics);
            }
        }

        public void doBlock(BasicBlock<?> block, MoveProfiler.MoveStatistics moveStatistics) {
            for (MoveType type : MoveType.values()) {
                String name = type.toString();
                this.addEntry(name, this.getGroupName(), moveStatistics.get(type));
            }
            this.insertBenchmarkCounter(block);
        }

        protected final void addEntry(String name, String groupName, int count) {
            if (count > 0) {
                this.names.add(name);
                this.groups.add(groupName);
                this.increments.add(new ConstantValue(LIRKind.fromJavaKind(this.target.arch, JavaKind.Int), (Constant)JavaConstant.forInt((int)count)));
            }
        }

        protected final void insertBenchmarkCounter(BasicBlock<?> block) {
            int size = this.names.size();
            if (size > 0) {
                assert (NumUtil.assertPositiveInt(size));
                assert (size == this.groups.size()) : Assertions.errorMessageContext("size", size, "groups", this.groups);
                assert (size == this.increments.size()) : Assertions.errorMessageContext("size", size, "increments", this.increments);
                ArrayList<LIRInstruction> instructions = this.lirGenRes.getLIR().getLIRforBlock(block);
                LIRInstruction inst = this.diagnosticLirGenTool.createMultiBenchmarkCounter(this.names.toArray(new String[size]), this.groups.toArray(new String[size]), this.increments.toArray(new Value[size]));
                assert (inst != null);
                this.buffer.init(instructions);
                int insertionIndex = this.lirGenRes.getFirstInsertPosition();
                this.buffer.append(insertionIndex, inst);
                this.buffer.finish();
            }
        }

        protected final String getGroupName() {
            if (this.cachedGroupName == null) {
                this.cachedGroupName = this.createGroupName();
            }
            return this.cachedGroupName;
        }

        protected String createGroupName() {
            if (Options.LIRDynMoveProfileMethod.getValue(this.lirGenRes.getLIR().getOptions()).booleanValue()) {
                return "\"" + MoveProfilingPhase.MOVE_OPERATIONS + ':' + this.lirGenRes.getCompilationUnitName() + '\"';
            }
            return MoveProfilingPhase.MOVE_OPERATIONS;
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> LIRDynMoveProfileMethod = new OptionKey<Boolean>(false);
    }
}

