/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.profiling;

import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.StandardOp;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

final class MoveType
extends Enum<MoveType> {
    public static final /* enum */ MoveType REG2REG = new MoveType("Reg", "Reg");
    public static final /* enum */ MoveType STACK2REG = new MoveType("Reg", "Stack");
    public static final /* enum */ MoveType CONST2REG = new MoveType("Reg", "Const");
    public static final /* enum */ MoveType REG2STACK = new MoveType("Stack", "Reg");
    public static final /* enum */ MoveType CONST2STACK = new MoveType("Stack", "Const");
    public static final /* enum */ MoveType STACK2STACK = new MoveType("Stack", "Stack");
    private final String name;
    private static final /* synthetic */ MoveType[] $VALUES;

    public static MoveType[] values() {
        return (MoveType[])$VALUES.clone();
    }

    public static MoveType valueOf(String name) {
        return Enum.valueOf(MoveType.class, name);
    }

    private MoveType(String dst, String src) {
        this.name = src + "2" + dst;
    }

    public String toString() {
        return this.name;
    }

    public static MoveType get(LIRInstruction inst) {
        assert (StandardOp.MoveOp.isMoveOp(inst));
        AllocatableValue dst = StandardOp.MoveOp.asMoveOp(inst).getResult();
        AllocatableValue src = null;
        if (StandardOp.LoadConstantOp.isLoadConstantOp(inst)) {
            if (ValueUtil.isRegister((Value)dst)) {
                return CONST2REG;
            }
            if (ValueUtil.isStackSlot((Value)dst)) {
                return CONST2STACK;
            }
        } else if (StandardOp.ValueMoveOp.isValueMoveOp(inst)) {
            src = StandardOp.ValueMoveOp.asValueMoveOp(inst).getInput();
            if (ValueUtil.isRegister((Value)dst)) {
                if (ValueUtil.isRegister((Value)src)) {
                    return REG2REG;
                }
                if (ValueUtil.isStackSlot((Value)src)) {
                    return STACK2REG;
                }
            } else if (ValueUtil.isStackSlot((Value)dst)) {
                if (ValueUtil.isRegister((Value)src)) {
                    return REG2STACK;
                }
                if (ValueUtil.isStackSlot((Value)src)) {
                    return STACK2STACK;
                }
            }
        }
        throw GraalError.shouldNotReachHere(String.format("Unrecognized Move: %s dst=%s, src=%s", inst, dst, src));
    }

    private static /* synthetic */ MoveType[] $values() {
        return new MoveType[]{REG2REG, STACK2REG, CONST2REG, REG2STACK, CONST2STACK, STACK2STACK};
    }

    static {
        $VALUES = MoveType.$values();
    }
}

