/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.stackslotalloc;

import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.lir.debug.IntervalDumper;
import jdk.graal.compiler.lir.stackslotalloc.StackInterval;
import jdk.vm.ci.meta.Value;

class StackIntervalDumper
implements IntervalDumper {
    private final StackInterval[] intervals;

    StackIntervalDumper(StackInterval[] intervals) {
        this.intervals = intervals;
    }

    @Override
    public void visitIntervals(IntervalDumper.IntervalVisitor visitor) {
        for (StackInterval interval : this.intervals) {
            if (interval == null) continue;
            StackIntervalDumper.printInterval(interval, visitor);
        }
    }

    private static void printInterval(StackInterval interval, IntervalDumper.IntervalVisitor visitor) {
        VirtualStackSlot hint = interval.locationHint() != null ? interval.locationHint().getOperand() : null;
        VirtualStackSlot operand = interval.getOperand();
        String type = operand.getValueKind().getPlatformKind().toString();
        visitor.visitIntervalStart((Value)operand, (Value)operand, (Value)interval.location(), (Value)hint, type);
        visitor.visitRange(interval.from(), interval.to());
        visitor.visitIntervalEnd("NOT_SUPPORTED");
    }
}

