/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.loop.phases;

import java.util.Optional;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.cfg.AbstractControlFlowGraph;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.GuardedValueNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.IntegerBelowNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.AnchoringNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.MultiGuardNode;
import jdk.graal.compiler.nodes.loop.CountedLoopInfo;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.LoopEx;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.loop.MathUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.Speculative;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.PostRunCanonicalizationPhase;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.graal.compiler.serviceprovider.SpeculationReasonGroup;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicMap;

public class LoopPredicationPhase
extends PostRunCanonicalizationPhase<MidTierContext>
implements Speculative {
    private static final SpeculationReasonGroup LOOP_PREDICATION = new SpeculationReasonGroup("Loop Predication", BytecodePosition.class);

    public LoopPredicationPhase(CanonicalizerPhase canonicalizer) {
        super(canonicalizer);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.withoutSpeculationLog(this, graphState), BasePhase.NotApplicable.when(!graphState.getGuardsStage().allowsFloatingGuards(), "Floating guards must be allowed."));
    }

    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        DebugContext debug = graph.getDebug();
        SpeculationLog speculationLog = graph.getSpeculationLog();
        if (graph.hasLoops() && context.getOptimisticOptimizations().useLoopLimitChecks(graph.getOptions())) {
            LoopsData data = context.getLoopsDataProvider().getLoopsData(graph);
            ControlFlowGraph cfg = data.getCFG();
            try (DebugContext.Scope s = debug.scope((Object)"predication", cfg);){
                for (LoopEx loop : data.loops()) {
                    if (!loop.loop().getChildren().isEmpty() || !loop.detectCounted()) continue;
                    FrameState state = loop.loopBegin().stateAfter();
                    BytecodePosition pos = new BytecodePosition(null, state.getMethod(), state.bci);
                    SpeculationLog.SpeculationReason reason = LOOP_PREDICATION.createSpeculationReason(pos);
                    if (!speculationLog.maySpeculate(reason)) continue;
                    CountedLoopInfo counted = loop.counted();
                    InductionVariable counter = counted.getLimitCheckedIV();
                    Condition condition = ((CompareNode)counted.getLimitTest().condition()).condition().asCondition();
                    boolean inverted = loop.counted().isInverted();
                    if (((IntegerStamp)counter.valueNode().stamp(NodeView.DEFAULT)).getBits() != 32 || counted.isUnsignedCheck() || (condition == Condition.NE || condition == Condition.EQ) && (!counter.isConstantStride() || !LoopEx.absStrideIsOne(counter)) || !loop.loopBegin().isMainLoop() && !loop.loopBegin().isSimpleLoop()) continue;
                    NodeIterable<GuardNode> guards = loop.whole().nodes().filter(GuardNode.class);
                    if (GraalOptions.LoopPredicationMainPath.getValue(graph.getOptions()).booleanValue()) {
                        NodeIterable<LoopEndNode> loopEndNodes = loop.loopBegin().loopEnds();
                        HIRBlock end = data.getCFG().commonDominatorFor(loopEndNodes);
                        guards = guards.filter(guard -> {
                            ValueNode anchor = ((GuardNode)guard).getAnchor().asNode();
                            HIRBlock anchorBlock = data.getCFG().getNodeToBlock().get(anchor);
                            return AbstractControlFlowGraph.dominates(anchorBlock, end);
                        });
                    }
                    AbstractBeginNode body = loop.counted().getBody();
                    HIRBlock bodyBlock = cfg.getNodeToBlock().get(body);
                    for (GuardNode guard2 : guards) {
                        AnchoringNode anchor = guard2.getAnchor();
                        HIRBlock anchorBlock = cfg.getNodeToBlock().get(anchor.asNode());
                        if (!inverted && !AbstractControlFlowGraph.dominates(bodyBlock, anchorBlock)) continue;
                        LoopPredicationPhase.processGuard(loop, guard2);
                    }
                }
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
    }

    private static void processGuard(LoopEx loop, GuardNode guard) {
        ValueNode x;
        LogicNode condition = guard.getCondition();
        if (!(condition instanceof IntegerBelowNode) || guard.isNegated()) {
            return;
        }
        IntegerBelowNode rangeCheck = (IntegerBelowNode)condition;
        ValueNode range = rangeCheck.getY();
        if (!loop.isOutsideLoop(range) || ((IntegerStamp)range.stamp(NodeView.DEFAULT)).lowerBound() < 0L) {
            return;
        }
        EconomicMap<Node, InductionVariable> inductionVariables = loop.getInductionVariables();
        if (!inductionVariables.containsKey((Object)(x = rangeCheck.getX()))) {
            return;
        }
        StructuredGraph graph = guard.graph();
        InductionVariable iv = (InductionVariable)inductionVariables.get((Object)x);
        Long scale = null;
        InductionVariable counter = loop.counted().getLimitCheckedIV();
        if (iv.isConstantScale(counter)) {
            scale = iv.constantScale(counter);
        }
        ValueNode offset = null;
        offset = iv.offsetIsZero(counter) ? (ValueNode)graph.unique(ConstantNode.forInt(0)) : iv.offsetNode(counter);
        if (offset == null || scale == null || !loop.isOutsideLoop(offset)) {
            return;
        }
        long scaleCon = scale;
        LoopPredicationPhase.replaceGuardNode(loop, guard, range, graph, scaleCon, offset);
    }

    private static void replaceGuardNode(LoopEx loop, GuardNode guard, ValueNode range, StructuredGraph graph, long scaleCon, ValueNode offset) {
        InductionVariable counter = loop.counted().getLimitCheckedIV();
        ValueNode rangeLong = IntegerConvertNode.convert(range, (Stamp)IntegerStamp.create(64), graph, NodeView.DEFAULT);
        GuardingNode overFlowGuard = loop.counted().createOverFlowGuard();
        ValueNode extremumNode = counter.extremumNode(false, IntegerStamp.create(64));
        assert (overFlowGuard != null || loop.counted().counterNeverOverflows());
        if (overFlowGuard != null) {
            extremumNode = graph.unique(new GuardedValueNode(extremumNode, overFlowGuard));
        }
        ValueNode upperNode = MathUtil.add(graph, MathUtil.mul(graph, extremumNode, ConstantNode.forLong(scaleCon, graph)), IntegerConvertNode.convert(offset, (Stamp)IntegerStamp.create(64), graph, NodeView.DEFAULT));
        LogicNode upperCond = IntegerBelowNode.create(upperNode, rangeLong, NodeView.DEFAULT);
        ValueNode initNode = IntegerConvertNode.convert(loop.counted().getBodyIVStart(), (Stamp)IntegerStamp.create(64), graph, NodeView.DEFAULT);
        ValueNode lowerNode = MathUtil.add(graph, MathUtil.mul(graph, initNode, ConstantNode.forLong(scaleCon, graph)), IntegerConvertNode.convert(offset, (Stamp)IntegerStamp.create(64), graph, NodeView.DEFAULT));
        LogicNode lowerCond = IntegerBelowNode.create(lowerNode, rangeLong, NodeView.DEFAULT);
        FrameState state = loop.loopBegin().stateAfter();
        BytecodePosition pos = new BytecodePosition(null, state.getMethod(), state.bci);
        SpeculationLog.SpeculationReason reason = LOOP_PREDICATION.createSpeculationReason(pos);
        SpeculationLog.Speculation speculation = graph.getSpeculationLog().speculate(reason);
        AbstractBeginNode anchor = AbstractBeginNode.prevBegin(loop.entryPoint());
        GuardNode upperGuard = graph.addOrUniqueWithInputs(new GuardNode(upperCond, anchor, guard.getReason(), guard.getAction(), guard.isNegated(), speculation, null));
        GuardNode lowerGuard = graph.addOrUniqueWithInputs(new GuardNode(lowerCond, anchor, guard.getReason(), guard.getAction(), guard.isNegated(), speculation, null));
        GuardingNode combinedGuard = MultiGuardNode.combine(lowerGuard, upperGuard);
        guard.replaceAtUsagesAndDelete(combinedGuard.asNode());
        graph.getOptimizationLog().report(LoopPredicationPhase.class, "GuardReplacement", guard);
    }

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }
}

