/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodeinfo;

import jdk.graal.compiler.core.common.NumUtil;

public final class NodeSize
extends Enum<NodeSize> {
    public static final /* enum */ NodeSize SIZE_UNSET = new NodeSize(0);
    public static final /* enum */ NodeSize SIZE_UNKNOWN = new NodeSize(0);
    public static final /* enum */ NodeSize SIZE_IGNORED = new NodeSize(0);
    public static final /* enum */ NodeSize SIZE_0 = new NodeSize(0);
    public static final /* enum */ NodeSize SIZE_1 = new NodeSize(1);
    public static final /* enum */ NodeSize SIZE_2 = new NodeSize(2);
    public static final /* enum */ NodeSize SIZE_4 = new NodeSize(4);
    public static final /* enum */ NodeSize SIZE_8 = new NodeSize(8);
    public static final /* enum */ NodeSize SIZE_16 = new NodeSize(16);
    public static final /* enum */ NodeSize SIZE_32 = new NodeSize(32);
    public static final /* enum */ NodeSize SIZE_64 = new NodeSize(64);
    public static final /* enum */ NodeSize SIZE_128 = new NodeSize(128);
    public static final /* enum */ NodeSize SIZE_256 = new NodeSize(256);
    public static final /* enum */ NodeSize SIZE_512 = new NodeSize(512);
    public static final /* enum */ NodeSize SIZE_1024 = new NodeSize(1024);
    private static final NodeSize[] VALUES;
    public final int value;
    public static final int IGNORE_SIZE_CONTRACT_FACTOR = 65535;
    private static final /* synthetic */ NodeSize[] $VALUES;

    public static NodeSize[] values() {
        return (NodeSize[])$VALUES.clone();
    }

    public static NodeSize valueOf(String name) {
        return Enum.valueOf(NodeSize.class, name);
    }

    private NodeSize(int value) {
        this.value = value;
    }

    public static NodeSize compute(NodeSize base, int opCount) {
        assert (NumUtil.assertNonNegativeInt(opCount));
        if (opCount == 0) {
            return SIZE_0;
        }
        assert (base.ordinal() > SIZE_0.ordinal()) : base;
        int log2 = NodeSize.log2(base.value * opCount);
        for (int i = base.ordinal(); i < VALUES.length; ++i) {
            if (NodeSize.log2(NodeSize.VALUES[i].value) != log2) continue;
            return VALUES[i];
        }
        return SIZE_1024;
    }

    public static NodeSize compute(int rawValue) {
        assert (NumUtil.assertNonNegativeInt(rawValue));
        if (rawValue == 0) {
            return SIZE_0;
        }
        assert (NumUtil.assertPositiveInt(rawValue));
        for (int i = SIZE_0.ordinal(); i < VALUES.length - 1; ++i) {
            if (NodeSize.VALUES[i].value < rawValue || rawValue > NodeSize.VALUES[i + 1].value) continue;
            int r1 = NodeSize.VALUES[i].value;
            int r2 = NodeSize.VALUES[i + 1].value;
            int diff = r2 - r1;
            return rawValue - r1 > diff / 2 ? VALUES[i + 1] : VALUES[i];
        }
        return SIZE_1024;
    }

    private static int log2(int val) {
        return 31 - Integer.numberOfLeadingZeros(val);
    }

    private static /* synthetic */ NodeSize[] $values() {
        return new NodeSize[]{SIZE_UNSET, SIZE_UNKNOWN, SIZE_IGNORED, SIZE_0, SIZE_1, SIZE_2, SIZE_4, SIZE_8, SIZE_16, SIZE_32, SIZE_64, SIZE_128, SIZE_256, SIZE_512, SIZE_1024};
    }

    static {
        $VALUES = NodeSize.$values();
        VALUES = NodeSize.values();
    }
}

