/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StateSplit;

@NodeInfo
public abstract class AbstractStateSplit
extends FixedWithNextNode
implements StateSplit {
    public static final NodeClass<AbstractStateSplit> TYPE = NodeClass.create(AbstractStateSplit.class);
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    protected AbstractStateSplit(NodeClass<? extends AbstractStateSplit> c, Stamp stamp) {
        this(c, stamp, null);
    }

    protected AbstractStateSplit(NodeClass<? extends AbstractStateSplit> c, Stamp stamp, FrameState stateAfter) {
        super((NodeClass<? extends FixedWithNextNode>)c, stamp);
        this.stateAfter = stateAfter;
    }

    @Override
    public boolean verifyNode() {
        assert (!this.hasSideEffect() || !this.graph().getGraphState().getFrameStateVerification().implies(GraphState.FrameStateVerificationFeature.STATE_SPLITS) || this.stateAfter != null) : "State split with side-effect must have a state until FSA " + String.valueOf(this);
        return super.verifyNode();
    }
}

