/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class BeginNode
extends AbstractBeginNode
implements Simplifiable {
    public static final NodeClass<BeginNode> TYPE = NodeClass.create(BeginNode.class);

    public BeginNode() {
        super((NodeClass<? extends AbstractBeginNode>)TYPE, StampFactory.forVoid());
    }

    @Override
    public void simplify(SimplifierTool tool) {
        IfNode ifNode;
        Node node;
        FixedNode prev = (FixedNode)this.predecessor();
        if (prev != null && !(prev instanceof ControlSplitNode)) {
            this.prepareDelete();
            tool.addToWorkList(this.next());
            this.graph().removeFixed(this);
        }
        if (this.isAlive() && (node = this.predecessor()) instanceof IfNode && PiNode.guardTrySkipPi(this, (ifNode = (IfNode)node).condition(), ifNode.falseSuccessor() == this, NodeView.from(tool))) {
            return;
        }
    }

    public static AbstractBeginNode begin(FixedNode with) {
        GraalError.guarantee(!(with instanceof AbstractMergeNode), "Method must not be called for merges.");
        try (DebugCloseable position = with.withNodeSourcePosition();){
            if (with instanceof AbstractBeginNode) {
                AbstractBeginNode abstractBeginNode = (AbstractBeginNode)with;
                return abstractBeginNode;
            }
            BeginNode begin = with.graph().add(new BeginNode());
            begin.setNext(with);
            BeginNode beginNode = begin;
            return beginNode;
        }
    }
}

