/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.function.Consumer;
import java.util.function.Function;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.StructuredGraph;
import org.graalvm.collections.EconomicMap;

public abstract class CompanionObjectEncoder<T, E extends EncodedObject> {
    private final EconomicMap<Long, E> encodedObjects = EconomicMap.create();

    protected CompanionObjectEncoder() {
    }

    public void prepare(StructuredGraph graph, Consumer<Object> adder) {
        T companionObject = this.getCompanionObject(graph);
        if (this.shouldBeEncoded(companionObject)) {
            E encodedObject = this.createInstance(companionObject);
            assert (encodedObject != null);
            adder.accept(encodedObject);
            assert (!this.encodedObjects.containsKey((Object)graph.graphId()));
            this.encodedObjects.put((Object)graph.graphId(), encodedObject);
        } else {
            adder.accept(null);
        }
    }

    public E encode(StructuredGraph graph, Function<Node, Integer> mapper) {
        T companionObject = this.getCompanionObject(graph);
        if (this.shouldBeEncoded(companionObject)) {
            EncodedObject encodedObject = (EncodedObject)this.encodedObjects.get((Object)graph.graphId());
            assert (encodedObject != null);
            this.encodeIntoInstance(encodedObject, companionObject, mapper);
            return (E)encodedObject;
        }
        return null;
    }

    protected abstract T getCompanionObject(StructuredGraph var1);

    protected abstract boolean shouldBeEncoded(T var1);

    protected abstract E createInstance(T var1);

    protected abstract void encodeIntoInstance(E var1, T var2, Function<Node, Integer> var3);

    public abstract boolean verify(StructuredGraph var1, StructuredGraph var2);

    protected static interface EncodedObject {
    }
}

