/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractDeoptimizeNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StaticDeoptimizingNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.Value;

@NodeInfo(shortName="Deopt", nameTemplate="Deopt {p#reason/s}")
public final class DeoptimizeNode
extends AbstractDeoptimizeNode
implements Lowerable,
LIRLowerable,
StaticDeoptimizingNode {
    public static final int DEFAULT_DEBUG_ID = 0;
    public static final NodeClass<DeoptimizeNode> TYPE = NodeClass.create(DeoptimizeNode.class);
    protected DeoptimizationAction action;
    protected DeoptimizationReason reason;
    protected int debugId;
    protected final SpeculationLog.Speculation speculation;
    protected boolean mayConvertToGuard;

    public DeoptimizeNode(DeoptimizationAction action, DeoptimizationReason reason) {
        this(action, reason, 0, SpeculationLog.NO_SPECULATION, null);
    }

    public DeoptimizeNode(DeoptimizationAction action, DeoptimizationReason reason, SpeculationLog.Speculation speculation) {
        this(action, reason, 0, speculation, null);
    }

    public DeoptimizeNode(DeoptimizationAction action, DeoptimizationReason reason, int debugId, SpeculationLog.Speculation speculation, FrameState stateBefore) {
        super(TYPE, stateBefore);
        assert (action != null);
        assert (reason != null);
        this.action = action;
        this.reason = reason;
        this.debugId = debugId;
        assert (speculation != null);
        this.speculation = speculation;
        this.mayConvertToGuard = true;
    }

    @Override
    public DeoptimizationAction getAction() {
        return this.action;
    }

    @Override
    public void setAction(DeoptimizationAction action) {
        this.action = action;
    }

    @Override
    public DeoptimizationReason getReason() {
        return this.reason;
    }

    @Override
    public void setReason(DeoptimizationReason reason) {
        this.reason = reason;
    }

    public int getDebugId() {
        DebugContext debug;
        int deoptDebugId = this.debugId;
        if (deoptDebugId == 0 && ((debug = this.getDebug()).isDumpEnabledForMethod() || debug.isLogEnabledForMethod())) {
            deoptDebugId = this.getId();
        }
        return deoptDebugId;
    }

    public void setDebugId(int debugId) {
        assert (debugId != 0);
        this.debugId = debugId;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        Value actionAndReason = tool.emitJavaConstant(tool.getMetaAccess().encodeDeoptActionAndReason(this.action, this.reason, this.getDebugId()));
        Value speculationValue = tool.emitJavaConstant(tool.getMetaAccess().encodeSpeculation(this.speculation));
        gen.getLIRGeneratorTool().emitDeoptimize(actionAndReason, speculationValue, gen.state(this));
    }

    @Override
    public ValueNode getActionAndReason(MetaAccessProvider metaAccess) {
        return ConstantNode.forConstant(metaAccess.encodeDeoptActionAndReason(this.action, this.reason, this.getDebugId()), metaAccess, this.graph());
    }

    @Override
    public ValueNode getSpeculation(MetaAccessProvider metaAccess) {
        return ConstantNode.forConstant(metaAccess.encodeSpeculation(this.speculation), metaAccess, this.graph());
    }

    @Override
    public SpeculationLog.Speculation getSpeculation() {
        return this.speculation;
    }

    public boolean canFloat() {
        return DeoptimizeNode.canFloat(this.getReason(), this.getAction());
    }

    public static boolean canFloat(DeoptimizationReason reason, DeoptimizationAction action) {
        return action != DeoptimizationAction.None && reason != DeoptimizationReason.Unresolved && reason != DeoptimizationReason.NotCompiledExceptionHandler && reason != DeoptimizationReason.UnreachedCode;
    }

    public boolean mayConvertToGuard() {
        return this.mayConvertToGuard;
    }

    public void mayConvertToGuard(boolean newMayConvertToGuard) {
        this.mayConvertToGuard = newMayConvertToGuard;
    }

    @Node.NodeIntrinsic
    public static native void deopt(@Node.ConstantNodeParameter DeoptimizationAction var0, @Node.ConstantNodeParameter DeoptimizationReason var1);
}

