/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractDeoptimizeNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;

@NodeInfo
public final class DynamicDeoptimizeNode
extends AbstractDeoptimizeNode
implements LIRLowerable,
Lowerable,
Canonicalizable {
    public static final NodeClass<DynamicDeoptimizeNode> TYPE = NodeClass.create(DynamicDeoptimizeNode.class);
    @Node.Input
    ValueNode actionAndReason;
    @Node.Input
    ValueNode speculation;

    public DynamicDeoptimizeNode(ValueNode actionAndReason, ValueNode speculation) {
        super((NodeClass<? extends AbstractDeoptimizeNode>)TYPE, (FrameState)null);
        this.actionAndReason = actionAndReason;
        this.speculation = speculation;
    }

    public ValueNode getActionAndReason() {
        return this.actionAndReason;
    }

    public ValueNode getSpeculation() {
        return this.speculation;
    }

    @Override
    public ValueNode getActionAndReason(MetaAccessProvider metaAccess) {
        return this.getActionAndReason();
    }

    @Override
    public ValueNode getSpeculation(MetaAccessProvider metaAccess) {
        return this.getSpeculation();
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        generator.getLIRGeneratorTool().emitDeoptimize(generator.operand(this.actionAndReason), generator.operand(this.speculation), generator.state(this));
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.actionAndReason.isConstant() && this.speculation.isConstant()) {
            JavaConstant constant = this.actionAndReason.asJavaConstant();
            JavaConstant speculationConstant = this.speculation.asJavaConstant();
            DeoptimizeNode newDeopt = new DeoptimizeNode(tool.getMetaAccess().decodeDeoptAction(constant), tool.getMetaAccess().decodeDeoptReason(constant), tool.getMetaAccess().decodeDebugId(constant), tool.getMetaAccess().decodeSpeculation(speculationConstant, this.graph().getSpeculationLog()), this.stateBefore());
            return newDeopt;
        }
        return this;
    }
}

