/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class GetObjectAddressNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<GetObjectAddressNode> TYPE = NodeClass.create(GetObjectAddressNode.class);
    @Node.Input
    ValueNode object;

    public GetObjectAddressNode(ValueNode obj) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Long));
        this.object = obj;
    }

    @Node.NodeIntrinsic
    public static native long get(Object var0);

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Variable obj = gen.getLIRGeneratorTool().newVariable(LIRKind.unknownReference(gen.getLIRGeneratorTool().target().arch.getWordKind()));
        if (this.object.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp && !((AbstractPointerStamp)this.object.stamp(NodeView.DEFAULT)).nonNull()) {
            gen.getLIRGeneratorTool().emitConvertNullToZero((AllocatableValue)obj, gen.operand(this.object));
        } else {
            gen.getLIRGeneratorTool().emitMove(obj, gen.operand(this.object));
        }
        gen.setResult(this, (Value)obj);
    }

    @Override
    public boolean verifyNode() {
        assert (this.graph().getGuardsStage().areFrameStatesAtDeopts() || this.graph().isSubstitution()) : "GetObjectAddressNode can't be used directly until frame states are fixed";
        return super.verifyNode();
    }
}

