/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.GuardProxyNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(nameTemplate="GuardPhi({i#values})", allowedUsageTypes={InputType.Guard})
public final class GuardPhiNode
extends PhiNode
implements GuardingNode {
    public static final NodeClass<GuardPhiNode> TYPE = NodeClass.create(GuardPhiNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    NodeInputList<ValueNode> values;

    public GuardPhiNode(AbstractMergeNode merge) {
        super(TYPE, StampFactory.forVoid(), merge);
        this.values = new NodeInputList(this);
    }

    public GuardPhiNode(AbstractMergeNode merge, ValueNode ... values) {
        super(TYPE, StampFactory.forVoid(), merge);
        this.values = new NodeInputList((Node)this, (Node[])values);
    }

    @Override
    public InputType valueInputType() {
        return InputType.Guard;
    }

    @Override
    public NodeInputList<ValueNode> values() {
        return this.values;
    }

    @Override
    public PhiNode duplicateOn(AbstractMergeNode newMerge) {
        return this.graph().addWithoutUnique(new GuardPhiNode(newMerge));
    }

    @Override
    public GuardPhiNode duplicateWithValues(AbstractMergeNode newMerge, ValueNode ... newValues) {
        return new GuardPhiNode(newMerge, newValues);
    }

    @Override
    public ProxyNode createProxyFor(LoopExitNode lex) {
        return this.graph().addWithoutUnique(new GuardProxyNode(this, lex));
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        if (this.isLoopPhi()) {
            boolean allBackValuesNull = true;
            for (int i = 1; i < this.valueCount(); ++i) {
                ValueNode value = this.valueAt(i);
                if (value == null) continue;
                allBackValuesNull = false;
                break;
            }
            if (allBackValuesNull) {
                return this.valueAt(0);
            }
        }
        return super.canonical(tool);
    }
}

