/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.graph.Position;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.ShortCircuitOrNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.FloatNormalizeCompareNode;
import jdk.graal.compiler.nodes.calc.IntegerBelowNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.IntegerLessThanNode;
import jdk.graal.compiler.nodes.calc.IntegerNormalizeCompareNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.ObjectEqualsNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.debug.ControlFlowAnchored;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.UnboxNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.memory.MemoryAnchorNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.spi.SwitchFoldable;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_2, sizeRationale="2 jmps")
public final class IfNode
extends ControlSplitNode
implements Simplifiable,
LIRLowerable,
IterableNodeType,
SwitchFoldable {
    public static final NodeClass<IfNode> TYPE = NodeClass.create(IfNode.class);
    private static final CounterKey CORRECTED_PROBABILITIES = DebugContext.counter("CorrectedProbabilities");
    @Node.Successor
    AbstractBeginNode trueSuccessor;
    @Node.Successor
    AbstractBeginNode falseSuccessor;
    @Node.Input(value=InputType.Condition)
    LogicNode condition;
    protected ProfileData.BranchProbabilityData profileData;
    private static final CounterKey NumberOfMergedRangeChecks = DebugContext.counter("NumberMergedRangeChecks_XaaB");
    private static final CounterKey NumberOfMergedRangeChecksShortCircuitOr = DebugContext.counter("NumberMergedRangeChecks_XooB_ShortCircuitOr");
    private static final int MAX_USAGE_COLOR_SET_SIZE = 64;

    public LogicNode condition() {
        return this.condition;
    }

    public void setCondition(LogicNode x) {
        this.updateUsages(this.condition, x);
        this.condition = x;
    }

    public IfNode(LogicNode condition, FixedNode trueSuccessor, FixedNode falseSuccessor, ProfileData.BranchProbabilityData profileData) {
        this(condition, BeginNode.begin(trueSuccessor), BeginNode.begin(falseSuccessor), profileData);
    }

    public IfNode(LogicNode condition, AbstractBeginNode trueSuccessor, AbstractBeginNode falseSuccessor, ProfileData.BranchProbabilityData profileData) {
        super((NodeClass<? extends ControlSplitNode>)TYPE, StampFactory.forVoid());
        this.condition = condition;
        this.falseSuccessor = falseSuccessor;
        this.trueSuccessor = trueSuccessor;
        this.profileData = profileData;
    }

    public AbstractBeginNode trueSuccessor() {
        return this.trueSuccessor;
    }

    public AbstractBeginNode falseSuccessor() {
        return this.falseSuccessor;
    }

    public double getTrueSuccessorProbability() {
        return this.profileData.getDesignatedSuccessorProbability();
    }

    public void setTrueSuccessor(AbstractBeginNode node) {
        this.updatePredecessor(this.trueSuccessor, node);
        this.trueSuccessor = node;
    }

    public void setFalseSuccessor(AbstractBeginNode node) {
        this.updatePredecessor(this.falseSuccessor, node);
        this.falseSuccessor = node;
    }

    public AbstractBeginNode successor(boolean istrue) {
        return istrue ? this.trueSuccessor : this.falseSuccessor;
    }

    public void setTrueSuccessorProbability(ProfileData.BranchProbabilityData profileData) {
        double prob = profileData.getDesignatedSuccessorProbability();
        assert (ProfileData.isApproximatelyInRange(prob, 0.0, 1.0)) : "Probability out of bounds: " + prob;
        double trueSuccessorProbability = Math.clamp(prob, 0.0, 1.0);
        this.profileData = profileData.copy(trueSuccessorProbability);
    }

    protected ProfileData.BranchProbabilityData trueSuccessorProfile() {
        return this.profileData;
    }

    @Override
    public double probability(AbstractBeginNode successor) {
        return successor == this.trueSuccessor ? this.getTrueSuccessorProbability() : 1.0 - this.getTrueSuccessorProbability();
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.emitIf(this);
    }

    @Override
    public boolean verifyNode() {
        this.assertTrue(this.condition() != null, "missing condition", new Object[0]);
        this.assertTrue(this.trueSuccessor() != null, "missing trueSuccessor", new Object[0]);
        this.assertTrue(this.falseSuccessor() != null, "missing falseSuccessor", new Object[0]);
        return super.verifyNode();
    }

    public void eliminateNegation() {
        AbstractBeginNode oldFalseSuccessor;
        AbstractBeginNode oldTrueSuccessor = this.trueSuccessor;
        this.trueSuccessor = oldFalseSuccessor = this.falseSuccessor;
        this.falseSuccessor = oldTrueSuccessor;
        double trueSuccessorProbability = 1.0 - this.getTrueSuccessorProbability();
        this.profileData = this.profileData.copy(trueSuccessorProbability);
        this.setCondition(((LogicNegationNode)this.condition).getValue());
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.trueSuccessor().next() instanceof DeoptimizeNode) {
            if (this.getTrueSuccessorProbability() != 0.0) {
                CORRECTED_PROBABILITIES.increment(this.getDebug());
                this.profileData = BranchProbabilityNode.NEVER_TAKEN_PROFILE;
            }
        } else if (this.falseSuccessor().next() instanceof DeoptimizeNode && this.getTrueSuccessorProbability() != 1.0) {
            CORRECTED_PROBABILITIES.increment(this.getDebug());
            this.profileData = BranchProbabilityNode.ALWAYS_TAKEN_PROFILE;
        }
        if (this.condition() instanceof LogicNegationNode) {
            this.eliminateNegation();
        }
        if (this.condition() instanceof LogicConstantNode) {
            LogicConstantNode c = (LogicConstantNode)this.condition();
            if (c.getValue()) {
                tool.deleteBranch(this.falseSuccessor());
                tool.addToWorkList(this.trueSuccessor());
                this.graph().removeSplit(this, this.trueSuccessor());
            } else {
                tool.deleteBranch(this.trueSuccessor());
                tool.addToWorkList(this.falseSuccessor());
                this.graph().removeSplit(this, this.falseSuccessor());
            }
            return;
        }
        if (tool.allUsagesAvailable() && this.trueSuccessor().hasNoUsages() && this.falseSuccessor().hasNoUsages()) {
            this.pushNodesThroughIf(tool);
            if (this.checkForUnsignedCompare(tool) || this.removeOrMaterializeIf(tool)) {
                return;
            }
        }
        if (this.removeIntermediateMaterialization(tool)) {
            return;
        }
        if (this.conditionalNodeOptimization(tool)) {
            return;
        }
        if (this.switchTransformationOptimization(tool)) {
            return;
        }
        if (tool.finalCanonicalization() && this.falseSuccessor().hasNoUsages() && !(this.falseSuccessor() instanceof LoopExitNode) && this.falseSuccessor().next() instanceof IfNode && !(((IfNode)this.falseSuccessor().next()).falseSuccessor() instanceof LoopExitNode)) {
            AbstractBeginNode intermediateBegin = this.falseSuccessor();
            IfNode nextIf = (IfNode)intermediateBegin.next();
            double probabilityB = (1.0 - this.getTrueSuccessorProbability()) * nextIf.getTrueSuccessorProbability();
            if (this.getTrueSuccessorProbability() < probabilityB && IfNode.prepareForSwap(tool, this.condition(), nextIf.condition())) {
                assert (intermediateBegin.next() == nextIf) : Assertions.errorMessage(intermediateBegin, intermediateBegin.next(), nextIf);
                AbstractBeginNode bothFalseBegin = nextIf.falseSuccessor();
                nextIf.setFalseSuccessor(null);
                intermediateBegin.setNext(null);
                this.setFalseSuccessor(null);
                this.replaceAtPredecessor(nextIf);
                nextIf.setFalseSuccessor(intermediateBegin);
                intermediateBegin.setNext(this);
                this.setFalseSuccessor(bothFalseBegin);
                NodeSourcePosition intermediateBeginPosition = intermediateBegin.getNodeSourcePosition();
                intermediateBegin.setNodeSourcePosition(bothFalseBegin.getNodeSourcePosition());
                bothFalseBegin.setNodeSourcePosition(intermediateBeginPosition);
                ProfileData.ProfileSource combinedSource = this.profileData.getProfileSource().combine(nextIf.profileData.getProfileSource());
                nextIf.setTrueSuccessorProbability(ProfileData.BranchProbabilityData.create(probabilityB, combinedSource));
                if (probabilityB == 1.0) {
                    this.setTrueSuccessorProbability(ProfileData.BranchProbabilityData.create(0.0, combinedSource));
                } else {
                    double newProbability = this.getTrueSuccessorProbability() / (1.0 - probabilityB);
                    this.setTrueSuccessorProbability(ProfileData.BranchProbabilityData.create(Math.min(1.0, newProbability), combinedSource));
                }
                return;
            }
        }
        if (this.tryEliminateBoxedReferenceEquals(tool)) {
            return;
        }
        if (IfNode.optimizeCompoundConditional(this)) {
            return;
        }
        if (this.graph().isAfterStage(GraphState.StageFlag.HIGH_TIER_LOWERING) && this.splitIfAtPhi(this, tool)) {
            return;
        }
    }

    public static boolean isWorthPerformingSplit(LogicNode newCondition, LogicNode originalCondition) {
        if (newCondition == originalCondition) {
            return false;
        }
        if (newCondition.isAlive()) {
            return true;
        }
        if (newCondition instanceof LogicConstantNode) {
            return true;
        }
        if (newCondition instanceof LogicNegationNode) {
            LogicNegationNode logicNegationNode = (LogicNegationNode)newCondition;
            return IfNode.isWorthPerformingSplit(logicNegationNode.getValue(), originalCondition);
        }
        return originalCondition instanceof InstanceOfNode && newCondition instanceof IsNullNode;
    }

    private boolean splitIfAtPhi(IfNode ifNode, SimplifierTool tool) {
        if (!(ifNode.predecessor() instanceof MergeNode)) {
            return false;
        }
        MergeNode merge = (MergeNode)ifNode.predecessor();
        if (merge.forwardEndCount() == 1) {
            return false;
        }
        if (merge.getUsageCount() != 1 || merge.phis().count() != 1) {
            return false;
        }
        if (ifNode.graph().getGuardsStage().areFrameStatesAtSideEffects() && merge.stateAfter() == null) {
            return false;
        }
        PhiNode generalPhi = merge.phis().first();
        if (!(generalPhi instanceof ValuePhiNode)) {
            return false;
        }
        if (ifNode.trueSuccessor().isUsedAsGuardInput() || ifNode.falseSuccessor().isUsedAsGuardInput()) {
            return false;
        }
        ValuePhiNode phi = (ValuePhiNode)generalPhi;
        EconomicMap coloredNodes = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)8);
        if (!IfNode.conditionUses(ifNode.condition(), phi, (EconomicMap<Node, NodeColor>)coloredNodes)) {
            return false;
        }
        if (merge.stateAfter() != null && !GraphUtil.mayRemoveSplit(ifNode)) {
            return false;
        }
        LogicNode[] results = new LogicNode[merge.forwardEndCount()];
        boolean success = false;
        for (int i = 0; i < results.length; ++i) {
            ValueNode value = phi.valueAt(i);
            LogicNode curResult = IfNode.computeCondition(tool, ifNode.condition(), phi, value);
            if (IfNode.isWorthPerformingSplit(curResult, ifNode.condition())) {
                for (Node n : curResult.inputs()) {
                    if (n instanceof ConstantNode || n instanceof ParameterNode || n instanceof FixedNode || n == value) continue;
                    curResult = ifNode.condition();
                    break;
                }
                success = true;
                results[i] = curResult;
                continue;
            }
            results[i] = ifNode.condition();
        }
        if (!success) {
            return false;
        }
        for (Node usage : phi.usages()) {
            NodeColor color;
            if (usage == merge.stateAfter() || (color = this.colorUsage((EconomicMap<Node, NodeColor>)coloredNodes, usage, merge, ifNode.trueSuccessor(), ifNode.falseSuccessor())) != NodeColor.MIXED) continue;
            return false;
        }
        AbstractMergeNode trueMerge = null;
        AbstractMergeNode falseMerge = null;
        int i = 0;
        for (EndNode end : merge.forwardEnds().snapshot()) {
            LogicNode result;
            ValueNode value = phi.valueAt(end);
            if ((result = results[i++]) instanceof LogicConstantNode) {
                if (((LogicConstantNode)result).getValue()) {
                    if (trueMerge == null) {
                        trueMerge = IfNode.insertMerge(ifNode.trueSuccessor(), phi, merge.stateAfter(), tool);
                        IfNode.replaceNodesInBranch((EconomicMap<Node, NodeColor>)coloredNodes, NodeColor.TRUE_BRANCH, phi, trueMerge.phis().first());
                    }
                    trueMerge.phis().first().addInput(value);
                    trueMerge.addForwardEnd(end);
                } else {
                    if (falseMerge == null) {
                        falseMerge = IfNode.insertMerge(ifNode.falseSuccessor(), phi, merge.stateAfter(), tool);
                        IfNode.replaceNodesInBranch((EconomicMap<Node, NodeColor>)coloredNodes, NodeColor.FALSE_BRANCH, phi, falseMerge.phis().first());
                    }
                    falseMerge.phis().first().addInput(value);
                    falseMerge.addForwardEnd(end);
                }
                merge.removeEnd(end);
                continue;
            }
            if (result == ifNode.condition()) continue;
            BeginNode trueBegin = ifNode.graph().add(new BeginNode());
            trueBegin.setNodeSourcePosition(ifNode.trueSuccessor().getNodeSourcePosition());
            BeginNode falseBegin = ifNode.graph().add(new BeginNode());
            falseBegin.setNodeSourcePosition(ifNode.falseSuccessor().getNodeSourcePosition());
            if (result.graph() == null) {
                result = ifNode.graph().addOrUniqueWithInputs(result);
                result.setNodeSourcePosition(ifNode.condition().getNodeSourcePosition());
            }
            IfNode newIfNode = ifNode.graph().add(new IfNode(result, trueBegin, falseBegin, ifNode.getProfileData()));
            newIfNode.setNodeSourcePosition(ifNode.getNodeSourcePosition());
            if (trueMerge == null) {
                trueMerge = IfNode.insertMerge(ifNode.trueSuccessor(), phi, merge.stateAfter(), tool);
                IfNode.replaceNodesInBranch((EconomicMap<Node, NodeColor>)coloredNodes, NodeColor.TRUE_BRANCH, phi, trueMerge.phis().first());
            }
            trueMerge.phis().first().addInput(value);
            trueBegin.setNext(ifNode.graph().add(new EndNode()));
            trueMerge.addForwardEnd((EndNode)trueBegin.next());
            if (falseMerge == null) {
                falseMerge = IfNode.insertMerge(ifNode.falseSuccessor(), phi, merge.stateAfter(), tool);
                IfNode.replaceNodesInBranch((EconomicMap<Node, NodeColor>)coloredNodes, NodeColor.FALSE_BRANCH, phi, falseMerge.phis().first());
            }
            falseMerge.phis().first().addInput(value);
            falseBegin.setNext(ifNode.graph().add(new EndNode()));
            falseMerge.addForwardEnd((EndNode)falseBegin.next());
            merge.removeEnd(end);
            ((FixedWithNextNode)end.predecessor()).setNext(newIfNode);
            end.safeDelete();
        }
        IfNode.cleanupMerge(merge);
        IfNode.cleanupMerge(trueMerge);
        IfNode.cleanupMerge(falseMerge);
        return true;
    }

    private static void replaceNodesInBranch(EconomicMap<Node, NodeColor> coloredNodes, NodeColor branch, ValuePhiNode phi, ValueNode newValue) {
        for (Node n : phi.usages().snapshot()) {
            if (coloredNodes.get((Object)n) == branch) {
                n.replaceAllInputs(phi, newValue);
                continue;
            }
            if (coloredNodes.get((Object)n) != NodeColor.PHI_MIXED) continue;
            assert (n instanceof PhiNode) : Assertions.errorMessageContext("n", n, "phi", phi);
            PhiNode phiNode = (PhiNode)n;
            AbstractMergeNode merge = phiNode.merge();
            for (int i = 0; i < merge.forwardEndCount(); ++i) {
                if (phiNode.valueAt(i) != phi || coloredNodes.get((Object)merge.forwardEndAt(i)) != branch) continue;
                phiNode.setValueAt(i, newValue);
            }
        }
    }

    private NodeColor colorUsage(EconomicMap<Node, NodeColor> coloredNodes, Node node, MergeNode merge, AbstractBeginNode trueSucc, AbstractBeginNode falseSucc) {
        NodeColor color = (NodeColor)((Object)coloredNodes.get((Object)node));
        if (color == null) {
            if (coloredNodes.size() >= 64) {
                return NodeColor.MIXED;
            }
            coloredNodes.put((Object)node, (Object)NodeColor.MIXED);
            if (node == merge) {
                color = NodeColor.MIXED;
            } else if (node == trueSucc) {
                color = NodeColor.TRUE_BRANCH;
            } else if (node == falseSucc) {
                color = NodeColor.FALSE_BRANCH;
            } else if (node instanceof AbstractMergeNode) {
                AbstractMergeNode mergeNode = (AbstractMergeNode)node;
                NodeColor combinedColor = null;
                for (int i = 0; i < mergeNode.forwardEndCount(); ++i) {
                    NodeColor curColor = this.colorUsage(coloredNodes, mergeNode.forwardEndAt(i), merge, trueSucc, falseSucc);
                    if (combinedColor == null) {
                        combinedColor = curColor;
                        continue;
                    }
                    if (combinedColor == curColor) continue;
                    combinedColor = NodeColor.MIXED;
                    break;
                }
                color = combinedColor;
            } else if (node instanceof StartNode) {
                color = NodeColor.MIXED;
            } else if (node instanceof FixedNode) {
                FixedNode fixedNode = (FixedNode)node;
                Node predecessor = fixedNode.predecessor();
                assert (predecessor != null) : fixedNode;
                color = this.colorUsage(coloredNodes, predecessor, merge, trueSucc, falseSucc);
            } else if (node instanceof PhiNode) {
                PhiNode phiNode = (PhiNode)node;
                AbstractMergeNode phiMerge = phiNode.merge();
                if (phiMerge instanceof LoopBeginNode) {
                    color = this.colorUsage(coloredNodes, phiMerge, merge, trueSucc, falseSucc);
                } else {
                    for (int i = 0; i < phiMerge.forwardEndCount(); ++i) {
                        NodeColor curColor = this.colorUsage(coloredNodes, phiMerge.forwardEndAt(i), merge, trueSucc, falseSucc);
                        if (curColor == NodeColor.TRUE_BRANCH || curColor == NodeColor.FALSE_BRANCH) continue;
                        color = NodeColor.MIXED;
                        break;
                    }
                    if (color == null) {
                        color = NodeColor.PHI_MIXED;
                        assert (node instanceof PhiNode) : Assertions.errorMessage(node);
                    }
                }
            } else {
                NodeColor combinedColor = null;
                for (Node n : node.usages()) {
                    if (n == node) continue;
                    NodeColor curColor = this.colorUsage(coloredNodes, n, merge, trueSucc, falseSucc);
                    if (combinedColor == null) {
                        combinedColor = curColor;
                        continue;
                    }
                    if (combinedColor == curColor) continue;
                    combinedColor = NodeColor.MIXED;
                    break;
                }
                if (combinedColor == NodeColor.PHI_MIXED) {
                    combinedColor = NodeColor.MIXED;
                }
                if (combinedColor == null) {
                    combinedColor = NodeColor.MIXED;
                }
                color = combinedColor;
            }
            assert (color != null) : node;
            coloredNodes.put((Object)node, (Object)color);
        }
        return color;
    }

    private static boolean conditionUses(LogicNode condition, PhiNode phi, EconomicMap<Node, NodeColor> coloredNodes) {
        Canonicalizable.Binary binary;
        if (!condition.hasExactlyOneUsage()) {
            return false;
        }
        if (condition instanceof ShortCircuitOrNode) {
            if (condition.graph().getGuardsStage().areDeoptsFixed()) {
                ShortCircuitOrNode orNode = (ShortCircuitOrNode)condition;
                return IfNode.conditionUses(orNode.getX(), phi, coloredNodes) || IfNode.conditionUses(orNode.getY(), phi, coloredNodes);
            }
        } else if (condition instanceof Canonicalizable.Unary) {
            Canonicalizable.Unary unary = (Canonicalizable.Unary)((Object)condition);
            if (unary.getValue() == phi) {
                coloredNodes.put((Object)condition, (Object)NodeColor.CONDITION_USAGE);
                return true;
            }
        } else if (condition instanceof Canonicalizable.Binary && ((binary = (Canonicalizable.Binary)((Object)condition)).getX() == phi || binary.getY() == phi)) {
            coloredNodes.put((Object)condition, (Object)NodeColor.CONDITION_USAGE);
            return true;
        }
        return false;
    }

    private static LogicNode computeCondition(SimplifierTool tool, LogicNode condition, PhiNode phi, Node value) {
        Canonicalizable.Unary compare;
        if (condition instanceof ShortCircuitOrNode) {
            if (condition.graph().getGuardsStage().areDeoptsFixed() && condition.graph().isBeforeStage(GraphState.StageFlag.EXPAND_LOGIC)) {
                ShortCircuitOrNode orNode = (ShortCircuitOrNode)condition;
                LogicNode resultX = IfNode.computeCondition(tool, orNode.getX(), phi, value);
                LogicNode resultY = IfNode.computeCondition(tool, orNode.getY(), phi, value);
                if (resultX != orNode.getX() || resultY != orNode.getY()) {
                    LogicNode result = orNode.canonical((CanonicalizerTool)tool, resultX, resultY);
                    if (result != orNode) {
                        return result;
                    }
                    ShortCircuitOrNode newOr = new ShortCircuitOrNode(resultX, orNode.isXNegated(), resultY, orNode.isYNegated(), orNode.getShortCircuitProbability());
                    return (LogicNode)newOr.canonical(tool);
                }
                return orNode;
            }
        } else if (condition instanceof Canonicalizable.Binary) {
            Canonicalizable.Binary compare2 = (Canonicalizable.Binary)((Object)condition);
            if (compare2.getX() == phi || compare2.getY() == phi) {
                return (LogicNode)compare2.canonical(tool, compare2.getX() == phi ? value : compare2.getX(), compare2.getY() == phi ? value : compare2.getY());
            }
        } else if (condition instanceof Canonicalizable.Unary && (compare = (Canonicalizable.Unary)((Object)condition)).getValue() == phi) {
            return (LogicNode)compare.canonical(tool, value);
        }
        if (condition instanceof Canonicalizable) {
            return (LogicNode)((Canonicalizable)((Object)condition)).canonical(tool);
        }
        return condition;
    }

    private static void cleanupMerge(MergeNode merge) {
        if (merge != null && merge.isAlive()) {
            if (merge.forwardEndCount() == 0) {
                GraphUtil.killCFG(merge);
            } else if (merge.forwardEndCount() == 1) {
                merge.graph().reduceTrivialMerge(merge);
            }
        }
    }

    private static MergeNode insertMerge(AbstractBeginNode begin, ValuePhiNode oldPhi, FrameState stateAfter, SimplifierTool tool) {
        AbstractBeginNode newBegin;
        MergeNode merge = begin.graph().add(new MergeNode());
        try (DebugCloseable position = begin.withNodeSourcePosition();){
            newBegin = begin.graph().add(new BeginNode());
            begin.replaceAtPredecessor(newBegin);
            newBegin.setNext(begin);
        }
        FixedNode next = newBegin.next();
        next.replaceAtPredecessor(merge);
        newBegin.setNext(begin.graph().add(new EndNode()));
        merge.addForwardEnd((EndNode)newBegin.next());
        ValuePhiNode phi = begin.graph().addOrUnique(new ValuePhiNode(oldPhi.stamp(NodeView.DEFAULT), merge));
        phi.addInput(oldPhi);
        if (stateAfter != null) {
            FrameState newState = stateAfter.duplicate();
            newState.replaceAllInputs(oldPhi, phi);
            merge.setStateAfter(newState);
        }
        merge.setNext(next);
        tool.addToWorkList(begin);
        return merge;
    }

    private static LogicNode canMergeRangeChecks(LogicNode condition1, LogicNode condition2, boolean trueOrdered) {
        long bRaw;
        if (condition1.equals(condition2)) {
            return null;
        }
        if (!(condition1 instanceof IntegerLessThanNode)) {
            return null;
        }
        if (!(condition2 instanceof IntegerLessThanNode)) {
            return null;
        }
        IntegerLessThanNode c1 = (IntegerLessThanNode)condition1;
        IntegerLessThanNode c2 = (IntegerLessThanNode)condition2;
        if (c1.getX() != c2.getX()) {
            return null;
        }
        if (!c1.getY().isConstant() || !c2.getY().isConstant()) {
            return null;
        }
        ValueNode x = c1.getX();
        ValueNode a = trueOrdered ? c1.getY() : c2.getY();
        ValueNode b = trueOrdered ? c2.getY() : c1.getY();
        IntegerStamp xStamp = (IntegerStamp)x.stamp(NodeView.DEFAULT);
        IntegerStamp aStamp = (IntegerStamp)a.stamp(NodeView.DEFAULT);
        IntegerStamp bStamp = (IntegerStamp)b.stamp(NodeView.DEFAULT);
        assert (xStamp.getBits() == aStamp.getBits()) : Assertions.errorMessageContext("c1", condition1, "c2", condition2, "xStamp", xStamp, "aStamp", aStamp, "bStamp", bStamp);
        assert (xStamp.getBits() == bStamp.getBits()) : Assertions.errorMessageContext("c1", condition1, "c2", condition2, "xStamp", xStamp, "aStamp", aStamp, "bStamp", bStamp);
        long aRaw = aStamp.asConstant().asLong();
        if (aRaw >= (bRaw = bStamp.asConstant().asLong())) {
            return null;
        }
        StructuredGraph graph = condition1.graph();
        ValueNode left = SubNode.create(x, a, NodeView.DEFAULT);
        ValueNode rigt = SubNode.create(b, a, NodeView.DEFAULT);
        LogicNode newCondition = graph.addOrUniqueWithInputs(IntegerBelowNode.create(left, rigt, NodeView.DEFAULT));
        return newCondition;
    }

    private static boolean optimizeCompoundConditional(IfNode ifNode) {
        return IfNode.mergeShortCircuitOrRangeCheck(ifNode) || IfNode.mergeShortCircuitAndRangeCheck(ifNode);
    }

    private static boolean mergeShortCircuitOrRangeCheck(IfNode ifNode) {
        LogicNode condition = ifNode.condition();
        if (condition instanceof ShortCircuitOrNode) {
            LogicNode replacement;
            ShortCircuitOrNode sco = (ShortCircuitOrNode)condition;
            LogicNode left = sco.getX();
            LogicNode right = sco.getY();
            if (!sco.isXNegated() && sco.isYNegated()) {
                LogicNode replacement2 = IfNode.canMergeRangeChecks(left, right, true);
                if (replacement2 != null) {
                    ifNode.getDebug().dump(5, (Object)ifNode.graph(), "Before XooY rewrite %s", ifNode);
                    ifNode.setCondition(condition.graph().addOrUniqueWithInputs(LogicNegationNode.create(replacement2)));
                    NumberOfMergedRangeChecksShortCircuitOr.increment(ifNode.getDebug());
                    ifNode.getDebug().dump(5, (Object)ifNode.graph(), "After XooY rewrite %s", ifNode);
                }
            } else if (sco.isXNegated() && !sco.isYNegated() && (replacement = IfNode.canMergeRangeChecks(left, right, false)) != null) {
                ifNode.getDebug().dump(5, (Object)ifNode.graph(), "Before XooY rewrite %s", ifNode);
                ifNode.setCondition(condition.graph().addOrUniqueWithInputs(LogicNegationNode.create(replacement)));
                NumberOfMergedRangeChecksShortCircuitOr.increment(ifNode.getDebug());
                ifNode.getDebug().dump(5, (Object)ifNode.graph(), "After XooY rewrite %s", ifNode);
            }
        }
        return false;
    }

    private static boolean mergeShortCircuitAndRangeCheck(IfNode ifNode) {
        AbstractBeginNode trueSucc = ifNode.trueSuccessor();
        AbstractBeginNode falseSucc = ifNode.falseSuccessor();
        if (trueSucc.hasUsages() || falseSucc.hasUsages()) {
            return false;
        }
        if (trueSucc instanceof LoopExitNode || falseSucc instanceof LoopExitNode) {
            return false;
        }
        boolean truePattern = falseSucc.next() instanceof IfNode;
        LogicNode originalCondition = ifNode.condition();
        if ((truePattern ? falseSucc.next() : trueSucc.next()) instanceof IfNode) {
            LogicNode replacee;
            IfNode potentialCompoundIf = (IfNode)(truePattern ? falseSucc.next() : trueSucc.next());
            LogicNode potentialComoundCondition = potentialCompoundIf.condition();
            if ((truePattern ? IfNode.sameDestination(trueSucc, potentialCompoundIf.falseSuccessor()) : IfNode.sameDestination(falseSucc, potentialCompoundIf.trueSuccessor())) && (replacee = IfNode.canMergeRangeChecks(originalCondition, potentialComoundCondition, truePattern)) != null) {
                ifNode.getDebug().dump(5, ifNode.graph(), "Before XaaY rewrite");
                ifNode.setCondition(null);
                potentialCompoundIf.setCondition(null);
                potentialCompoundIf.setCondition(replacee);
                ProfileData.BranchProbabilityData newProfile = truePattern ? potentialCompoundIf.getProfileData().combineAndWithNegated(ifNode.getProfileData()) : ifNode.getProfileData().combineAndWithNegated(potentialCompoundIf.getProfileData());
                FixedNode pred = (FixedNode)ifNode.predecessor();
                ((FixedWithNextNode)potentialCompoundIf.predecessor()).setNext(null);
                ((FixedWithNextNode)pred).setNext(potentialCompoundIf);
                potentialCompoundIf.setTrueSuccessorProbability(newProfile);
                GraphUtil.killCFG(ifNode);
                ifNode.getDebug().dump(5, ifNode.graph(), "After XaaY rewrite");
                if (!truePattern) {
                    AbstractBeginNode survivingIfTrueSucc = potentialCompoundIf.trueSuccessor();
                    AbstractBeginNode survivingIfFalseSucc = potentialCompoundIf.falseSuccessor();
                    potentialCompoundIf.setTrueSuccessor(null);
                    potentialCompoundIf.setFalseSuccessor(null);
                    potentialCompoundIf.setTrueSuccessor(survivingIfFalseSucc);
                    potentialCompoundIf.setFalseSuccessor(survivingIfTrueSucc);
                }
                NumberOfMergedRangeChecks.increment(replacee.graph().getDebug());
                return true;
            }
        }
        return false;
    }

    private static boolean isUnboxedFrom(MetaAccessProvider meta, NodeView view, ValueNode x, ValueNode src) {
        if (x == src) {
            return true;
        }
        if (x instanceof UnboxNode) {
            return IfNode.isUnboxedFrom(meta, view, ((UnboxNode)x).getValue(), src);
        }
        if (x instanceof PiNode) {
            PiNode pi = (PiNode)x;
            return IfNode.isUnboxedFrom(meta, view, pi.getOriginalNode(), src);
        }
        if (x instanceof LoadFieldNode) {
            LoadFieldNode load = (LoadFieldNode)x;
            ResolvedJavaType integerType = meta.lookupJavaType(Integer.class);
            if (load.getValue().stamp(view).javaType(meta).equals((Object)integerType)) {
                return IfNode.isUnboxedFrom(meta, view, load.getValue(), src);
            }
            return false;
        }
        return false;
    }

    private boolean tryEliminateBoxedReferenceEquals(SimplifierTool tool) {
        if (!(this.condition instanceof ObjectEqualsNode)) {
            return false;
        }
        MetaAccessProvider meta = tool.getMetaAccess();
        ObjectEqualsNode equalsCondition = (ObjectEqualsNode)this.condition;
        ValueNode x = equalsCondition.getX();
        ValueNode y = equalsCondition.getY();
        ResolvedJavaType integerType = meta.lookupJavaType(Integer.class);
        NodeView view = NodeView.from(tool);
        if (!x.stamp(view).javaType(meta).equals((Object)integerType) && !y.stamp(view).javaType(meta).equals((Object)integerType)) {
            return false;
        }
        if (this.getTrueSuccessorProbability() > 0.4) {
            return false;
        }
        if (this.trueSuccessor instanceof BeginNode || this.trueSuccessor instanceof LoopExitNode) {
            if (!(this.trueSuccessor.next() instanceof EndNode)) {
                return false;
            }
        } else {
            return false;
        }
        UnboxNode unbox = null;
        FixedGuardNode unboxCheck = null;
        for (FixedNode node : this.falseSuccessor.getBlockNodes()) {
            IntegerEqualsNode equals;
            FixedGuardNode fixed;
            if (!(node instanceof BeginNode || node instanceof UnboxNode || node instanceof FixedGuardNode || node instanceof EndNode || node instanceof LoadFieldNode || node instanceof LoopExitNode)) {
                return false;
            }
            if (node instanceof UnboxNode) {
                if (unbox == null) {
                    unbox = (UnboxNode)node;
                } else {
                    return false;
                }
            }
            if (!(node instanceof FixedGuardNode) || !((fixed = (FixedGuardNode)node).condition() instanceof IntegerEqualsNode) || (!IfNode.isUnboxedFrom(meta, view, (equals = (IntegerEqualsNode)fixed.condition()).getX(), x) || !IfNode.isUnboxedFrom(meta, view, equals.getY(), y)) && (!IfNode.isUnboxedFrom(meta, view, equals.getX(), y) || !IfNode.isUnboxedFrom(meta, view, equals.getY(), x))) continue;
            unboxCheck = fixed;
        }
        if (unbox == null || unboxCheck == null) {
            return false;
        }
        this.setCondition(this.graph().addOrUniqueWithInputs(LogicConstantNode.contradiction()));
        return true;
    }

    @Override
    public Node getNextSwitchFoldableBranch() {
        return this.falseSuccessor();
    }

    @Override
    public boolean isInSwitch(ValueNode switchValue) {
        return SwitchFoldable.maybeIsInSwitch(this.condition()) && SwitchFoldable.sameSwitchValue(this.condition(), switchValue);
    }

    @Override
    public void cutOffCascadeNode() {
        this.setTrueSuccessor(null);
    }

    @Override
    public void cutOffLowestCascadeNode() {
        this.setFalseSuccessor(null);
        this.setTrueSuccessor(null);
    }

    @Override
    public AbstractBeginNode getDefault() {
        return this.falseSuccessor();
    }

    @Override
    public ValueNode switchValue() {
        if (SwitchFoldable.maybeIsInSwitch(this.condition())) {
            return ((IntegerEqualsNode)this.condition()).getX();
        }
        return null;
    }

    @Override
    public boolean isNonInitializedProfile() {
        return !ProfileData.ProfileSource.isTrusted(this.profileSource());
    }

    @Override
    public ProfileData.ProfileSource profileSource() {
        return this.profileData.getProfileSource();
    }

    @Override
    public ProfileData.BranchProbabilityData getProfileData() {
        return this.profileData;
    }

    @Override
    public int intKeyAt(int i) {
        assert (i == 0) : i;
        return ((IntegerEqualsNode)this.condition()).getY().asJavaConstant().asInt();
    }

    @Override
    public double keyProbability(int i) {
        assert (i == 0) : i;
        return this.getTrueSuccessorProbability();
    }

    @Override
    public AbstractBeginNode keySuccessor(int i) {
        assert (i == 0) : i;
        return this.trueSuccessor();
    }

    @Override
    public double defaultProbability() {
        return 1.0 - this.getTrueSuccessorProbability();
    }

    private boolean conditionalNodeOptimization(SimplifierTool tool) {
        if (this.trueSuccessor().next() instanceof AbstractEndNode && this.falseSuccessor().next() instanceof AbstractEndNode) {
            NodeView view;
            AbstractEndNode trueEnd = (AbstractEndNode)this.trueSuccessor().next();
            AbstractEndNode falseEnd = (AbstractEndNode)this.falseSuccessor().next();
            if (trueEnd.merge() != falseEnd.merge()) {
                return false;
            }
            if (!(trueEnd.merge() instanceof MergeNode)) {
                return false;
            }
            MergeNode merge = (MergeNode)trueEnd.merge();
            if (!merge.hasExactlyOneUsage() || merge.phis().count() != 1) {
                return false;
            }
            if (this.trueSuccessor().hasAnchored() || this.falseSuccessor().hasAnchored()) {
                return false;
            }
            if (this.falseSuccessor instanceof LoopExitNode && ((LoopExitNode)this.falseSuccessor).stateAfter != null) {
                return false;
            }
            PhiNode phi = merge.phis().first();
            ValueNode falseValue = phi.valueAt(falseEnd);
            ValueNode trueValue = phi.valueAt(trueEnd);
            ValueNode result = ConditionalNode.canonicalizeConditional(this.condition, trueValue, falseValue, phi.stamp(view = NodeView.from(tool)), view, tool);
            if (result != null) {
                if (result.graph() == null) {
                    result = this.graph().addOrUniqueWithInputs(result);
                }
                result = this.proxyReplacement(result);
                phi.setValueAt(trueEnd, result);
                this.removeThroughFalseBranch(tool, merge);
                return true;
            }
        }
        return false;
    }

    private void pushNodesThroughIf(SimplifierTool tool) {
        assert (this.trueSuccessor().hasNoUsages()) : Assertions.errorMessageContext("this", this, "trueSucc", this.trueSuccessor(), "trueSuccUsages", this.trueSuccessor().usages());
        assert (this.falseSuccessor().hasNoUsages()) : Assertions.errorMessageContext("this", this, "falseSucc", this.falseSuccessor(), "falseSuccUsages", this.falseSuccessor().usages());
        block0: while (true) {
            CompilationAlarm.checkProgress(this.graph());
            AbstractBeginNode trueSucc = this.trueSuccessor();
            AbstractBeginNode falseSucc = this.falseSuccessor();
            if (!(trueSucc instanceof BeginNode) || !(falseSucc instanceof BeginNode) || !(trueSucc.next() instanceof FixedWithNextNode) || !(falseSucc.next() instanceof FixedWithNextNode)) break;
            FixedWithNextNode trueNext = (FixedWithNextNode)trueSucc.next();
            FixedWithNextNode falseNext = (FixedWithNextNode)falseSucc.next();
            NodeClass<? extends Node> nodeClass = trueNext.getNodeClass();
            if (trueNext.getClass() != falseNext.getClass() || trueNext instanceof AbstractBeginNode || trueNext instanceof ControlFlowAnchored || trueNext instanceof MemoryAnchorNode || !nodeClass.equalInputs(trueNext, falseNext) || !trueNext.valueEquals(falseNext)) break;
            falseNext.replaceAtUsages(trueNext);
            this.graph().removeFixed(falseNext);
            GraphUtil.unlinkFixedNode(trueNext);
            this.graph().addBeforeFixed(this, trueNext);
            Iterator<Node> iterator = trueNext.usages().snapshot().iterator();
            while (true) {
                Node newNode;
                if (!iterator.hasNext()) continue block0;
                Node usage = iterator.next();
                if (!usage.isAlive()) continue;
                NodeClass<? extends Node> usageNodeClass = usage.getNodeClass();
                if (usageNodeClass.valueNumberable() && !usageNodeClass.isLeafNode() && (newNode = this.graph().findDuplicate(usage)) != null) {
                    usage.replaceAtUsagesAndDelete(newNode);
                }
                if (!usage.isAlive()) continue;
                tool.addToWorkList(usage);
            }
            break;
        }
    }

    private boolean checkForUnsignedCompare(SimplifierTool tool) {
        assert (this.trueSuccessor().hasNoUsages() && this.falseSuccessor().hasNoUsages()) : Assertions.errorMessageContext("this", this, "trueSucc", this.trueSuccessor, "trueSucc.usages", this.trueSuccessor.usages(), "falseSucc", this.falseSuccessor, "falseSucc.usages", this.falseSuccessor.usages());
        if (this.condition() instanceof IntegerLessThanNode) {
            NodeView view = NodeView.from(tool);
            IntegerLessThanNode lessThan = (IntegerLessThanNode)this.condition();
            Constant y = lessThan.getY().stamp(view).asConstant();
            if (y instanceof PrimitiveConstant && ((PrimitiveConstant)y).asLong() == 0L && this.falseSuccessor().next() instanceof IfNode) {
                IfNode ifNode2 = (IfNode)this.falseSuccessor().next();
                if (ifNode2.condition() instanceof IntegerLessThanNode) {
                    JavaConstant positive;
                    IntegerLessThanNode lessThan2 = (IntegerLessThanNode)ifNode2.condition();
                    AbstractBeginNode falseSucc = ifNode2.falseSuccessor();
                    AbstractBeginNode trueSucc = ifNode2.trueSuccessor();
                    IntegerBelowNode below = null;
                    if (lessThan2.getX() == lessThan.getX() && lessThan2.getY().stamp(view) instanceof IntegerStamp && ((IntegerStamp)lessThan2.getY().stamp(view)).isPositive() && IfNode.sameDestination(this.trueSuccessor(), ifNode2.falseSuccessor)) {
                        below = this.graph().unique(new IntegerBelowNode(lessThan2.getX(), lessThan2.getY()));
                        AbstractBeginNode tmp = falseSucc;
                        falseSucc = trueSucc;
                        trueSucc = tmp;
                    } else if (lessThan2.getY() == lessThan.getX() && IfNode.sameDestination(this.trueSuccessor(), ifNode2.trueSuccessor) && (positive = lessThan2.getX().asJavaConstant()) != null && positive.asLong() > 0L && positive.asLong() < positive.getJavaKind().getMaxValue()) {
                        ConstantNode newLimit = ConstantNode.forIntegerStamp(lessThan2.getX().stamp(view), positive.asLong() + 1L, this.graph());
                        below = this.graph().unique(new IntegerBelowNode(lessThan.getX(), newLimit));
                    }
                    if (below != null) {
                        try (DebugCloseable position = ifNode2.withNodeSourcePosition();){
                            ifNode2.setTrueSuccessor(null);
                            ifNode2.setFalseSuccessor(null);
                            IfNode newIfNode = this.graph().add(new IfNode(below, falseSucc, trueSucc, this.profileData.negated()));
                            tool.deleteBranch(this.trueSuccessor);
                            this.graph().removeSplit(this, this.falseSuccessor);
                            ifNode2.predecessor().replaceFirstSuccessor(ifNode2, newIfNode);
                            ifNode2.safeDelete();
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            } else if (y instanceof PrimitiveConstant && ((PrimitiveConstant)y).asLong() < 0L && this.falseSuccessor().next() instanceof IfNode) {
                IfNode ifNode2 = (IfNode)this.falseSuccessor().next();
                AbstractBeginNode falseSucc = ifNode2.falseSuccessor();
                AbstractBeginNode trueSucc = ifNode2.trueSuccessor();
                IntegerBelowNode below = null;
                if (ifNode2.condition() instanceof IntegerLessThanNode) {
                    long newLimitValue;
                    ValueNode x = lessThan.getX();
                    IntegerLessThanNode lessThan2 = (IntegerLessThanNode)ifNode2.condition();
                    Constant c2 = lessThan2.getY().stamp(view).asConstant();
                    if (lessThan2.getX() == x && c2 instanceof PrimitiveConstant && ((PrimitiveConstant)c2).asLong() > 0L && x.stamp(view).isCompatible(lessThan.getY().stamp(view)) && x.stamp(view).isCompatible(lessThan2.getY().stamp(view)) && IfNode.sameDestination(this.trueSuccessor(), ifNode2.falseSuccessor) && (newLimitValue = -((PrimitiveConstant)y).asLong() + ((PrimitiveConstant)c2).asLong()) > 0L && newLimitValue <= CodeUtil.maxValue((int)PrimitiveStamp.getBits(x.stamp(view)))) {
                        ConstantNode newLimit = ConstantNode.forIntegerStamp(x.stamp(view), newLimitValue, this.graph());
                        ConstantNode c1 = ConstantNode.forIntegerStamp(x.stamp(view), -((PrimitiveConstant)y).asLong(), this.graph());
                        ValueNode addNode = this.graph().addOrUniqueWithInputs(AddNode.create(x, c1, view));
                        below = this.graph().unique(new IntegerBelowNode(addNode, newLimit));
                    }
                }
                if (below != null) {
                    try (DebugCloseable position = ifNode2.withNodeSourcePosition();){
                        ifNode2.setTrueSuccessor(null);
                        ifNode2.setFalseSuccessor(null);
                        IfNode newIfNode = this.graph().add(new IfNode(below, trueSucc, falseSucc, this.profileData));
                        tool.deleteBranch(this.trueSuccessor);
                        this.graph().removeSplit(this, this.falseSuccessor);
                        ifNode2.predecessor().replaceFirstSuccessor(ifNode2, newIfNode);
                        ifNode2.safeDelete();
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    public static boolean sameDestination(AbstractBeginNode succ1, AbstractBeginNode succ2) {
        FixedNode next1 = succ1.next();
        FixedNode next2 = succ2.next();
        if (next1 instanceof AbstractEndNode && next2 instanceof AbstractEndNode) {
            AbstractEndNode end1 = (AbstractEndNode)next1;
            AbstractEndNode end2 = (AbstractEndNode)next2;
            if (end1.merge() == end2.merge()) {
                for (PhiNode phi : end1.merge().phis()) {
                    if (phi.valueAt(end1) == phi.valueAt(end2)) continue;
                    return false;
                }
                return true;
            }
        } else if (next1 instanceof DeoptimizeNode && next2 instanceof DeoptimizeNode) {
            DeoptimizeNode deopt1 = (DeoptimizeNode)next1;
            DeoptimizeNode deopt2 = (DeoptimizeNode)next2;
            if (deopt1.getReason() == deopt2.getReason() && deopt1.getAction() == deopt2.getAction() && deopt1.stateBefore() == deopt2.stateBefore()) {
                return true;
            }
        } else if (next1 instanceof LoopExitNode && next2 instanceof LoopExitNode) {
            LoopExitNode exit1 = (LoopExitNode)next1;
            LoopExitNode exit2 = (LoopExitNode)next2;
            if (exit1.loopBegin() == exit2.loopBegin() && exit1.stateAfter() == exit2.stateAfter() && exit1.stateAfter() == null && IfNode.sameDestination(exit1, exit2)) {
                return true;
            }
        } else if (next1 instanceof ReturnNode && next2 instanceof ReturnNode) {
            ReturnNode exit1 = (ReturnNode)next1;
            ReturnNode exit2 = (ReturnNode)next2;
            if (exit1.result() == exit2.result()) {
                return true;
            }
        }
        return false;
    }

    private static boolean prepareForSwap(SimplifierTool tool, LogicNode a, LogicNode b) {
        DebugContext debug = a.getDebug();
        if (a instanceof InstanceOfNode) {
            InstanceOfNode instanceOfA = (InstanceOfNode)a;
            if (b instanceof IsNullNode) {
                IsNullNode isNullNode = (IsNullNode)b;
                if (isNullNode.getValue() == instanceOfA.getValue()) {
                    debug.log("Can swap instanceof and isnull if");
                    return true;
                }
            } else if (b instanceof InstanceOfNode) {
                InstanceOfNode instanceOfB = (InstanceOfNode)b;
                if (!(instanceOfA.getValue() != instanceOfB.getValue() || instanceOfA.type().getType().isInterface() || instanceOfB.type().getType().isInterface() || instanceOfA.type().getType().isAssignableFrom(instanceOfB.type().getType()) || instanceOfB.type().getType().isAssignableFrom(instanceOfA.type().getType()))) {
                    debug.log("Can swap instanceof for types %s and %s", (Object)instanceOfA.type(), (Object)instanceOfB.type());
                    return true;
                }
            }
        } else if (a instanceof CompareNode) {
            CompareNode compareA = (CompareNode)a;
            Condition conditionA = compareA.condition().asCondition();
            if (compareA.unorderedIsTrue()) {
                return false;
            }
            if (b instanceof CompareNode) {
                CompareNode compareB = (CompareNode)b;
                if (compareA == compareB) {
                    debug.log("Same conditions => do not swap and leave the work for global value numbering.");
                    return false;
                }
                if (compareB.unorderedIsTrue()) {
                    return false;
                }
                Condition comparableCondition = null;
                Condition conditionB = compareB.condition().asCondition();
                if (compareB.getX() == compareA.getX() && compareB.getY() == compareA.getY()) {
                    comparableCondition = conditionB;
                } else if (compareB.getX() == compareA.getY() && compareB.getY() == compareA.getX()) {
                    comparableCondition = conditionB.mirror();
                }
                if (comparableCondition != null) {
                    if (conditionA.trueIsDisjoint(comparableCondition)) {
                        debug.log("Can swap disjoint coditions on same values: %s and %s", (Object)conditionA, (Object)comparableCondition);
                        return true;
                    }
                } else if (conditionA == Condition.EQ && conditionB == Condition.EQ) {
                    boolean canSwap = false;
                    if (compareA.getX() == compareB.getX() && IfNode.valuesDistinct(tool, compareA.getY(), compareB.getY())) {
                        canSwap = true;
                    } else if (compareA.getX() == compareB.getY() && IfNode.valuesDistinct(tool, compareA.getY(), compareB.getX())) {
                        canSwap = true;
                    } else if (compareA.getY() == compareB.getX() && IfNode.valuesDistinct(tool, compareA.getX(), compareB.getY())) {
                        canSwap = true;
                    } else if (compareA.getY() == compareB.getY() && IfNode.valuesDistinct(tool, compareA.getX(), compareB.getX())) {
                        canSwap = true;
                    }
                    if (canSwap) {
                        debug.log("Can swap equality condition with one shared and one disjoint value.");
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean valuesDistinct(SimplifierTool tool, ValueNode a, ValueNode b) {
        Boolean equal;
        if (a.isConstant() && b.isConstant() && (equal = tool.getConstantReflection().constantEquals(a.asConstant(), b.asConstant())) != null) {
            return equal == false;
        }
        NodeView view = NodeView.from(tool);
        Stamp stampA = a.stamp(view);
        Stamp stampB = b.stamp(view);
        return stampA.alwaysDistinct(stampB);
    }

    private boolean removeOrMaterializeIf(SimplifierTool tool) {
        FixedNode falseEnd;
        FixedNode trueEnd;
        AbstractMergeNode am;
        assert (this.trueSuccessor().hasNoUsages() && this.falseSuccessor().hasNoUsages()) : Assertions.errorMessageContext("this", this, "trueSucc", this.trueSuccessor, "trueSucc.usages", this.trueSuccessor.usages(), "falseSucc", this.falseSuccessor, "falseSucc.usages", this.falseSuccessor.usages());
        FixedWithNextNode blockingMerge = null;
        if (this.trueSuccessor().next() instanceof ReturnNode && this.falseSuccessor().next() instanceof AbstractEndNode) {
            am = ((AbstractEndNode)this.falseSuccessor.next()).merge();
            if (am instanceof MergeNode) {
                blockingMerge = (MergeNode)am;
            }
        } else if (this.falseSuccessor().next() instanceof ReturnNode && this.trueSuccessor().next() instanceof AbstractEndNode && (am = ((AbstractEndNode)this.trueSuccessor().next()).merge()) instanceof MergeNode) {
            blockingMerge = (MergeNode)am;
        }
        if (blockingMerge != null && blockingMerge.next() instanceof ReturnNode) {
            AbstractMergeNode.duplicateReturnThroughMerge((MergeNode)blockingMerge);
        }
        if (this.trueSuccessor().next() instanceof AbstractEndNode && this.falseSuccessor().next() instanceof AbstractEndNode) {
            trueEnd = (AbstractEndNode)this.trueSuccessor().next();
            falseEnd = (AbstractEndNode)this.falseSuccessor().next();
            AbstractMergeNode merge = ((AbstractEndNode)trueEnd).merge();
            if (this.falseSuccessor instanceof LoopExitNode && ((LoopExitNode)this.falseSuccessor).stateAfter != null) {
                return false;
            }
            if (merge == ((AbstractEndNode)falseEnd).merge() && this.trueSuccessor().anchored().isEmpty() && this.falseSuccessor().anchored().isEmpty()) {
                PhiNode singlePhi = null;
                int distinct = 0;
                for (PhiNode phi : merge.phis()) {
                    ValueNode falseValue;
                    ValueNode trueValue = phi.valueAt((AbstractEndNode)trueEnd);
                    if (trueValue == (falseValue = phi.valueAt((AbstractEndNode)falseEnd))) continue;
                    ++distinct;
                    singlePhi = phi;
                }
                if (distinct == 0) {
                    this.removeThroughFalseBranch(tool, merge);
                    return true;
                }
                if (distinct == 1) {
                    ValueNode value;
                    ValueNode falseValue;
                    assert (singlePhi != null);
                    ValueNode trueValue = singlePhi.valueAt((AbstractEndNode)trueEnd);
                    ValueNode conditional = this.canonicalizeConditionalCascade(tool, trueValue, falseValue = singlePhi.valueAt((AbstractEndNode)falseEnd));
                    if (conditional != null) {
                        conditional = this.proxyReplacement(conditional);
                        singlePhi.setValueAt((AbstractEndNode)trueEnd, conditional);
                        this.removeThroughFalseBranch(tool, merge);
                        return true;
                    }
                    if (this.condition instanceof IsNullNode && trueValue.isJavaConstant() && trueValue.asJavaConstant().isDefaultForKind() && merge instanceof MergeNode && falseValue == (value = ((IsNullNode)this.condition).getValue()) && singlePhi.stamp(NodeView.DEFAULT).equals(value.stamp(NodeView.DEFAULT))) {
                        singlePhi.setValueAt((AbstractEndNode)trueEnd, falseValue);
                        this.removeThroughFalseBranch(tool, merge);
                        return true;
                    }
                }
            }
        }
        if (this.trueSuccessor().next() instanceof ReturnNode && this.falseSuccessor().next() instanceof ReturnNode) {
            trueEnd = (ReturnNode)this.trueSuccessor().next();
            falseEnd = (ReturnNode)this.falseSuccessor().next();
            ValueNode trueValue = ((ReturnNode)trueEnd).result();
            ValueNode falseValue = ((ReturnNode)falseEnd).result();
            ValueNode value = null;
            boolean needsProxy = false;
            if (trueValue != null) {
                if (trueValue == falseValue) {
                    value = trueValue;
                } else {
                    value = this.canonicalizeConditionalCascade(tool, trueValue, falseValue);
                    if (value == null) {
                        return false;
                    }
                    needsProxy = true;
                }
            }
            if (this.trueSuccessor() instanceof LoopExitNode) {
                FrameState stateAfter = ((LoopExitNode)this.trueSuccessor()).stateAfter();
                LoopBeginNode loopBegin = ((LoopExitNode)this.trueSuccessor()).loopBegin();
                assert (loopBegin == ((LoopExitNode)this.falseSuccessor()).loopBegin()) : Assertions.errorMessageContext("this", this, "trueSucc", this.trueSuccessor, "trueSucc.usages", this.trueSuccessor.usages(), "falseSucc", this.falseSuccessor, "falseSucc.usages", this.falseSuccessor.usages(), "loopBegin", loopBegin);
                LoopExitNode loopExitNode = this.graph().add(new LoopExitNode(loopBegin));
                loopExitNode.setStateAfter(stateAfter);
                this.graph().addBeforeFixed(this, loopExitNode);
                if (this.graph().isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) && needsProxy) {
                    value = this.graph().addOrUnique(new ValueProxyNode(value, loopExitNode));
                }
            }
            ReturnNode newReturn = this.graph().add(new ReturnNode(value));
            this.replaceAtPredecessor(newReturn);
            GraphUtil.killCFG(this);
            return true;
        }
        return false;
    }

    private ValueNode proxyReplacement(ValueNode replacement) {
        if (this.graph().isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) && this.trueSuccessor instanceof LoopExitNode && this.falseSuccessor instanceof LoopExitNode) {
            assert (((LoopExitNode)this.trueSuccessor).loopBegin() == ((LoopExitNode)this.falseSuccessor).loopBegin()) : Assertions.errorMessageContext("this", this, "trueSucc", this.trueSuccessor, "falseSucc", this.falseSuccessor);
            if (this.falseSuccessor.anchored().isEmpty() && this.falseSuccessor.hasUsages()) {
                for (Node n : this.falseSuccessor.usages().snapshot()) {
                    assert (n instanceof ProxyNode) : Assertions.errorMessage(n);
                    ((ProxyNode)n).setProxyPoint((LoopExitNode)this.trueSuccessor);
                }
            }
            assert (this.trueSuccessor.anchored().isEmpty() && this.falseSuccessor.hasNoUsages()) : Assertions.errorMessageContext("this", this, "trueSucc", this.trueSuccessor, "trueSucc.usages", this.trueSuccessor.usages(), "falseSucc", this.falseSuccessor, "falseSucc.usages", this.falseSuccessor.usages());
            return this.graph().addOrUnique(new ValueProxyNode(replacement, (LoopExitNode)this.trueSuccessor));
        }
        return replacement;
    }

    protected void removeThroughFalseBranch(SimplifierTool tool, AbstractMergeNode merge) {
        assert (!(this.falseSuccessor instanceof LoopExitNode) || ((LoopExitNode)this.falseSuccessor).stateAfter == null);
        AbstractBeginNode trueBegin = this.trueSuccessor();
        LogicNode conditionNode = this.condition();
        this.graph().removeSplitPropagate(this, trueBegin);
        tool.addToWorkList(trueBegin);
        if (conditionNode != null) {
            GraphUtil.tryKillUnused(conditionNode);
        }
        if (merge.isAlive() && merge.forwardEndCount() > 1) {
            for (FixedNode fixedNode : merge.forwardEnds()) {
                Node cur;
                for (cur = fixedNode; cur != null && cur.predecessor() instanceof BeginNode; cur = cur.predecessor()) {
                }
                if (cur == null || !(cur.predecessor() instanceof IfNode)) continue;
                tool.addToWorkList(cur.predecessor());
            }
        }
    }

    private ValueNode canonicalizeConditionalViaImplies(ValueNode trueValue, ValueNode falseValue) {
        TriState result;
        ValueNode collapsedTrue = trueValue;
        ValueNode collapsedFalse = falseValue;
        boolean simplify = false;
        if (trueValue instanceof ConditionalNode && (result = this.condition().implies(false, ((ConditionalNode)trueValue).condition())).isKnown()) {
            simplify = true;
            ValueNode valueNode = collapsedTrue = result.toBoolean() ? ((ConditionalNode)trueValue).trueValue() : ((ConditionalNode)trueValue).falseValue();
        }
        if (falseValue instanceof ConditionalNode && (result = this.condition().implies(true, ((ConditionalNode)falseValue).condition())).isKnown()) {
            simplify = true;
            ValueNode valueNode = collapsedFalse = result.toBoolean() ? ((ConditionalNode)falseValue).trueValue() : ((ConditionalNode)falseValue).falseValue();
        }
        if (simplify) {
            return this.graph().unique(new ConditionalNode(this.condition(), collapsedTrue, collapsedFalse));
        }
        return null;
    }

    private List<Node> getNodesForBlock(AbstractBeginNode successor) {
        StructuredGraph.ScheduleResult schedule = this.graph().getLastSchedule();
        if (schedule == null) {
            return null;
        }
        if (schedule.getCFG().getNodeToBlock().isNew(successor)) {
            return null;
        }
        HIRBlock block = schedule.getCFG().blockFor(successor);
        if (block == null) {
            return null;
        }
        return schedule.nodesFor(block);
    }

    private boolean isSafeConditionalInput(ValueNode value, AbstractBeginNode successor) {
        assert (successor.hasNoUsages());
        if (value.isConstant() || this.condition.inputs().contains(value)) {
            return true;
        }
        if (this.graph().isAfterStage(GraphState.StageFlag.FIXED_READS)) {
            if (value instanceof ParameterNode) {
                return true;
            }
            if (value instanceof FixedNode) {
                List<Node> nodes = this.getNodesForBlock(successor);
                return nodes != null && nodes.size() == 2;
            }
        }
        return false;
    }

    private ValueNode canonicalizeConditionalCascade(SimplifierTool tool, ValueNode trueValue, ValueNode falseValue) {
        if (trueValue.getStackKind() != falseValue.getStackKind()) {
            return null;
        }
        if (trueValue.getStackKind() != JavaKind.Int && trueValue.getStackKind() != JavaKind.Long) {
            return null;
        }
        if (this.isSafeConditionalInput(trueValue, this.trueSuccessor) && this.isSafeConditionalInput(falseValue, this.falseSuccessor)) {
            return this.graph().unique(new ConditionalNode(this.condition(), trueValue, falseValue));
        }
        ValueNode value = this.canonicalizeConditionalViaImplies(trueValue, falseValue);
        if (value != null) {
            return value;
        }
        if (this.graph().isBeforeStage(GraphState.StageFlag.EXPAND_LOGIC)) {
            boolean negateCondition;
            ConditionalNode conditional = null;
            ValueNode constant = null;
            if (trueValue instanceof ConditionalNode && falseValue.isConstant()) {
                conditional = (ConditionalNode)trueValue;
                constant = falseValue;
                negateCondition = true;
            } else if (falseValue instanceof ConditionalNode && trueValue.isConstant()) {
                conditional = (ConditionalNode)falseValue;
                constant = trueValue;
                negateCondition = false;
            } else {
                return null;
            }
            boolean negateConditionalCondition = false;
            ValueNode otherValue = null;
            if (constant == conditional.trueValue()) {
                otherValue = conditional.falseValue();
                negateConditionalCondition = false;
            } else if (constant == conditional.falseValue()) {
                otherValue = conditional.trueValue();
                negateConditionalCondition = true;
            }
            if (otherValue != null && otherValue.isConstant()) {
                ProfileData.BranchProbabilityData shortCutProbability = this.trueSuccessorProfile();
                LogicNode newCondition = LogicNode.or(this.condition(), negateCondition, conditional.condition(), negateConditionalCondition, shortCutProbability);
                return this.graph().unique(new ConditionalNode(newCondition, constant, otherValue));
            }
            if (constant.isJavaConstant() && conditional.trueValue().isJavaConstant() && conditional.falseValue().isJavaConstant() && this.condition() instanceof CompareNode && conditional.condition() instanceof CompareNode) {
                boolean sameVars;
                CompareNode condition1 = (CompareNode)this.condition();
                Condition cond1 = condition1.condition().asCondition();
                if (negateCondition) {
                    cond1 = cond1.negate();
                }
                CompareNode condition2 = (CompareNode)conditional.condition();
                Condition cond2 = condition2.condition().asCondition();
                ValueNode x = condition1.getX();
                ValueNode y = condition1.getY();
                ValueNode x2 = condition2.getX();
                ValueNode y2 = condition2.getY();
                boolean bl = sameVars = x == x2 && y == y2;
                if (!sameVars && x == y2 && y == x2) {
                    sameVars = true;
                    cond2 = cond2.mirror();
                }
                if (sameVars) {
                    JavaKind stackKind = conditional.trueValue().stamp(NodeView.from(tool)).getStackKind();
                    assert (!stackKind.isNumericFloat());
                    long c1 = constant.asJavaConstant().asLong();
                    long c2 = conditional.trueValue().asJavaConstant().asLong();
                    long c3 = conditional.falseValue().asJavaConstant().asLong();
                    if ((cond2 = cond2.join(cond1.negate())) == null) {
                        return null;
                    }
                    Condition cond3 = cond1.negate().join(cond2.negate());
                    if (cond3 == null) {
                        return null;
                    }
                    boolean unsigned = cond1.isUnsigned() || cond2.isUnsigned();
                    Stamp xStamp = x.stamp(NodeView.from(tool));
                    boolean floatingPoint = xStamp instanceof FloatStamp;
                    Stamp yStamp = y.stamp(NodeView.from(tool));
                    assert (!floatingPoint || yStamp instanceof FloatStamp) : Assertions.errorMessageContext("this", this, "xStamp", xStamp, "yStamp", yStamp);
                    assert (!floatingPoint || !unsigned) : Assertions.errorMessageContext("this", this, "xStamp", xStamp, "yStamp", yStamp, "cond1", (Object)cond1, "cond2", (Object)cond2);
                    long expected1 = IfNode.expectedConstantForNormalize(cond1);
                    long expected2 = IfNode.expectedConstantForNormalize(cond2);
                    long expected3 = IfNode.expectedConstantForNormalize(cond3);
                    if (c1 != expected1 || c2 != expected2 || c3 != expected3) {
                        if (c1 == 0L - expected1 && c2 == 0L - expected2 && c3 == 0L - expected3) {
                            ValueNode tmp = x;
                            x = y;
                            y = tmp;
                        } else {
                            return null;
                        }
                    }
                    if (floatingPoint) {
                        boolean unorderedLess = false;
                        if (((FloatStamp)x.stamp).canBeNaN() || ((FloatStamp)y.stamp).canBeNaN()) {
                            long unorderedValue;
                            long l = condition1.unorderedIsTrue() ? c1 : (unorderedValue = condition2.unorderedIsTrue() ? c2 : c3);
                            if (unorderedValue == 0L) {
                                return null;
                            }
                            unorderedLess = unorderedValue == -1L;
                        }
                        return this.graph().unique(new FloatNormalizeCompareNode(x, y, stackKind, unorderedLess));
                    }
                    return this.graph().unique(new IntegerNormalizeCompareNode(x, y, stackKind, unsigned));
                }
            }
        }
        return null;
    }

    private static long expectedConstantForNormalize(Condition condition) {
        if (condition == Condition.EQ) {
            return 0L;
        }
        if (condition == Condition.LT || condition == Condition.BT) {
            return -1L;
        }
        assert (condition == Condition.GT || condition == Condition.AT) : condition;
        return 1L;
    }

    private boolean removeIntermediateMaterialization(SimplifierTool tool) {
        if (!(this.predecessor() instanceof AbstractMergeNode) || this.predecessor() instanceof LoopBeginNode) {
            return false;
        }
        AbstractMergeNode merge = (AbstractMergeNode)this.predecessor();
        if (!(this.condition() instanceof CompareNode)) {
            return false;
        }
        CompareNode compare = (CompareNode)this.condition();
        if (compare.getUsageCount() != 1) {
            return false;
        }
        NodeIterable<Node> mergeUsages = merge.usages();
        if (mergeUsages.count() != 1) {
            return false;
        }
        Node singleUsage = mergeUsages.first();
        if (!(singleUsage instanceof ValuePhiNode) || singleUsage != compare.getX() && singleUsage != compare.getY()) {
            return false;
        }
        if (this.trueSuccessor().isUsedAsGuardInput() || this.falseSuccessor().isUsedAsGuardInput()) {
            return false;
        }
        ValuePhiNode phi = (ValuePhiNode)singleUsage;
        NodeIterable<Node> phiUsages = phi.usages();
        for (Node usage : phiUsages) {
            ValueProxyNode proxy;
            if (usage == compare || usage == merge.stateAfter() || usage instanceof ValueProxyNode && ((proxy = (ValueProxyNode)usage).proxyPoint() == this.trueSuccessor || proxy.proxyPoint() == this.falseSuccessor)) continue;
            return false;
        }
        List mergePredecessors = merge.cfgPredecessors().snapshot();
        assert (phi.valueCount() == merge.forwardEndCount()) : Assertions.errorMessage(phi, phi.values, merge, merge.forwardEnds());
        Constant[] xs = IfNode.constantValues(compare.getX(), merge, false);
        Constant[] ys = IfNode.constantValues(compare.getY(), merge, false);
        if (xs == null || ys == null) {
            return false;
        }
        if (merge.stateAfter() != null && !GraphUtil.mayRemoveSplit(this)) {
            return false;
        }
        boolean[] conditions = new boolean[xs.length];
        Stamp compareStamp = compare.getX().stamp(NodeView.DEFAULT);
        for (int i = 0; i < xs.length; ++i) {
            TriState foldedCondition = compare.condition().foldCondition(compareStamp, xs[i], ys[i], tool.getConstantReflection(), compare.unorderedIsTrue());
            if (foldedCondition.isUnknown()) {
                return false;
            }
            conditions[i] = foldedCondition.toBoolean();
        }
        ArrayList<EndNode> falseEnds = new ArrayList<EndNode>(mergePredecessors.size());
        ArrayList<EndNode> trueEnds = new ArrayList<EndNode>(mergePredecessors.size());
        EconomicMap phiValues = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)mergePredecessors.size());
        AbstractBeginNode oldFalseSuccessor = this.falseSuccessor();
        AbstractBeginNode oldTrueSuccessor = this.trueSuccessor();
        this.setFalseSuccessor(null);
        this.setTrueSuccessor(null);
        Iterator ends = mergePredecessors.iterator();
        for (int i = 0; i < xs.length; ++i) {
            EndNode endNode = (EndNode)ends.next();
            phiValues.put((Object)endNode, (Object)phi.valueAt(endNode));
            if (conditions[i]) {
                trueEnds.add(endNode);
                continue;
            }
            falseEnds.add(endNode);
        }
        assert (!ends.hasNext());
        assert (falseEnds.size() + trueEnds.size() == xs.length) : Assertions.errorMessage(falseEnds, trueEnds, xs);
        if (this.getTrueSuccessorProbability() == 0.0) {
            for (AbstractEndNode abstractEndNode : trueEnds) {
                IfNode.propagateZeroProbability(abstractEndNode);
            }
        }
        if (this.getTrueSuccessorProbability() == 1.0) {
            for (AbstractEndNode abstractEndNode : falseEnds) {
                IfNode.propagateZeroProbability(abstractEndNode);
            }
        }
        if (this.getProfileData().getProfileSource().isInjected()) {
            IfNode.propagateInjectedProfile(this.getProfileData(), trueEnds, falseEnds);
        }
        this.connectEnds(falseEnds, phi, (EconomicMap<AbstractEndNode, ValueNode>)phiValues, oldFalseSuccessor, merge, tool);
        this.connectEnds(trueEnds, phi, (EconomicMap<AbstractEndNode, ValueNode>)phiValues, oldTrueSuccessor, merge, tool);
        if (falseEnds.isEmpty()) {
            GraphUtil.killCFG(oldFalseSuccessor);
        }
        if (trueEnds.isEmpty()) {
            GraphUtil.killCFG(oldTrueSuccessor);
        }
        GraphUtil.killCFG(merge);
        assert (!merge.isAlive()) : merge;
        assert (!phi.isAlive()) : phi;
        assert (!compare.isAlive()) : compare;
        assert (!this.isAlive()) : this;
        return true;
    }

    private static void propagateZeroProbability(FixedNode startNode) {
        FixedNode prev = null;
        for (FixedNode node : GraphUtil.predecessorIterable(startNode)) {
            if (node instanceof IfNode) {
                IfNode ifNode = (IfNode)node;
                if (ifNode.trueSuccessor() == prev) {
                    if (ifNode.getTrueSuccessorProbability() == 0.0) {
                        return;
                    }
                    if (ifNode.getTrueSuccessorProbability() == 1.0) continue;
                    ifNode.setTrueSuccessorProbability(BranchProbabilityNode.NEVER_TAKEN_PROFILE);
                    return;
                }
                if (ifNode.falseSuccessor() == prev) {
                    if (ifNode.getTrueSuccessorProbability() == 1.0) {
                        return;
                    }
                    if (ifNode.getTrueSuccessorProbability() == 0.0) continue;
                    ifNode.setTrueSuccessorProbability(BranchProbabilityNode.ALWAYS_TAKEN_PROFILE);
                    return;
                }
                throw new GraalError("Illegal state");
            }
            if (node instanceof AbstractMergeNode && !(node instanceof LoopBeginNode)) {
                for (AbstractEndNode endNode : ((AbstractMergeNode)node).cfgPredecessors()) {
                    IfNode.propagateZeroProbability(endNode);
                }
                return;
            }
            prev = node;
        }
    }

    private static void propagateInjectedProfile(ProfileData.BranchProbabilityData profile, List<EndNode> trueEnds, List<EndNode> falseEnds) {
        if (trueEnds.size() >= 1 && falseEnds.size() >= 1 && (trueEnds.size() == 1 || falseEnds.size() == 1)) {
            EndNode singleTrueEnd = trueEnds.size() == 1 ? trueEnds.get(0) : null;
            EndNode singleFalseEnd = falseEnds.size() == 1 ? falseEnds.get(0) : null;
            IfNode.propagateInjectedProfile(profile, singleTrueEnd, singleFalseEnd);
        }
    }

    private static void propagateInjectedProfile(ProfileData.BranchProbabilityData profile, EndNode singleTrueEnd, EndNode singleFalseEnd) {
        IfNode foundIf = null;
        FixedNode prev = null;
        boolean viaFalseEnd = false;
        if (singleTrueEnd != null) {
            for (FixedNode node : GraphUtil.predecessorIterable(singleTrueEnd)) {
                if (node instanceof IfNode) {
                    if (ProfileData.ProfileSource.isTrusted(((IfNode)node).profileSource())) break;
                    foundIf = (IfNode)node;
                    break;
                }
                if (node instanceof AbstractMergeNode || node instanceof LoopExitNode) break;
                prev = node;
            }
        }
        if (singleFalseEnd != null) {
            FixedNode falsePrev = null;
            for (FixedNode node : GraphUtil.predecessorIterable(singleFalseEnd)) {
                if (node instanceof IfNode) {
                    if (foundIf == node) break;
                    if (foundIf == null) {
                        foundIf = (IfNode)node;
                        prev = falsePrev;
                        viaFalseEnd = true;
                        break;
                    }
                    return;
                }
                if (node instanceof AbstractMergeNode || node instanceof LoopExitNode) break;
                falsePrev = node;
            }
        }
        if (foundIf != null && !ProfileData.ProfileSource.isTrusted(foundIf.profileSource())) {
            boolean negated;
            if (foundIf.trueSuccessor() == prev) {
                negated = viaFalseEnd;
            } else if (foundIf.falseSuccessor() == prev) {
                negated = !viaFalseEnd;
            } else {
                throw new GraalError("Illegal state");
            }
            foundIf.setTrueSuccessorProbability(negated ? profile.negated() : profile);
        }
    }

    private void connectEnds(List<EndNode> ends, ValuePhiNode phi, EconomicMap<AbstractEndNode, ValueNode> phiValues, AbstractBeginNode successor, AbstractMergeNode oldMerge, SimplifierTool tool) {
        if (!ends.isEmpty()) {
            ValueProxyNode valueProxy = null;
            if (successor instanceof LoopExitNode) {
                for (Node usage : phi.usages()) {
                    if (!(usage instanceof ValueProxyNode) || ((ValueProxyNode)usage).proxyPoint() != successor) continue;
                    valueProxy = (ValueProxyNode)usage;
                }
            }
            ValueProxyNode proxy = valueProxy;
            if (ends.size() == 1) {
                AbstractEndNode end = ends.get(0);
                if (proxy != null) {
                    phi.replaceAtUsages((Node)phiValues.get((Object)end), (Node n) -> n == proxy);
                }
                ((FixedWithNextNode)end.predecessor()).setNext(successor);
                oldMerge.removeEnd(end);
                GraphUtil.killCFG(end);
            } else {
                NodeView view = NodeView.from(tool);
                AbstractMergeNode newMerge = this.graph().add(new MergeNode());
                final PhiNode oldPhi = (PhiNode)oldMerge.usages().first();
                final PhiNode newPhi = this.graph().addWithoutUnique(new ValuePhiNode(oldPhi.stamp(view), newMerge));
                if (proxy != null) {
                    phi.replaceAtUsages((Node)newPhi, (Node n) -> n == proxy);
                }
                for (EndNode end : ends) {
                    newPhi.addInput((ValueNode)phiValues.get((Object)end));
                    newMerge.addForwardEnd(end);
                }
                FrameState stateAfter = oldMerge.stateAfter();
                if (stateAfter != null) {
                    stateAfter = stateAfter.duplicateWithVirtualState();
                    stateAfter.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(this){

                        @Override
                        public void apply(Node from, Position p) {
                            ValueNode to = (ValueNode)p.get(from);
                            if (to == oldPhi) {
                                p.set(from, newPhi);
                            }
                        }
                    });
                    newMerge.setStateAfter(stateAfter);
                }
                newMerge.setNext(successor);
            }
            tool.addToWorkList(successor);
        }
    }

    public static Constant[] constantValues(ValueNode node, AbstractMergeNode merge, boolean allowNull) {
        PhiNode phi;
        if (node.isConstant()) {
            Object[] result = new Constant[merge.forwardEndCount()];
            Arrays.fill(result, node.asConstant());
            return result;
        }
        if (node instanceof PhiNode && (phi = (PhiNode)node).merge() == merge && phi instanceof ValuePhiNode && phi.valueCount() == merge.forwardEndCount()) {
            Constant[] result = new Constant[merge.forwardEndCount()];
            int i = 0;
            for (ValueNode n : phi.values()) {
                if (!allowNull && !n.isConstant()) {
                    return null;
                }
                result[i++] = n.asConstant();
            }
            return result;
        }
        return null;
    }

    @Override
    public AbstractBeginNode getPrimarySuccessor() {
        return null;
    }

    public AbstractBeginNode getSuccessor(boolean result) {
        return result ? this.trueSuccessor() : this.falseSuccessor();
    }

    @Override
    public boolean setProbability(AbstractBeginNode successor, ProfileData.BranchProbabilityData profileData) {
        if (successor == this.trueSuccessor()) {
            this.setTrueSuccessorProbability(profileData);
            return true;
        }
        if (successor == this.falseSuccessor()) {
            this.setTrueSuccessorProbability(profileData.negated());
            return true;
        }
        return false;
    }

    @Override
    public int getSuccessorCount() {
        return 2;
    }

    public boolean successorWillBeEliminated(AbstractBeginNode successor) {
        assert (successor == this.trueSuccessor || successor == this.falseSuccessor) : Assertions.errorMessageContext("this", this, "succ", successor);
        if (this.condition instanceof LogicConstantNode) {
            boolean trueSuccessorWillBeEliminated;
            LogicConstantNode c = (LogicConstantNode)this.condition;
            boolean bl = trueSuccessorWillBeEliminated = !c.getValue();
            return trueSuccessorWillBeEliminated ? successor == this.trueSuccessor : successor == this.falseSuccessor;
        }
        return false;
    }

    public static enum NodeColor {
        NONE,
        CONDITION_USAGE,
        TRUE_BRANCH,
        FALSE_BRANCH,
        PHI_MIXED,
        MIXED;

    }
}

