/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.Invokable;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.util.CollectionsUtil;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;

public class InliningLog {
    private static final String TREE_NODE = "\u251c\u2500\u2500";
    private static final String LAST_TREE_NODE = "\u2514\u2500\u2500";
    private Callsite root;
    private final EconomicMap<Invokable, Callsite> leaves;
    private final UpdateScope noUpdates = new UpdateScope((oldNode, newNode) -> {});
    private UpdateScope currentUpdateScope = null;
    private RootScope currentRootScope = null;

    public InliningLog(ResolvedJavaMethod rootMethod) {
        this.root = new Callsite(null, null, null, rootMethod, -1, false, null);
        this.leaves = EconomicMap.create();
    }

    void addDecision(Invokable invoke, boolean positive, String phase, EconomicMap<Node, Node> replacements, InliningLog calleeLog, ResolvedJavaMethod inlineeMethod, String reason, Object ... args) {
        assert (this.leaves.containsKey((Object)invoke)) : invoke;
        assert (!positive || Objects.isNull(replacements) == Objects.isNull(calleeLog)) : Assertions.errorMessage(positive, replacements, calleeLog);
        Callsite callsite = (Callsite)this.leaves.get((Object)invoke);
        callsite.addDecision(new Decision(positive, String.format(reason, args), phase, inlineeMethod));
        if (positive) {
            this.leaves.removeKey((Object)invoke);
            if (calleeLog == null) {
                return;
            }
            EconomicMap mapping = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
            for (Callsite calleeChild : calleeLog.root.children) {
                InliningLog.copyTree(callsite, calleeChild, replacements, (EconomicMap<Callsite, Callsite>)mapping);
            }
            MapCursor entries = calleeLog.leaves.getEntries();
            while (entries.advance()) {
                FixedNode invokeFromCallee = ((Invokable)entries.getKey()).asFixedNodeOrNull();
                Callsite callsiteFromCallee = (Callsite)entries.getValue();
                if (invokeFromCallee == null || invokeFromCallee.isDeleted()) continue;
                Invokable inlinedInvokeFromCallee = (Invokable)replacements.get((Object)invokeFromCallee);
                Callsite descendant = (Callsite)mapping.get((Object)callsiteFromCallee);
                this.leaves.put((Object)inlinedInvokeFromCallee, (Object)descendant);
            }
        }
    }

    public void addLog(UnmodifiableEconomicMap<Node, Node> replacements, InliningLog replacementLog) {
        if (replacementLog != null) {
            EconomicMap mapping = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
            for (Callsite calleeChild : replacementLog.root.children) {
                InliningLog.copyTree(this.root, calleeChild, replacements, (EconomicMap<Callsite, Callsite>)mapping);
            }
            MapCursor entries = replacementLog.leaves.getEntries();
            while (entries.advance()) {
                FixedNode replacementInvoke = ((Invokable)entries.getKey()).asFixedNodeOrNull();
                Callsite replacementCallsite = (Callsite)entries.getValue();
                if (replacementInvoke == null || replacementInvoke.isDeleted()) continue;
                Invokable invoke = (Invokable)replacements.get((Object)replacementInvoke);
                Callsite callsite = (Callsite)mapping.get((Object)replacementCallsite);
                this.leaves.put((Object)invoke, (Object)callsite);
            }
        }
    }

    public void replaceLog(UnmodifiableEconomicMap<Node, Node> replacements, InliningLog replacementLog) {
        assert (this.root.decisions.isEmpty());
        assert (this.root.children.isEmpty());
        assert (this.leaves.isEmpty());
        EconomicMap mapping = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        this.root = InliningLog.copyTree(null, replacementLog.root, replacements, (EconomicMap<Callsite, Callsite>)mapping);
        MapCursor replacementEntries = replacementLog.leaves.getEntries();
        while (replacementEntries.advance()) {
            FixedNode replacementInvoke = ((Invokable)replacementEntries.getKey()).asFixedNodeOrNull();
            Callsite replacementSite = (Callsite)replacementEntries.getValue();
            if (replacementInvoke == null || !replacementInvoke.isAlive()) continue;
            Invokable invoke = (Invokable)replacements.get((Object)replacementInvoke);
            Callsite site = (Callsite)mapping.get((Object)replacementSite);
            this.leaves.put((Object)invoke, (Object)site);
        }
    }

    private static Callsite copyTree(Callsite parent, Callsite replacementSite, UnmodifiableEconomicMap<Node, Node> replacements, EconomicMap<Callsite, Callsite> mapping) {
        FixedNode replacementSiteInvoke;
        Invokable invoke = null;
        if (replacementSite.invoke != null && (replacementSiteInvoke = replacementSite.invoke.asFixedNodeOrNull()) != null && replacementSiteInvoke.isAlive()) {
            invoke = (Invokable)replacements.get((Object)replacementSiteInvoke);
        }
        Callsite originalCallsite = replacementSite.originalCallsite == null ? null : (Callsite)mapping.get((Object)replacementSite.originalCallsite);
        Callsite site = new Callsite(parent, originalCallsite, invoke, replacementSite.target, replacementSite.bci, replacementSite.indirect, replacementSite.targetTypeProfile);
        site.decisions.addAll(replacementSite.decisions);
        mapping.put((Object)replacementSite, (Object)site);
        for (Callsite replacementChild : replacementSite.children) {
            InliningLog.copyTree(site, replacementChild, replacements, mapping);
        }
        return site;
    }

    public void checkInvariants(StructuredGraph graph) {
        if (!Assertions.assertionsEnabled()) {
            return;
        }
        for (Invoke invoke : graph.getInvokes()) {
            assert (this.leaves.containsKey((Object)invoke)) : "Invoke " + String.valueOf(invoke) + " not contained in the leaves.";
        }
        this.checkParentPointers();
    }

    private void checkParentPointers() {
        assert (this.root.parent == null) : "Non-null parent of root: " + String.valueOf(this.root.parent);
        if (Assertions.assertionsEnabled()) {
            InliningLog.checkParentPointers(this.root);
        }
    }

    private static void checkParentPointers(Callsite site) {
        for (Callsite child : site.children) {
            assert (site == child.parent) : "Callsite " + String.valueOf(site) + " with child " + String.valueOf(child) + " has an invalid parent pointer " + String.valueOf(child.parent);
            InliningLog.checkParentPointers(child);
        }
    }

    public BiConsumer<Invokable, Invokable> getUpdateScope() {
        if (this.currentUpdateScope == null) {
            return null;
        }
        return this.currentUpdateScope.getUpdater();
    }

    public UpdateScope openUpdateScope(BiConsumer<Invokable, Invokable> updater) {
        UpdateScope scope = new UpdateScope(updater);
        scope.activate();
        return scope;
    }

    public static UpdateScope openDefaultUpdateScope(InliningLog log) {
        if (log == null) {
            return null;
        }
        log.noUpdates.activate();
        return log.noUpdates;
    }

    public static UpdateScope openUpdateScopeTrackingOriginalCallsites(InliningLog inliningLog) {
        if (inliningLog == null) {
            return null;
        }
        return inliningLog.openUpdateScope((originalInvoke, newInvoke) -> {
            if (originalInvoke != null) {
                assert (!inliningLog.containsLeafCallsite((Invokable)newInvoke));
                inliningLog.trackDuplicatedCallsite((Invokable)originalInvoke, (Invokable)newInvoke, (Callsite)inliningLog.leaves.get(originalInvoke));
            }
        });
    }

    public static UpdateScope openUpdateScopeTrackingReplacement(InliningLog inliningLog, Invokable replacedInvoke) {
        if (inliningLog == null || inliningLog.currentUpdateScope == inliningLog.noUpdates) {
            return null;
        }
        return inliningLog.openUpdateScope((nullInvoke, replacementInvoke) -> {
            assert (nullInvoke == null);
            assert (!inliningLog.leaves.containsKey(replacementInvoke));
            Callsite callsite = (Callsite)inliningLog.leaves.get((Object)replacedInvoke);
            callsite.invoke = replacementInvoke;
            inliningLog.leaves.removeKey((Object)replacedInvoke);
            inliningLog.leaves.put(replacementInvoke, (Object)callsite);
        });
    }

    public RootScope openRootScope(ResolvedJavaMethod callerMethod, ResolvedJavaMethod target, int bci) {
        return this.openRootScope(new PlaceholderInvokable(callerMethod, target, bci));
    }

    public RootScope openRootScope(Invokable invoke) {
        if (!this.leaves.containsKey((Object)invoke)) {
            this.trackNewCallsite(invoke);
        }
        RootScope scope = new RootScope(this.currentRootScope, (Callsite)this.leaves.get((Object)invoke));
        scope.activate();
        return scope;
    }

    public boolean containsLeafCallsite(Invokable invokable) {
        return this.leaves.containsKey((Object)invokable);
    }

    public Callsite unregisterLeafCallsite(Invokable invokable) {
        return (Callsite)this.leaves.removeKey((Object)invokable);
    }

    public void registerLeafCallsite(Invokable invokable, Callsite callsite) {
        this.leaves.put((Object)invokable, (Object)callsite);
    }

    public void removeLeafCallsite(Invokable invokable) {
        Callsite callsite = this.unregisterLeafCallsite(invokable);
        assert (callsite != null) : "it must be a leaf callsite";
        assert (callsite.parent != null) : "a leaf callsite must have a parent";
        callsite.parent.children.remove(callsite);
    }

    public void trackNewCallsite(Invokable invoke) {
        assert (!this.leaves.containsKey((Object)invoke));
        Callsite currentRoot = this.findCurrentRoot();
        Callsite callsite = currentRoot.addChild(invoke, null);
        this.leaves.put((Object)invoke, (Object)callsite);
    }

    private Callsite findCurrentRoot() {
        return this.currentRootScope != null ? this.currentRootScope.replacementRoot : this.root;
    }

    public void trackDuplicatedCallsite(Invokable sibling, Invokable newInvoke, Callsite childOriginalCallsite) {
        Callsite siblingCallsite = (Callsite)this.leaves.get((Object)sibling);
        Callsite parentCallsite = siblingCallsite.parent;
        Callsite callsite = parentCallsite.addChild(newInvoke, childOriginalCallsite);
        callsite.decisions.addAll(siblingCallsite.decisions);
        this.leaves.put((Object)newInvoke, (Object)callsite);
    }

    public String formatAsTree(boolean nullIfEmpty) {
        assert (this.root.decisions.isEmpty());
        assert (!this.root.children.isEmpty() || this.leaves.isEmpty());
        if (nullIfEmpty && this.root.children.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder(512);
        InliningLog.formatAsTree(this.root, "", builder);
        return builder.toString();
    }

    private static void formatAsTree(Callsite site, String indent, StringBuilder builder) {
        String position = site.positionString();
        builder.append(indent).append(position).append(": ");
        if (site.decisions.isEmpty()) {
            if (site.parent != null) {
                builder.append("(no decisions made about ").append(site.target != null ? site.target.format("%H.%n(%p)") : "callee").append(")");
            }
            builder.append(System.lineSeparator());
        } else if (site.decisions.size() == 1) {
            builder.append(site.decisions.get(0).toString());
            builder.append(System.lineSeparator());
        } else {
            builder.append(System.lineSeparator());
            for (Decision decision : site.decisions) {
                String node = decision == site.decisions.get(site.decisions.size() - 1) ? LAST_TREE_NODE : TREE_NODE;
                builder.append(indent + "   " + node).append(decision.toString());
                builder.append(System.lineSeparator());
            }
        }
        for (Callsite child : site.children) {
            InliningLog.formatAsTree(child, indent + "  ", builder);
        }
    }

    public Callsite getRootCallsite() {
        return this.root;
    }

    public void setRootCallsite(Callsite root) {
        this.root = root;
    }

    public void inlineByTransfer(Invokable invoke, CallTargetNode callTargetNode, InliningLog calleeLog, String phase, String reason) {
        Callsite caller = (Callsite)this.leaves.get((Object)invoke);
        caller.addDecision(new Decision(true, reason, phase, invoke.getTargetMethod()));
        caller.target = callTargetNode.targetMethod;
        caller.indirect = callTargetNode.invokeKind.isIndirect();
        for (Callsite child : calleeLog.getRootCallsite().children) {
            caller.children.add(child);
            child.parent = caller;
        }
        this.leaves.removeKey((Object)invoke);
        this.leaves.putAll(calleeLog.leaves);
        calleeLog.root.children.clear();
        calleeLog.leaves.clear();
        this.checkParentPointers();
    }

    public final class UpdateScope
    implements AutoCloseable {
        private final BiConsumer<Invokable, Invokable> updater;

        private UpdateScope(BiConsumer<Invokable, Invokable> updater) {
            this.updater = updater;
        }

        public void activate() {
            if (InliningLog.this.currentUpdateScope != null) {
                throw GraalError.shouldNotReachHere("InliningLog updating already set.");
            }
            InliningLog.this.currentUpdateScope = this;
        }

        @Override
        public void close() {
            assert (InliningLog.this.currentUpdateScope != null);
            InliningLog.this.currentUpdateScope = null;
        }

        public BiConsumer<Invokable, Invokable> getUpdater() {
            return this.updater;
        }
    }

    public final class RootScope
    implements AutoCloseable {
        private final RootScope parent;
        private final Callsite replacementRoot;

        public RootScope(RootScope parent, Callsite replacementRoot) {
            this.parent = parent;
            this.replacementRoot = replacementRoot;
        }

        void activate() {
            InliningLog.this.currentRootScope = this;
        }

        public Invokable getInvoke() {
            return this.replacementRoot.invoke;
        }

        @Override
        public void close() {
            assert (InliningLog.this.currentRootScope != null);
            InliningLog.this.unregisterLeafCallsite(this.replacementRoot.invoke);
            InliningLog.this.currentRootScope = this.parent;
        }
    }

    public static final class Callsite {
        private static final int ROOT_CALLSITE_BCI = -1;
        private final List<Decision> decisions;
        private final List<Callsite> children;
        private Callsite parent;
        private Invokable invoke;
        private ResolvedJavaMethod target;
        private final int bci;
        private boolean indirect;
        private final Callsite originalCallsite;
        private JavaTypeProfile targetTypeProfile;

        Callsite(Callsite parent, Callsite originalCallsite, Invokable invoke, ResolvedJavaMethod target, int bci, boolean indirect, JavaTypeProfile targetTypeProfile) {
            this.parent = parent;
            this.bci = bci;
            this.indirect = indirect;
            this.decisions = new ArrayList<Decision>();
            this.children = new ArrayList<Callsite>();
            this.invoke = invoke;
            this.target = target;
            this.originalCallsite = originalCallsite;
            this.targetTypeProfile = targetTypeProfile;
            if (parent != null) {
                parent.children.add(this);
            }
        }

        private void addDecision(Decision decision) {
            this.decisions.add(decision);
            this.target = decision.target;
            this.indirect = !decision.positive && Callsite.invokeIsIndirect(this.invoke);
            JavaTypeProfile newTypeProfile = Callsite.targetTypeProfile(this.invoke);
            if (newTypeProfile != null) {
                this.targetTypeProfile = newTypeProfile;
            }
        }

        private static boolean invokeIsIndirect(Invokable invokable) {
            if (!(invokable instanceof Invoke)) {
                return false;
            }
            CallTargetNode callTargetNode = ((Invoke)invokable).callTarget();
            if (callTargetNode == null) {
                return false;
            }
            return callTargetNode.invokeKind.isIndirect();
        }

        private static JavaTypeProfile targetTypeProfile(Invokable invokable) {
            if (!(invokable instanceof Invoke)) {
                return null;
            }
            CallTargetNode callTarget = ((Invoke)invokable).callTarget();
            if (!(callTarget instanceof MethodCallTargetNode)) {
                return null;
            }
            return ((MethodCallTargetNode)callTarget).getTypeProfile();
        }

        private Callsite addChild(Invokable childInvoke, Callsite childOriginalCallsite) {
            return new Callsite(this, childOriginalCallsite, childInvoke, childInvoke.getTargetMethod(), childInvoke.bci(), Callsite.invokeIsIndirect(childInvoke), Callsite.targetTypeProfile(childInvoke));
        }

        public String positionString() {
            if (this.parent == null) {
                if (this.target != null) {
                    return "compilation of " + this.target.format("%H.%n(%p)");
                }
                if (this.invoke != null && this.invoke.getTargetMethod() != null) {
                    return "compilation of " + this.invoke.getTargetMethod().getName() + "(bci: " + this.getBci() + ")";
                }
                return "unknown method (bci: " + this.getBci() + ")";
            }
            Object position = this.parent.target != null ? MetaUtil.appendLocation((StringBuilder)new StringBuilder(100), (ResolvedJavaMethod)this.parent.target, (int)this.getBci()).toString() : (this.invoke != null && this.invoke.getTargetMethod() != null ? this.invoke.getTargetMethod().getName() + "(bci: " + this.getBci() + ")" : "unknown method (bci: " + this.getBci() + ")");
            return "at " + (String)position;
        }

        public List<Decision> getDecisions() {
            return this.decisions;
        }

        public List<Callsite> getChildren() {
            return this.children;
        }

        public Callsite getParent() {
            return this.parent;
        }

        public Invokable getInvoke() {
            return this.invoke;
        }

        public void setInvoke(Invokable newInvoke) {
            this.invoke = newInvoke;
        }

        public ResolvedJavaMethod getTarget() {
            return this.target;
        }

        public Callsite getOverriddenParent() {
            return this.originalCallsite == null ? this.parent : this.originalCallsite;
        }

        public Callsite getOriginalCallsite() {
            return this.originalCallsite;
        }

        public int getBci() {
            return this.bci;
        }

        public boolean isIndirect() {
            return this.indirect;
        }

        public JavaTypeProfile getTargetTypeProfile() {
            return this.targetTypeProfile;
        }

        public boolean isInlined() {
            return CollectionsUtil.anyMatch(this.decisions, Decision::isPositive);
        }
    }

    public static final class Decision {
        private final boolean positive;
        private final String reason;
        private final String phase;
        private final ResolvedJavaMethod target;

        private Decision(boolean positive, String reason, String phase, ResolvedJavaMethod target) {
            this.positive = positive;
            this.reason = reason;
            this.phase = phase;
            this.target = target;
        }

        public boolean isPositive() {
            return this.positive;
        }

        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return String.format("<%s> %s: %s, %s", this.phase, this.target != null ? this.target.format("%H.%n(%p)") : "", this.positive ? "yes" : "no", this.reason);
        }
    }

    public static final class PlaceholderInvokable
    implements Invokable {
        private final int bci;
        private final ResolvedJavaMethod callerMethod;
        private final ResolvedJavaMethod method;

        public PlaceholderInvokable(ResolvedJavaMethod callerMethod, ResolvedJavaMethod method, int bci) {
            this.callerMethod = callerMethod;
            this.method = method;
            this.bci = bci;
        }

        @Override
        public ResolvedJavaMethod getTargetMethod() {
            return this.method;
        }

        @Override
        public int bci() {
            return this.bci;
        }

        @Override
        public void setBci(int bci) {
            GraalError.unimplementedOverride();
        }

        @Override
        public FixedNode asFixedNodeOrNull() {
            return null;
        }

        @Override
        public ResolvedJavaMethod getContextMethod() {
            return this.callerMethod;
        }

        public int hashCode() {
            return Integer.hashCode(this.bci) ^ this.callerMethod.hashCode() ^ this.method.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PlaceholderInvokable) {
                PlaceholderInvokable that = (PlaceholderInvokable)obj;
                return that.bci == this.bci && that.method.equals((Object)this.method) && that.callerMethod.equals((Object)this.callerMethod);
            }
            return false;
        }

        public String toString() {
            return String.format("Invokable(caller: %s, bci: %d, method: %s)", this.callerMethod.format("%H.%n"), this.bci, this.method.format("%H.%n"));
        }
    }
}

