/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.Map;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.AbstractMemoryCheckpoint;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.UncheckedInterfaceProvider;
import jdk.vm.ci.code.BytecodeFrame;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Invoke#{p#targetMethod/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the runtime cost of a call; it's a blackhole.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="Can only dynamically decide how much code is generated based on the type of a call (special, static, virtual, interface).")
public final class InvokeNode
extends AbstractMemoryCheckpoint
implements Invoke,
LIRLowerable,
SingleMemoryKill,
UncheckedInterfaceProvider {
    public static final NodeClass<InvokeNode> TYPE = NodeClass.create(InvokeNode.class);
    @Node.OptionalInput
    ValueNode classInit;
    @Node.Input(value=InputType.Extension)
    CallTargetNode callTarget;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateDuring;
    protected int bci;
    protected boolean polymorphic;
    protected Invoke.InlineControl inlineControl;
    protected final LocationIdentity identity;
    private boolean isInOOMETry;

    public InvokeNode(CallTargetNode callTarget, int bci) {
        this(callTarget, bci, callTarget.returnStamp().getTrustedStamp());
    }

    public InvokeNode(CallTargetNode callTarget, int bci, LocationIdentity identity) {
        this(callTarget, bci, callTarget.returnStamp().getTrustedStamp(), identity);
    }

    public InvokeNode(CallTargetNode callTarget, int bci, Stamp stamp) {
        this(callTarget, bci, stamp, LocationIdentity.any());
    }

    public InvokeNode(CallTargetNode callTarget, int bci, Stamp stamp, LocationIdentity identity) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, stamp);
        this.callTarget = callTarget;
        this.bci = bci;
        this.polymorphic = false;
        this.inlineControl = Invoke.InlineControl.Normal;
        this.identity = identity;
    }

    @Override
    protected void afterClone(Node other) {
        this.updateInliningLogAfterClone(other);
    }

    @Override
    public CallTargetNode callTarget() {
        return this.callTarget;
    }

    void setCallTarget(CallTargetNode callTarget) {
        this.updateUsages(this.callTarget, callTarget);
        this.callTarget = callTarget;
    }

    @Override
    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    @Override
    public void setPolymorphic(boolean value) {
        this.polymorphic = value;
    }

    @Override
    public void setInlineControl(Invoke.InlineControl control) {
        this.inlineControl = control;
    }

    @Override
    public Invoke.InlineControl getInlineControl() {
        return this.inlineControl;
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> debugProperties = super.getDebugProperties(map);
        if (this.callTarget != null) {
            debugProperties.put("targetMethod", this.callTarget.targetName());
        }
        return debugProperties;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.identity;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.emitInvoke(this);
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Long) {
            return super.toString(Verbosity.Short) + "(bci=" + this.bci() + ")";
        }
        if (verbosity == Verbosity.Name) {
            return "Invoke#" + (this.callTarget == null ? "null" : this.callTarget().targetName());
        }
        return super.toString(verbosity);
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public void setBci(int newBci) {
        assert (BytecodeFrame.isPlaceholderBci((int)this.bci) && !BytecodeFrame.isPlaceholderBci((int)newBci)) : "can only replace placeholder with better bci";
        this.bci = newBci;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public FrameState stateDuring() {
        return this.stateDuring;
    }

    @Override
    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages(this.stateDuring, stateDuring);
        this.stateDuring = stateDuring;
    }

    @Override
    public Stamp uncheckedStamp() {
        return this.callTarget.returnStamp().getUncheckedStamp();
    }

    @Override
    public void setClassInit(ValueNode classInit) {
        this.classInit = classInit;
        this.updateUsages(null, classInit);
    }

    @Override
    public ValueNode classInit() {
        return this.classInit;
    }

    @Override
    public NodeCycles estimatedNodeCycles() {
        return InvokeNode.estimatedNodeCycles(this.callTarget);
    }

    @Override
    protected NodeSize dynamicNodeSizeEstimate() {
        return InvokeNode.estimatedNodeSize(this.callTarget);
    }

    static NodeCycles estimatedNodeCycles(CallTargetNode callTarget) {
        if (callTarget == null) {
            return NodeCycles.CYCLES_UNKNOWN;
        }
        switch (callTarget.invokeKind()) {
            case Interface: {
                return NodeCycles.CYCLES_64;
            }
            case Special: 
            case Static: {
                return NodeCycles.CYCLES_2;
            }
            case Virtual: {
                return NodeCycles.CYCLES_8;
            }
        }
        assert (false) : "Should not reach here";
        return NodeCycles.CYCLES_UNKNOWN;
    }

    static NodeSize estimatedNodeSize(CallTargetNode callTarget) {
        if (callTarget == null) {
            return NodeSize.SIZE_UNKNOWN;
        }
        switch (callTarget.invokeKind()) {
            case Interface: {
                return NodeSize.SIZE_64;
            }
            case Special: 
            case Static: {
                return NodeSize.SIZE_2;
            }
            case Virtual: {
                return NodeSize.SIZE_8;
            }
        }
        assert (false) : "Should not reach here";
        return NodeSize.SIZE_UNKNOWN;
    }

    @Override
    public boolean isInOOMETry() {
        return this.isInOOMETry;
    }

    @Override
    public void setInOOMETry(boolean isInOOMETry) {
        this.isInOOMETry = isInOOMETry;
    }
}

