/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.Map;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.InliningLog;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.UnreachableBeginNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.spi.UncheckedInterfaceProvider;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.vm.ci.code.BytecodeFrame;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Invoke!#{p#targetMethod/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the runtime cost of a call; it's a blackhole.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="Can only dynamically decide how much code is generated based on the type of a call (special, static, virtual, interface).")
public final class InvokeWithExceptionNode
extends WithExceptionNode
implements Invoke,
IterableNodeType,
SingleMemoryKill,
LIRLowerable,
UncheckedInterfaceProvider,
Simplifiable {
    public static final NodeClass<InvokeWithExceptionNode> TYPE = NodeClass.create(InvokeWithExceptionNode.class);
    @Node.OptionalInput
    ValueNode classInit;
    @Node.Input(value=InputType.Extension)
    CallTargetNode callTarget;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateDuring;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateAfter;
    protected int bci;
    protected boolean polymorphic;
    protected Invoke.InlineControl inlineControl;
    private boolean isInOOMETry;

    public InvokeWithExceptionNode(CallTargetNode callTarget, AbstractBeginNode exceptionEdge, int bci) {
        super((NodeClass<? extends WithExceptionNode>)TYPE, callTarget.returnStamp().getTrustedStamp());
        this.exceptionEdge = exceptionEdge;
        this.bci = bci;
        this.callTarget = callTarget;
        this.polymorphic = false;
        this.inlineControl = Invoke.InlineControl.Normal;
    }

    @Override
    protected void afterClone(Node other) {
        this.updateInliningLogAfterClone(other);
    }

    @Override
    public CallTargetNode callTarget() {
        return this.callTarget;
    }

    void setCallTarget(CallTargetNode callTarget) {
        this.updateUsages(this.callTarget, callTarget);
        this.callTarget = callTarget;
    }

    @Override
    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    @Override
    public void setPolymorphic(boolean value) {
        this.polymorphic = value;
    }

    @Override
    public void setInlineControl(Invoke.InlineControl control) {
        this.inlineControl = control;
    }

    @Override
    public Invoke.InlineControl getInlineControl() {
        return this.inlineControl;
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Long) {
            return super.toString(Verbosity.Short) + "(bci=" + this.bci() + ")";
        }
        if (verbosity == Verbosity.Name) {
            return "Invoke#" + (this.callTarget == null ? "null" : this.callTarget().targetName());
        }
        return super.toString(verbosity);
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public void setNext(FixedNode x) {
        if (x != null) {
            this.setNext(BeginNode.begin(x));
        } else {
            this.setNext(null);
        }
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.emitInvoke(this);
    }

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState stateAfter) {
        this.updateUsages(this.stateAfter, stateAfter);
        this.stateAfter = stateAfter;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> debugProperties = super.getDebugProperties(map);
        if (this.callTarget != null) {
            debugProperties.put("targetMethod", this.callTarget.targetName());
        }
        return debugProperties;
    }

    @Override
    public void setBci(int newBci) {
        assert (BytecodeFrame.isPlaceholderBci((int)this.bci) && !BytecodeFrame.isPlaceholderBci((int)newBci)) : "can only replace placeholder with better bci";
        this.bci = newBci;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public FrameState stateDuring() {
        return this.stateDuring;
    }

    @Override
    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages(this.stateDuring, stateDuring);
        this.stateDuring = stateDuring;
    }

    @Override
    public Stamp uncheckedStamp() {
        return this.callTarget.returnStamp().getUncheckedStamp();
    }

    @Override
    public void setClassInit(ValueNode classInit) {
        this.classInit = classInit;
        this.updateUsages(null, classInit);
    }

    @Override
    public ValueNode classInit() {
        return this.classInit;
    }

    public InvokeNode replaceWithInvoke() {
        try (InliningLog.UpdateScope updateScope = InliningLog.openUpdateScopeTrackingReplacement(this.graph().getInliningLog(), this);){
            InvokeNode newInvoke = this.graph().add(new InvokeNode(this.callTarget, this.bci, this.stamp, this.getKilledLocationIdentity()));
            newInvoke.setStateAfter(this.stateAfter);
            newInvoke.setStateDuring(this.stateDuring);
            newInvoke.setInlineControl(this.inlineControl);
            AbstractBeginNode oldException = this.exceptionEdge;
            this.graph().replaceSplitWithFixed(this, newInvoke, (AbstractBeginNode)this.next());
            GraphUtil.killCFG(oldException);
            newInvoke.setNodeSourcePosition(this.getNodeSourcePosition());
            InvokeNode invokeNode = newInvoke;
            return invokeNode;
        }
    }

    @Override
    public InvokeNode replaceWithNonThrowing() {
        return this.replaceWithInvoke();
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.exceptionEdge() instanceof UnreachableBeginNode) {
            this.replaceWithInvoke();
        }
    }

    @Override
    public NodeCycles estimatedNodeCycles() {
        return InvokeNode.estimatedNodeCycles(this.callTarget);
    }

    @Override
    protected NodeSize dynamicNodeSizeEstimate() {
        return InvokeNode.estimatedNodeSize(this.callTarget);
    }

    @Override
    public boolean isInOOMETry() {
        return this.isInOOMETry;
    }

    @Override
    public void setInOOMETry(boolean isInOOMETry) {
        this.isInOOMETry = isInOOMETry;
    }
}

