/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.LIRLowerableLogicNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;

@NodeInfo(nameTemplate="{p#value}", cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class LogicConstantNode
extends LIRLowerableLogicNode
implements LIRLowerable {
    public static final NodeClass<LogicConstantNode> TYPE = NodeClass.create(LogicConstantNode.class);
    protected final boolean value;

    public LogicConstantNode(boolean value) {
        super((NodeClass<? extends LIRLowerableLogicNode>)TYPE);
        this.value = value;
    }

    public static LogicConstantNode forBoolean(boolean v, Graph graph) {
        return graph.unique(new LogicConstantNode(v));
    }

    public static LogicConstantNode forBoolean(boolean v) {
        return new LogicConstantNode(v);
    }

    public static LogicConstantNode tautology(Graph graph) {
        return LogicConstantNode.forBoolean(true, graph);
    }

    public static LogicConstantNode contradiction(Graph graph) {
        return LogicConstantNode.forBoolean(false, graph);
    }

    public static LogicConstantNode tautology() {
        return LogicConstantNode.forBoolean(true);
    }

    public static LogicConstantNode contradiction() {
        return LogicConstantNode.forBoolean(false);
    }

    public boolean getValue() {
        return this.value;
    }
}

