/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.vm.ci.meta.TriState;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class LogicNegationNode
extends LogicNode
implements Canonicalizable.Unary<LogicNode> {
    public static final NodeClass<LogicNegationNode> TYPE = NodeClass.create(LogicNegationNode.class);
    @Node.Input(value=InputType.Condition)
    LogicNode value;

    protected LogicNegationNode(LogicNode value) {
        super((NodeClass<? extends LogicNode>)TYPE);
        this.value = value;
    }

    public static LogicNode create(LogicNode value) {
        LogicNode synonym = LogicNegationNode.findSynonym(value);
        if (synonym != null) {
            return synonym;
        }
        return new LogicNegationNode(value);
    }

    private static LogicNode findSynonym(LogicNode value) {
        if (value instanceof LogicConstantNode) {
            LogicConstantNode logicConstantNode = (LogicConstantNode)value;
            return LogicConstantNode.forBoolean(!logicConstantNode.getValue());
        }
        if (value instanceof LogicNegationNode) {
            return ((LogicNegationNode)value).getValue();
        }
        return null;
    }

    @Override
    public LogicNode getValue() {
        return this.value;
    }

    public LogicNode canonical(CanonicalizerTool tool, LogicNode forValue) {
        LogicNode synonym = LogicNegationNode.findSynonym(forValue);
        if (synonym != null) {
            return synonym;
        }
        return this;
    }

    @Override
    public TriState implies(boolean thisNegated, LogicNode other) {
        if (other == this.getValue()) {
            return TriState.get((boolean)thisNegated);
        }
        return this.getValue().implies(!thisNegated, other);
    }
}

