/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.ShortCircuitOrNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.vm.ci.meta.TriState;

@NodeInfo(allowedUsageTypes={InputType.Condition}, size=NodeSize.SIZE_1)
public abstract class LogicNode
extends FloatingNode
implements Node.IndirectInputChangedCanonicalization {
    public static final NodeClass<LogicNode> TYPE = NodeClass.create(LogicNode.class);

    public LogicNode(NodeClass<? extends LogicNode> c) {
        super((NodeClass<? extends FloatingNode>)c, StampFactory.forVoid());
    }

    public static LogicNode and(LogicNode a, LogicNode b, ProfileData.BranchProbabilityData shortCircuitProbability) {
        return LogicNode.and(a, false, b, false, shortCircuitProbability);
    }

    public static LogicNode and(LogicNode a, boolean negateA, LogicNode b, boolean negateB, ProfileData.BranchProbabilityData shortCircuitProbability) {
        StructuredGraph graph = a.graph();
        LogicNode notAorNotB = graph.addOrUniqueWithInputs(ShortCircuitOrNode.create(a, !negateA, b, !negateB, shortCircuitProbability));
        return graph.addOrUniqueWithInputs(LogicNegationNode.create(notAorNotB));
    }

    public static LogicNode or(LogicNode a, LogicNode b, ProfileData.BranchProbabilityData shortCircuitProbability) {
        return LogicNode.or(a, false, b, false, shortCircuitProbability);
    }

    public static LogicNode or(LogicNode a, boolean negateA, LogicNode b, boolean negateB, ProfileData.BranchProbabilityData shortCircuitProbability) {
        return a.graph().unique(new ShortCircuitOrNode(a, negateA, b, negateB, shortCircuitProbability));
    }

    public final boolean isTautology() {
        if (this instanceof LogicConstantNode) {
            LogicConstantNode logicConstantNode = (LogicConstantNode)this;
            return logicConstantNode.getValue();
        }
        return false;
    }

    public final boolean isContradiction() {
        if (this instanceof LogicConstantNode) {
            LogicConstantNode logicConstantNode = (LogicConstantNode)this;
            return !logicConstantNode.getValue();
        }
        return false;
    }

    public TriState implies(boolean thisNegated, LogicNode other) {
        if (this == other) {
            return TriState.get((!thisNegated ? 1 : 0) != 0);
        }
        if (other instanceof LogicNegationNode) {
            return LogicNode.flip(this.implies(thisNegated, ((LogicNegationNode)other).getValue()));
        }
        return TriState.UNKNOWN;
    }

    private static TriState flip(TriState triState) {
        return triState.isUnknown() ? triState : TriState.get((!triState.toBoolean() ? 1 : 0) != 0);
    }
}

