/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.BeginStateSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.GraphUtil;

@NodeInfo(allowedUsageTypes={InputType.Association}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_4)
public final class LoopExitNode
extends BeginStateSplitNode
implements IterableNodeType,
Simplifiable {
    public static final NodeClass<LoopExitNode> TYPE = NodeClass.create(LoopExitNode.class);
    @Node.Input(value=InputType.Association)
    AbstractBeginNode loopBegin;
    public static final String ErrorMessagePredecessorSplit = "Predecessor must not be a control split node that can be used as value node as that could mean scheduling of proxy nodes goes wrong";

    public LoopExitNode(LoopBeginNode loop) {
        super((NodeClass<? extends BeginStateSplitNode>)TYPE);
        assert (loop != null);
        this.loopBegin = loop;
    }

    public LoopBeginNode loopBegin() {
        return (LoopBeginNode)this.loopBegin;
    }

    public void setLoopBegin(AbstractBeginNode loopBegin) {
        this.updateUsages(this.loopBegin, loopBegin);
        this.loopBegin = loopBegin;
    }

    @Override
    public NodeIterable<Node> anchored() {
        return super.anchored().filter(n -> {
            if (n instanceof ProxyNode) {
                ProxyNode proxyNode = (ProxyNode)n;
                return proxyNode.proxyPoint() != this;
            }
            return true;
        });
    }

    @Override
    public void prepareDelete(FixedNode evacuateFrom) {
        this.removeProxies();
        super.prepareDelete(evacuateFrom);
    }

    public void removeProxies() {
        if (this.hasUsages()) {
            block0: while (true) {
                CompilationAlarm.checkProgress(this.graph());
                for (ProxyNode vpn : this.proxies().snapshot()) {
                    ValueNode value = vpn.value();
                    vpn.replaceAtUsagesAndDelete(value);
                    if (value != this) continue;
                    continue block0;
                }
                break;
            }
        }
    }

    public NodeIterable<ProxyNode> proxies() {
        return this.usages().filter(n -> {
            if (n instanceof ProxyNode) {
                ProxyNode proxyNode = (ProxyNode)n;
                return proxyNode.proxyPoint() == this;
            }
            return false;
        });
    }

    public void removeExit() {
        this.removeExit(false);
    }

    public void removeExit(boolean forKillCFG) {
        this.removeProxies();
        FrameState loopStateAfter = this.stateAfter();
        if (!forKillCFG || this.predecessor() != null) {
            this.graph().replaceFixedWithFixed(this, this.graph().add(new BeginNode()));
        }
        if (this.isAlive()) {
            this.setLoopBegin(null);
        }
        if (loopStateAfter != null) {
            GraphUtil.tryKillUnused(loopStateAfter);
        }
    }

    @Override
    public void simplify(SimplifierTool tool) {
        Node prev = this.predecessor();
        while (tool.allUsagesAvailable() && prev instanceof BeginNode && prev.hasNoUsages()) {
            AbstractBeginNode begin = (AbstractBeginNode)prev;
            if (prev.predecessor() instanceof WithExceptionNode) break;
            this.setNodeSourcePosition(begin.getNodeSourcePosition());
            this.graph().removeFixed(begin);
            prev = prev.predecessor();
        }
    }

    @Override
    public boolean verifyNode() {
        assert (!this.graph().getGraphState().getFrameStateVerification().implies(GraphState.FrameStateVerificationFeature.LOOP_EXITS) || this.stateAfter != null) : "Loop exit must have a state until FSA " + String.valueOf(this);
        assert (!(this.predecessor() instanceof InvokeWithExceptionNode)) : Assertions.errorMessageContext("Predecessor must not be a control split node that can be used as value node as that could mean scheduling of proxy nodes goes wrong", this.predecessor());
        return super.verifyNode();
    }
}

