/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.MemoryPhiNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, nameTemplate="MemoryProxy({i#value})")
public final class MemoryProxyNode
extends ProxyNode
implements SingleMemoryKill {
    public static final NodeClass<MemoryProxyNode> TYPE = NodeClass.create(MemoryProxyNode.class);
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill value;
    protected final LocationIdentity locationIdentity;

    public MemoryProxyNode(MemoryKill value, LoopExitNode proxyPoint, LocationIdentity locationIdentity) {
        super(TYPE, StampFactory.forVoid(), proxyPoint);
        this.value = value;
        this.locationIdentity = locationIdentity;
    }

    @Override
    public ValueNode value() {
        return this.value == null ? null : this.value.asNode();
    }

    @Override
    public PhiNode createPhi(AbstractMergeNode merge) {
        return this.graph().addWithoutUnique(new MemoryPhiNode(merge, this.locationIdentity));
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.locationIdentity;
    }

    @Override
    public ProxyNode duplicateOn(LoopExitNode newProxyPoint, ValueNode newOriginalNode) {
        assert (MemoryKill.isMemoryKill(newOriginalNode));
        return this.graph().addWithoutUniqueWithInputs(new MemoryProxyNode((MemoryKill)((Object)newOriginalNode), newProxyPoint, this.getKilledLocationIdentity()));
    }
}

